/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryPageSite;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExtContributionItem;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IMenuProvider;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;

public final class HistoryPageHost
extends HistoryPage {
    private IPartFactory factory;
    private AbstractPart part;
    private IRefreshable refreshable;
    private HistoryPageSite site;
    private IReusablePart reusablePart;
    private Object initialInput;
    private IMenuProvider menuProvider;
    private Composite control;
    private IHistoryPageSource source;
    private IPropertyChangeListener historyView;

    public HistoryPageHost(IPartFactory factory, Object initialInput, IHistoryPageSource source) {
        this.factory = factory;
        this.initialInput = initialInput;
        this.source = source;
    }

    public boolean inputSet() {
        return this.getInput() != null;
    }

    public boolean setInput(Object object) {
        if (this.reusablePart != null) {
            this.reusablePart.setInput(object);
        }
        return super.setInput(object);
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 262144);
        this.site = new HistoryPageSite(this.control, this.getHistoryPageSite(), this);
        this.part = this.factory.createPart((IControlSite)this.site, this.initialInput);
        this.refreshable = (IRefreshable)Adapters.getAdapter((Object)this.part, IRefreshable.class);
        this.reusablePart = (IReusablePart)Adapters.getAdapter((Object)this.part, IReusablePart.class);
        this.menuProvider = (IMenuProvider)Adapters.getAdapter((Object)this.part, IMenuProvider.class);
        IWorkbenchPart activePart = this.getSite().getPage().getActivePart();
        if (activePart instanceof IPropertyChangeListener && activePart instanceof IHistoryView) {
            this.historyView = (IPropertyChangeListener)activePart;
            this.addPropertyChangeListener(this.historyView);
        }
        if (this.menuProvider != null) {
            IPageSite workbenchPageSite;
            IToolBarManager toolbarManager = this.getHistoryPageSite().getToolBarManager();
            if (toolbarManager != null) {
                MenuExtContributionItem toolbarContribution = new MenuExtContributionItem();
                toolbarContribution.setMenu(this.menuProvider.getToolbarContributions());
                toolbarManager.add((IContributionItem)toolbarContribution);
            }
            if ((workbenchPageSite = this.getHistoryPageSite().getWorkbenchPageSite()) != null) {
                IActionBars actionBars = workbenchPageSite.getActionBars();
                MenuExtContributionItem menuContribution = new MenuExtContributionItem();
                menuContribution.setMenu(this.menuProvider.getMenuContributions());
                actionBars.getMenuManager().add((IContributionItem)menuContribution);
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public String getDescription() {
        return this.site.getDescription();
    }

    public String getName() {
        return this.site.getDescription();
    }

    public boolean isValidInput(Object object) {
        return this.source.canShowHistoryFor(object);
    }

    public void dispose() {
        super.dispose();
        if (this.historyView != null) {
            this.removePropertyChangeListener(this.historyView);
        }
    }

    public void refresh() {
        if (this.refreshable != null && this.refreshable.canRefresh()) {
            this.refreshable.refresh();
        }
    }

    public Object getAdapter(Class adapter) {
        return Adapters.getAdapter((Object)this.part, (Class)adapter);
    }

    void doFirePropertyChange(String property, Object oldValue, Object newValue) {
        this.firePropertyChange((Object)this, property, oldValue, newValue);
    }
}

