/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.DecoratedChangeSetLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.MixedTypeLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class HistoryEntryLabelProvider
extends BaseLabelProvider {
    private Font boldFont;
    private ConvertingLabelProvider clp;
    private boolean combinedMode;
    private ILabelProviderListener clpListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            HistoryEntryLabelProvider.this.fireChangeEvent(event.getElements());
        }
    };

    public HistoryEntryLabelProvider(ISetWithListeners<IHistoryEntry> elements, boolean isCominbedMode, IOperationRunner operationRunner) {
        this.combinedMode = isCominbedMode;
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        FontRegistry fontRegistry = theme.getFontRegistry();
        this.boldFont = this.getFont(fontRegistry.getDescriptor("org.eclipse.jface.defaultfont").withStyle(1));
        SlowFunction<IHistoryEntry, Object> conversion = new SlowFunction<IHistoryEntry, Object>(elements, operationRunner, Display.getCurrent(), true){

            protected Map<IHistoryEntry, Object> doFetch(Collection<IHistoryEntry> toFetch, IProgressMonitor reporter) throws OperationFailedException {
                HashMap<IHistoryEntry, Object> result = new HashMap<IHistoryEntry, Object>();
                for (IHistoryEntry next : toFetch) {
                    if (next.getChangeSet() != null) {
                        result.put(next, (Object)next.getChangeSet());
                    }
                    if (next.getBaseline() == null) continue;
                    ITeamRepository repo = next.getRepository();
                    ItemId component = new ItemId((IItemHandle)next.getBaseline().getComponent());
                    try {
                        BaselineWrapper bw = new BaselineWrapper(next.getRepository(), next.getBaseline(), (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)component, null));
                        result.put(next, bw);
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)((Object)this), (Throwable)e);
                    }
                }
                return result;
            }

            protected Object getDefaultValue() {
                return null;
            }

            protected String getOperationName() {
                return Messages.HistoryEntryLabelProvider_0;
            }
        };
        FilteredSetWithListeners changeSets = FilteredSetWithListeners.createTypeFilter((ISetWithListeners)conversion.getRange(), ChangeSetWrapper.class);
        DecoratedChangeSetLabelProvider decoratedLabelProvider = isCominbedMode ? new DecoratedChangeSetLabelProvider(Messages.DecoratedChangeSetLabelProvider_indentedWorkItemComment, Messages.DecoratedChangeSetLabelProvider_indentedWorkItem, Messages.DecoratedChangeSetLabelProvider_indentedComment, Messages.DecoratedChangeSetLabelProvider_indentedNone, false, (ISetWithListeners<ChangeSetWrapper>)changeSets, operationRunner) : new DecoratedChangeSetLabelProvider(Messages.DecoratedChangeSetLabelProvider_workItemComment, Messages.DecoratedChangeSetLabelProvider_workItem, Messages.DecoratedChangeSetLabelProvider_comment, Messages.DecoratedChangeSetLabelProvider_none, false, (ISetWithListeners<ChangeSetWrapper>)changeSets, operationRunner);
        MixedTypeLabelProvider wrapperLabelProvider = new MixedTypeLabelProvider().put(ChangeSetWrapper.class, (IViewerLabelProvider)decoratedLabelProvider).put(BaselineWrapper.class, (IViewerLabelProvider)new BaselineLabelProvider(false));
        this.clp = new ConvertingLabelProvider((IViewerLabelProvider)wrapperLabelProvider, (IDynamicFunction)conversion);
        this.clp.addListener(this.clpListener);
    }

    public void dispose() {
        this.clp.removeListener(this.clpListener);
        this.clp.dispose();
        super.dispose();
    }

    public void updateLabel(ViewerLabel label, Object element) {
        IHistoryEntry entry = (IHistoryEntry)element;
        if (this.combinedMode && !entry.getBaselineHandle().isNull()) {
            label.setFont(this.boldFont);
        }
        this.clp.updateLabel(label, element);
    }
}

