/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.internal.filesystem.ui.views.history.MergeInfo;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import java.util.HashSet;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class GraphPaintListener
implements Listener {
    private static boolean antialiasPermitted = true;
    private RGB[] currentColors = new RGB[0];
    private Color[] allocatedColors;
    private Color conflictColor;
    private int totalLinesOfDescent = 0;
    private boolean hasConflict = false;
    private Control control;
    private ResourceManager resources;

    public GraphPaintListener(Control control, ResourceManager resources) {
        this.control = control;
        this.resources = resources;
    }

    public void setTotalLinesOfDescent(int totalLinesOfDescent) {
        this.setTotalLinesOfDescent(totalLinesOfDescent, false);
    }

    public void setTotalLinesOfDescent(int totalLinesOfDescent, boolean hasConflict) {
        this.totalLinesOfDescent = totalLinesOfDescent;
        if (this.conflictColor == null) {
            this.conflictColor = this.resources.createColor(new RGB(255, 0, 0));
        }
        RGB[] oldContrastingColors = this.currentColors;
        boolean changeColors = false;
        if (this.hasConflict != hasConflict) {
            this.hasConflict = hasConflict;
            changeColors = true;
        }
        if (oldContrastingColors.length != totalLinesOfDescent || changeColors) {
            RGB backgroundColor = this.control.getBackground().getRGB();
            RGB[] newContrastingColors = SWTUtil.chooseContrastingColors((RGB)backgroundColor, (int)totalLinesOfDescent, (boolean)this.hasConflict);
            HashSet<RGB> unselectedColors = new HashSet<RGB>();
            int idx = 0;
            while (idx < newContrastingColors.length) {
                unselectedColors.add(newContrastingColors[idx]);
                ++idx;
            }
            RGB currentColor = backgroundColor;
            Color[] colors = new Color[totalLinesOfDescent];
            int idx2 = 0;
            while (idx2 < totalLinesOfDescent) {
                RGB nextColor = this.pickFarthestColor(unselectedColors, currentColor);
                unselectedColors.remove(nextColor);
                currentColor = nextColor;
                colors[idx2] = this.resources.createColor(nextColor);
                ++idx2;
            }
            this.allocatedColors = colors;
            this.currentColors = newContrastingColors;
            this.control.redraw();
            idx2 = 0;
            while (idx2 < oldContrastingColors.length) {
                this.resources.destroyColor(oldContrastingColors[idx2]);
                ++idx2;
            }
        }
    }

    protected RGB pickFarthestColor(HashSet<RGB> unselectedColors, RGB currentColor) {
        RGB farthest = currentColor;
        int farthestDistance = 0;
        for (RGB next : unselectedColors) {
            int distance = this.sqr(currentColor.red - next.red) + this.sqr(currentColor.green - next.green) + this.sqr(currentColor.blue - next.blue);
            if (distance < farthestDistance) continue;
            farthestDistance = distance;
            farthest = next;
        }
        return farthest;
    }

    private int sqr(int i) {
        return i * i;
    }

    private Color getColorFor(Color defaultColour, int column) {
        if (this.allocatedColors != null && this.allocatedColors.length > column) {
            return this.allocatedColors[column];
        }
        return defaultColour;
    }

    protected abstract MergeInfo getMergeInfo(Object var1);

    public void handleEvent(Event event) {
        if (this.totalLinesOfDescent < 1) {
            return;
        }
        boolean forwards = true;
        Widget item = event.item;
        Object data = item.getData();
        MergeInfo mergeInfo = this.getMergeInfo(data);
        if (mergeInfo != null) {
            TableItem ti = (TableItem)item;
            Table table = ti.getParent();
            TableColumn tc = table.getColumn(event.index);
            int maxSpacing = table.getItemHeight();
            int tableItemTopHidden = ti.getBounds().y < 0 ? ti.getBounds().y : 0;
            Rectangle rect = new Rectangle(event.x, event.y, tc.getWidth(), event.height);
            GC gc = event.gc;
            if (antialiasPermitted) {
                try {
                    gc.setClipping(rect.x, rect.y - tableItemTopHidden, rect.width, rect.height);
                    gc.setAntialias(1);
                }
                catch (SWTException e) {
                    if (e.code == 16) {
                        antialiasPermitted = false;
                    }
                    throw e;
                }
            }
            gc.setLineWidth(2);
            gc.setLineStyle(1);
            MergeInfo upperRow = mergeInfo.getNextInHistory();
            if (upperRow != null) {
                Rectangle rect2 = new Rectangle(rect.x, rect.y - maxSpacing, rect.width, rect.height);
                this.drawLowerLines(gc, upperRow, rect2, forwards, maxSpacing);
            }
            this.drawLowerLines(gc, mergeInfo, rect, forwards, maxSpacing);
            event.detail &= 0xFFFFFFEF;
        }
    }

    private void drawLowerLines(GC gc, MergeInfo mergeInfo, Rectangle rect, boolean forwards, int maxSpacing) {
        int i;
        int leadIn = 0;
        int availableWidth = rect.width - leadIn;
        int separation = Math.min(availableWidth / this.totalLinesOfDescent, maxSpacing);
        int ymiddle = rect.y + rect.height / 2;
        int ystart = rect.y;
        int yend = ymiddle + rect.height + 1;
        if (!forwards) {
            int oldYStart = ystart;
            ystart = yend;
            yend = oldYStart;
            ymiddle = rect.y + rect.height - (ymiddle - rect.y);
        }
        Color oldBackground = gc.getBackground();
        Color oldForeground = gc.getForeground();
        int firstColumnStart = rect.x + leadIn + separation / 2;
        int nodeIdx = mergeInfo.getCurrentBranch();
        int nodex = firstColumnStart + separation * nodeIdx;
        int branchx = firstColumnStart + separation * nodeIdx;
        int sameMerge = mergeInfo.getUnchangedMerge();
        int[] merges = mergeInfo.getMerges();
        int[] branches = mergeInfo.getBranches();
        if (nodeIdx != -1) {
            i = 0;
            while (i < merges.length) {
                int merge = merges[i];
                int mergex = firstColumnStart + separation * merge;
                if (sameMerge != -1 && merge != sameMerge) {
                    gc.setLineStyle(3);
                } else {
                    gc.setLineStyle(1);
                }
                if (merges.length == 1) {
                    gc.setForeground(this.getColorFor(oldForeground, nodeIdx));
                } else {
                    gc.setForeground(this.getColorFor(oldForeground, merge));
                }
                gc.drawLine(mergex, yend, nodex, ymiddle);
                ++i;
            }
        }
        gc.setLineStyle(1);
        i = 0;
        while (i < branches.length) {
            int direct = branches[i];
            if (direct != -1) {
                int endx = firstColumnStart + separation * direct;
                int startx = firstColumnStart + separation * i;
                gc.setForeground(this.getColorFor(oldForeground, i));
                gc.drawLine(startx, ymiddle, endx, yend);
            }
            ++i;
        }
        if (nodeIdx != -1) {
            int circleRadius = 3;
            if (mergeInfo.isConflictPoint()) {
                gc.setBackground(this.conflictColor);
            } else {
                gc.setBackground(this.getColorFor(oldForeground, nodeIdx));
            }
            gc.fillRectangle(branchx - circleRadius, ymiddle - circleRadius, circleRadius * 2 + 1, circleRadius * 2 + 1);
            if (mergeInfo.isConflictPoint()) {
                gc.setBackground(this.conflictColor);
                gc.fillRectangle(branchx - circleRadius - 2, ymiddle - circleRadius - 2, circleRadius * 2 + 1, circleRadius * 2 + 1);
                gc.setBackground(this.getColorFor(oldForeground, nodeIdx));
                circleRadius = 3;
                gc.fillRectangle(branchx - circleRadius, ymiddle - circleRadius, circleRadius * 2 - 1, circleRadius * 2 - 1);
            }
            gc.setBackground(oldBackground);
        }
    }
}

