/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.history;

import com.ibm.team.filesystem.client.internal.namespace.ItemFetcher;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.ProjectAreaWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamAreaWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;

public abstract class ContributorFunction<K>
extends SlowFunction<K, AbstractWrapper> {
    public ContributorFunction(ISetWithListeners domain, IOperationRunner runner) {
        super(domain, runner, Display.getCurrent(), true);
    }

    protected abstract ItemLocator getContributor(K var1) throws TeamRepositoryException;

    protected Map<K, ItemLocator<IAuditable>> getContributors(Collection<K> elements, IProgressMonitor monitor) throws TeamRepositoryException {
        return Collections.emptyMap();
    }

    protected boolean shouldBatch() {
        return false;
    }

    protected String getOperationName() {
        return Messages.ContributorFunction_operationName;
    }

    protected ContributorWrapper getDefaultValue() {
        return null;
    }

    protected Map<K, AbstractWrapper> doFetch(Collection<K> toFetch, IProgressMonitor reporter) throws OperationFailedException {
        SubMonitor rep = SubMonitor.convert((IProgressMonitor)reporter, (int)(toFetch.size() * 2));
        Map<K, Object> contributorMap = new HashMap();
        Collection<Object> contributorHandles = NewCollection.arrayList();
        try {
            if (this.shouldBatch()) {
                contributorMap = this.getContributors(toFetch, (IProgressMonitor)rep.newChild(1));
                contributorHandles = contributorMap.values();
            } else {
                for (K next : toFetch) {
                    ItemLocator locator = this.getContributor(next);
                    if (locator == null) continue;
                    contributorHandles.add(locator);
                    contributorMap.put(next, locator);
                }
            }
            Map contributors = ItemFetcher.fetchCurrents((Collection)contributorHandles, (boolean)false, (IProgressMonitor)rep.newChild(toFetch.size()));
            HashMap result = NewCollection.hashMap();
            for (K next : toFetch) {
                ItemLocator locator = (ItemLocator)contributorMap.get(next);
                if (locator == null) continue;
                IAuditable contributor = (IAuditable)contributors.get(locator);
                AbstractWrapper wrapper = ContributorFunction.fromOwner(contributor, locator.getRepository());
                result.put(next, wrapper);
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }

    public static AbstractWrapper fromOwner(IAuditable contributor, ITeamRepository repo) {
        if (contributor instanceof IContributor) {
            return new ContributorWrapper(repo, (IContributor)contributor);
        }
        if (contributor instanceof ITeamArea) {
            return new TeamAreaWrapper(repo, (ITeamArea)contributor);
        }
        if (contributor instanceof IProjectArea) {
            return new ProjectAreaWrapper(repo, (IProjectArea)contributor);
        }
        return null;
    }
}

