/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.properties;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.SetPropertyCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisDiagramEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.UserConnectionEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.UserConnection;
import com.ibm.team.internal.filesystem.ui.views.flowvis.properties.IntegerVerifyListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class UserConnectionPropertySection
extends AbstractPropertySection {
    private UserConnectionEditPart connectionEditPart;
    private Text lineWidth;
    private CCombo lineStyle;
    private Button targetDecoration;

    public void aboutToBeHidden() {
    }

    public void aboutToBeShown() {
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = this.getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        widgetFactory.createLabel(composite, Messages.UserConnectionPropertySection_0);
        this.lineWidth = widgetFactory.createText(composite, "");
        this.lineWidth.addVerifyListener((VerifyListener)new IntegerVerifyListener(0, 10));
        this.lineWidth.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                UserConnectionPropertySection.this.setLineWidth();
            }
        });
        this.lineWidth.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    UserConnectionPropertySection.this.setLineWidth();
                }
            }
        });
        widgetFactory.createLabel(composite, Messages.UserConnectionPropertySection_2);
        this.lineStyle = widgetFactory.createCCombo(composite);
        final Object[][] comboData = new Object[][]{{Messages.UserConnectionPropertySection_3, 1}, {Messages.UserConnectionPropertySection_4, 2}};
        int i = 0;
        while (i < comboData.length) {
            Object[] data = comboData[i];
            this.lineStyle.add(data[0].toString());
            this.lineStyle.setData(data[1].toString(), (Object)i);
            ++i;
        }
        this.lineStyle.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Integer style = (Integer)comboData[UserConnectionPropertySection.this.lineStyle.getSelectionIndex()][1];
                UserConnectionPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand((FlowVisModel)UserConnectionPropertySection.this.connectionEditPart.getModel2(), (Object)UserConnection.PropertyId.LINE_STYLE, style, Messages.UserConnectionPropertySection_5));
                UserConnection.s_lineStyle = style;
            }
        });
        this.targetDecoration = widgetFactory.createButton(composite, Messages.UserConnectionPropertySection_6, 32);
        this.targetDecoration.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean arrow = UserConnectionPropertySection.this.targetDecoration.getSelection();
                UserConnectionPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand((FlowVisModel)UserConnectionPropertySection.this.connectionEditPart.getModel2(), (Object)UserConnection.PropertyId.TARGET_DECORATION, arrow, Messages.UserConnectionPropertySection_7));
                UserConnection.s_targetDecoration = arrow;
            }
        });
        Composite lineColorComposite = widgetFactory.createComposite(composite);
        Button lineColor = widgetFactory.createButton(lineColorComposite, Messages.UserConnectionPropertySection_8, 8);
        lineColor.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FlowVisDiagram diagram = UserConnectionPropertySection.this.getDiagram();
                UserConnection noteConnection = (UserConnection)UserConnectionPropertySection.this.connectionEditPart.getModel2();
                int[] c = noteConnection.getColor();
                ColorDialog dialog = new ColorDialog(diagram.getUtil().getShell());
                dialog.setRGB(new RGB(c[0], c[1], c[2]));
                RGB rgb = dialog.open();
                if (rgb != null) {
                    int[] rgbvals = new int[]{rgb.red, rgb.green, rgb.blue};
                    diagram.getUtil().getCommandStack().execute((Command)new SetPropertyCommand(noteConnection, (Object)UserConnection.PropertyId.COLOR, rgbvals, Messages.UserConnectionPropertySection_9));
                    UserConnection.s_color = rgbvals;
                }
            }
        });
        GridLayoutFactory.fillDefaults().spacing(5, 4).numColumns(2).generateLayout(lineColorComposite);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)lineColorComposite);
        GridLayoutFactory.fillDefaults().margins(6, 6).spacing(5, 4).numColumns(2).generateLayout(composite);
    }

    public void refresh() {
        this.refreshLineWidth();
        this.refreshLineStyle();
        this.refreshTargetDecoration();
    }

    private void refreshLineWidth() {
        this.lineWidth.setText(Integer.toString(((UserConnection)this.connectionEditPart.getModel2()).getLineWidth()));
    }

    private void refreshLineStyle() {
        int index = 0;
        int style = ((UserConnection)this.connectionEditPart.getModel2()).getLineStyle();
        Object indexObj = this.lineStyle.getData(Integer.toString(style));
        if (indexObj != null && indexObj instanceof Integer) {
            index = (Integer)indexObj;
        }
        this.lineStyle.select(index);
    }

    private void refreshTargetDecoration() {
        this.targetDecoration.setSelection(((UserConnection)this.connectionEditPart.getModel2()).getTargetDecoration());
    }

    private void setLineWidth() {
        Integer line = IntegerVerifyListener.verifyInteger(this.lineWidth.getText(), -1, null);
        UserConnection noteConnection = (UserConnection)this.connectionEditPart.getModel2();
        if (line != null && line.intValue() != noteConnection.getLineWidth()) {
            this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(noteConnection, (Object)UserConnection.PropertyId.LINE_WIDTH, line, Messages.UserConnectionPropertySection_10));
            UserConnection.s_lineWidth = line;
        } else {
            this.refreshLineWidth();
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object input;
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            input = sSelection.getFirstElement();
            if (!(input instanceof UserConnectionEditPart)) {
                throw new IllegalArgumentException(input.getClass().toString());
            }
        } else {
            throw new IllegalArgumentException(selection.getClass().toString());
        }
        this.connectionEditPart = (UserConnectionEditPart)input;
    }

    private FlowVisDiagram getDiagram() {
        EditPart editPart = this.connectionEditPart.getSource();
        FlowVisDiagramEditPart flowVisDiagramEditPart = (FlowVisDiagramEditPart)editPart.getParent();
        FlowVisDiagram diagram = (FlowVisDiagram)flowVisDiagramEditPart.getModel2();
        return diagram;
    }
}

