/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.properties;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.SetPropertyCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class FlowNodePropertySection
extends AbstractPropertySection
implements Observer {
    private FlowNodeEditPart flowNodeEditPart;
    private Label name;
    private Label owner;
    private Button showNameOrOwner;
    private Label visibleCollaborationsLabel;
    private CheckboxTableViewer viewer;
    private List<Observable> observables = new ArrayList<Observable>();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = this.getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        Composite nameComposite = widgetFactory.createComposite(composite);
        widgetFactory.createCLabel(nameComposite, Messages.FlowNodePropertySection_0);
        this.name = widgetFactory.createLabel(nameComposite, "");
        widgetFactory.createCLabel(nameComposite, Messages.FlowNodePropertySection_2);
        this.owner = widgetFactory.createLabel(nameComposite, "");
        GridLayoutFactory.fillDefaults().spacing(5, 4).numColumns(2).generateLayout(nameComposite);
        this.showNameOrOwner = widgetFactory.createButton(composite, "", 32);
        this.showNameOrOwner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean showNameInsteadOfOwner = FlowNodePropertySection.this.showNameOrOwner.getSelection();
                String label = showNameInsteadOfOwner ? Messages.FlowNodePropertySection_5 : Messages.FlowNodePropertySection_6;
                FlowNode flowNode = FlowNodePropertySection.this.getFlowNode();
                FlowNode.PropertyId propertyId = flowNode.isStream() ? FlowNode.PropertyId.SHOW_STREAM_OWNER : FlowNode.PropertyId.SHOW_REPOSITORY_WORKSPACE_NAME;
                FlowNodePropertySection.this.getFlowNode().getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(flowNode, (Object)propertyId, showNameInsteadOfOwner, label));
            }
        });
        this.visibleCollaborationsLabel = widgetFactory.createLabel(composite, "");
        Table visibleCollaborations = widgetFactory.createTable(composite, 804);
        this.viewer = new CheckboxTableViewer(visibleCollaborations);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List list = (List)inputElement;
                    return list.toArray();
                }
                return new Object[]{inputElement};
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Collaboration) {
                    Collaboration collaboration = (Collaboration)element;
                    return FlowNodePropertySection.toString(collaboration);
                }
                return super.getText(element);
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof Collaboration) {
                    Collaboration collaboration = (Collaboration)element;
                    boolean visible = event.getChecked();
                    String label = visible ? Messages.FlowNodePropertySection_8 : Messages.FlowNodePropertySection_9;
                    FlowNodePropertySection.this.getFlowNode().getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(collaboration, (Object)Collaboration.PropertyId.VISIBLE, event.getChecked(), label));
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, visibleCollaborations.getItemHeight() * 5).applyTo((Control)visibleCollaborations);
        GridLayoutFactory.fillDefaults().margins(6, 6).spacing(5, 4).generateLayout(composite);
    }

    public void refresh() {
        FlowNode flowNode = this.getFlowNode();
        this.setText(this.name, flowNode.getName());
        this.setText(this.owner, flowNode.getOwner());
        this.refreshShowNameOrOwner(flowNode);
        String text = Messages.FlowNodePropertySection_11;
        boolean enabled = true;
        if (flowNode.getDiagram().isShowOnlyCurrent()) {
            text = Messages.FlowNodePropertySection_10;
            enabled = false;
        }
        this.setText(this.visibleCollaborationsLabel, text);
        this.viewer.getTable().setEnabled(enabled);
        this.refreshOutgoing(flowNode);
        this.name.getParent().pack();
    }

    private void refreshShowNameOrOwner(FlowNode flowNode) {
        if (this.showNameOrOwner.isDisposed()) {
            return;
        }
        if (flowNode.isStream()) {
            FlowNode.PropertyId propertyId = FlowNode.PropertyId.SHOW_STREAM_OWNER;
            this.showNameOrOwner.setSelection(((Boolean)flowNode.getPropertyValue((Object)propertyId)).booleanValue());
            String showOwnerText = Messages.FlowNodePropertySection_15;
            boolean enabled = true;
            if (flowNode.getDiagram().isShowStreamOwner()) {
                showOwnerText = Messages.FlowNodePropertySection_16;
                enabled = false;
            }
            this.showNameOrOwner.setText(showOwnerText);
            this.showNameOrOwner.setEnabled(enabled);
        } else {
            FlowNode.PropertyId propertyId = FlowNode.PropertyId.SHOW_REPOSITORY_WORKSPACE_NAME;
            this.showNameOrOwner.setSelection(((Boolean)flowNode.getPropertyValue((Object)propertyId)).booleanValue());
            String showNameText = Messages.FlowNodePropertySection_12;
            boolean enabled = true;
            if (flowNode.getDiagram().isShowRepositoryWorkspaceName()) {
                showNameText = Messages.FlowNodePropertySection_13;
                enabled = false;
            }
            this.showNameOrOwner.setText(showNameText);
            this.showNameOrOwner.setEnabled(enabled);
        }
    }

    private FlowNode getFlowNode() {
        return (FlowNode)this.flowNodeEditPart.getModel2();
    }

    private void refreshOutgoing(FlowNode flowNode) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        List<Collaboration> collaborations = flowNode.getFlowTargetCollaborations();
        this.viewer.setInput(collaborations);
        ArrayList<Collaboration> visible = new ArrayList<Collaboration>();
        for (Collaboration collaboration : collaborations) {
            if (!collaboration.isVisible()) continue;
            visible.add(collaboration);
        }
        this.viewer.setCheckedElements(visible.toArray());
    }

    private static String toString(Collaboration collaboration) {
        FlowNode target = (FlowNode)collaboration.getTarget();
        return NLS.bind((String)Messages.FlowNodePropertySection_14, (Object)target.getName(), (Object)target.getOwner());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object input;
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            input = sSelection.getFirstElement();
            if (!(input instanceof FlowNodeEditPart)) {
                throw new IllegalArgumentException(input.getClass().toString());
            }
        } else {
            throw new IllegalArgumentException(selection.getClass().toString());
        }
        this.flowNodeEditPart = (FlowNodeEditPart)input;
    }

    public void aboutToBeHidden() {
        for (Observable observable : this.observables) {
            observable.deleteObserver(this);
        }
        this.observables.clear();
    }

    public void aboutToBeShown() {
        FlowNode flowNode = this.getFlowNode();
        this.observables.add(flowNode);
        for (Collaboration collaboration : flowNode.getFlowTargetCollaborations()) {
            this.observables.add(collaboration);
        }
        for (Observable observable : this.observables) {
            observable.addObserver(this);
        }
    }

    private void setText(Label label, String text) {
        if (text == null) {
            return;
        }
        label.setText(text);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof FlowNode) {
            final FlowNode.PropertyId id = FlowVisEditPart.getArg(FlowNode.PropertyId.class, arg);
            final FlowVisNode.PropertyId id2 = FlowVisEditPart.getArg(FlowVisNode.PropertyId.class, arg);
            if (id != null || id2 != null) {
                SWTUtil.greedyExec((Display)this.getPart().getSite().getWorkbenchWindow().getWorkbench().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FlowNode flowNode = FlowNodePropertySection.this.getFlowNode();
                        if (id != null) {
                            switch (id) {
                                case SHOW_REPOSITORY_WORKSPACE_NAME: {
                                    FlowNodePropertySection.this.refreshShowNameOrOwner(flowNode);
                                    break;
                                }
                                case SHOW_STREAM_OWNER: {
                                    FlowNodePropertySection.this.refreshShowNameOrOwner(flowNode);
                                    break;
                                }
                                case NAME: {
                                    if (FlowNodePropertySection.this.name.isDisposed()) break;
                                    FlowNodePropertySection.this.setText(FlowNodePropertySection.this.name, flowNode.getName());
                                    FlowNodePropertySection.this.name.getParent().pack();
                                    break;
                                }
                                case OWNER: {
                                    if (FlowNodePropertySection.this.owner.isDisposed()) break;
                                    FlowNodePropertySection.this.setText(FlowNodePropertySection.this.owner, flowNode.getOwner());
                                    FlowNodePropertySection.this.owner.getParent().pack();
                                }
                            }
                        }
                        if (id2 != null) {
                            switch (id2) {
                                case OUTGOING_CONNECTION: {
                                    FlowNodePropertySection.this.refreshOutgoing(flowNode);
                                }
                            }
                        }
                    }
                });
            }
        } else if (o instanceof Collaboration) {
            Collaboration collaboration = (Collaboration)o;
            Collaboration.PropertyId id = FlowVisEditPart.getArg(Collaboration.PropertyId.class, arg);
            if (id != null) {
                switch (id) {
                    case VISIBLE: {
                        this.viewer.setChecked((Object)collaboration, collaboration.isVisible());
                    }
                }
            }
        }
    }
}

