/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.properties;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.LayoutCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.SetPropertyCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisDiagramEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.properties.IntegerVerifyListener;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DiagramPropertySection
extends AbstractPropertySection
implements Observer {
    private FlowVisDiagramEditPart diagramEditPart;
    private CCombo layoutDirection;
    private CCombo router;
    private Text animationText;
    private Text warnAddingFlowNodes;
    private Button showRepositoryWorkspaceNames;
    private Button showStreamOwners;
    private Button showDefaultLabels;
    private Button showOnlyCurrent;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = this.getWidgetFactory();
        Composite composite = widgetFactory.createComposite(parent);
        Composite layoutComposite = widgetFactory.createComposite(composite);
        widgetFactory.createCLabel(layoutComposite, Messages.DiagramPropertySection_0);
        this.layoutDirection = widgetFactory.createCCombo(layoutComposite);
        final Object[][] comboData = new Object[][]{{Messages.DiagramPropertySection_1, 4}, {Messages.DiagramPropertySection_2, 16}};
        int i = 0;
        while (i < comboData.length) {
            Object[] data = comboData[i];
            this.layoutDirection.add(data[0].toString());
            this.layoutDirection.setData(data[1].toString(), (Object)i);
            ++i;
        }
        this.layoutDirection.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Integer direction = (Integer)comboData[DiagramPropertySection.this.layoutDirection.getSelectionIndex()][1];
                DiagramPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(DiagramPropertySection.this.getDiagram(), (Object)FlowVisDiagram.PropertyId.LAYOUT_DIRECTION, direction, Messages.DiagramPropertySection_3));
            }
        });
        Button layoutButton = widgetFactory.createButton(layoutComposite, Messages.DiagramPropertySection_4, 8);
        layoutButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DiagramPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new LayoutCommand(DiagramPropertySection.this.diagramEditPart));
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)layoutButton);
        GridLayoutFactory.fillDefaults().spacing(5, 4).numColumns(3).generateLayout(layoutComposite);
        Composite routerComposite = widgetFactory.createComposite(composite);
        widgetFactory.createCLabel(routerComposite, Messages.DiagramPropertySection_5);
        this.router = widgetFactory.createCCombo(routerComposite);
        final Object[][] routerComboData = new Object[][]{{Messages.DiagramPropertySection_6, 0}, {Messages.DiagramPropertySection_7, 1}};
        int i2 = 0;
        while (i2 < routerComboData.length) {
            Object[] data = routerComboData[i2];
            this.router.add(data[0].toString());
            this.router.setData(data[1].toString(), (Object)i2);
            ++i2;
        }
        this.router.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Integer direction = (Integer)routerComboData[DiagramPropertySection.this.router.getSelectionIndex()][1];
                DiagramPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(DiagramPropertySection.this.getDiagram(), (Object)FlowVisDiagram.PropertyId.ROUTER, direction, Messages.DiagramPropertySection_8));
            }
        });
        GridLayoutFactory.fillDefaults().spacing(5, 4).numColumns(3).generateLayout(routerComposite);
        Composite animationComposite = widgetFactory.createComposite(composite);
        widgetFactory.createCLabel(animationComposite, Messages.DiagramPropertySection_9);
        this.animationText = widgetFactory.createText(animationComposite, "");
        this.animationText.addVerifyListener((VerifyListener)new IntegerVerifyListener(0, 999));
        this.animationText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DiagramPropertySection.this.setAnimationSpeed();
            }
        });
        this.animationText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    DiagramPropertySection.this.setAnimationSpeed();
                }
            }
        });
        GridLayoutFactory.fillDefaults().spacing(5, 4).numColumns(3).generateLayout(animationComposite);
        Composite warnAddingFlowsNodesComposite = widgetFactory.createComposite(composite);
        widgetFactory.createCLabel(warnAddingFlowsNodesComposite, Messages.DiagramPropertySection_11);
        this.warnAddingFlowNodes = widgetFactory.createText(warnAddingFlowsNodesComposite, "");
        this.warnAddingFlowNodes.addVerifyListener((VerifyListener)new IntegerVerifyListener(-1, null));
        this.warnAddingFlowNodes.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DiagramPropertySection.this.setWarnAddingFlowNodes();
            }
        });
        this.warnAddingFlowNodes.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    DiagramPropertySection.this.setWarnAddingFlowNodes();
                }
            }
        });
        GridLayoutFactory.fillDefaults().spacing(5, 4).numColumns(3).generateLayout(warnAddingFlowsNodesComposite);
        this.showRepositoryWorkspaceNames = widgetFactory.createButton(composite, Messages.DiagramPropertySection_13, 32);
        this.showRepositoryWorkspaceNames.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean isShowWorkspaceNames = DiagramPropertySection.this.showRepositoryWorkspaceNames.getSelection();
                String label = isShowWorkspaceNames ? Messages.DiagramPropertySection_14 : Messages.DiagramPropertySection_15;
                DiagramPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(DiagramPropertySection.this.getDiagram(), (Object)FlowVisDiagram.PropertyId.SHOW_REPOSITORY_WORKSPACE_NAME, isShowWorkspaceNames, label));
            }
        });
        this.showStreamOwners = widgetFactory.createButton(composite, Messages.DiagramPropertySection_24, 32);
        this.showStreamOwners.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean isShowStreamOwners = DiagramPropertySection.this.showStreamOwners.getSelection();
                String label = isShowStreamOwners ? Messages.DiagramPropertySection_25 : Messages.DiagramPropertySection_26;
                DiagramPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(DiagramPropertySection.this.getDiagram(), (Object)FlowVisDiagram.PropertyId.SHOW_STREAM_OWNER, isShowStreamOwners, label));
            }
        });
        this.showDefaultLabels = widgetFactory.createButton(composite, Messages.DiagramPropertySection_16, 32);
        this.showDefaultLabels.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean isShowDefaultLabels = DiagramPropertySection.this.showDefaultLabels.getSelection();
                String label = isShowDefaultLabels ? Messages.DiagramPropertySection_17 : Messages.DiagramPropertySection_18;
                DiagramPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(DiagramPropertySection.this.getDiagram(), (Object)FlowVisDiagram.PropertyId.SHOW_DEFAULT_LABELS, isShowDefaultLabels, label));
            }
        });
        this.showOnlyCurrent = widgetFactory.createButton(composite, Messages.DiagramPropertySection_19, 32);
        this.showOnlyCurrent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean isShowOnlyCurrent = DiagramPropertySection.this.showOnlyCurrent.getSelection();
                String label = isShowOnlyCurrent ? Messages.DiagramPropertySection_20 : Messages.DiagramPropertySection_21;
                DiagramPropertySection.this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(DiagramPropertySection.this.getDiagram(), (Object)FlowVisDiagram.PropertyId.SHOW_ONLY_CURRENT, isShowOnlyCurrent, label));
            }
        });
        GridLayoutFactory.fillDefaults().margins(6, 6).spacing(5, 4).generateLayout(composite);
    }

    private FlowVisDiagram getDiagram() {
        return (FlowVisDiagram)this.diagramEditPart.getModel2();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object input;
        super.setInput(part, selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            input = sSelection.getFirstElement();
            if (!(input instanceof FlowVisDiagramEditPart)) {
                throw new IllegalArgumentException(input.getClass().toString());
            }
        } else {
            throw new IllegalArgumentException(selection.getClass().toString());
        }
        this.diagramEditPart = (FlowVisDiagramEditPart)input;
    }

    public void refresh() {
        this.refreshLayoutDirection();
        this.refreshRouter();
        this.refreshAnimationSpeed();
        this.refreshWarnAddingFlowNodes();
        this.refreshShowRepositoryWorkspaceNames();
        this.refreshShowStreamOwners();
        this.refreshShowDefaultLabels();
        this.refreshShowOnlyCurrent();
    }

    private void refreshShowOnlyCurrent() {
        this.showOnlyCurrent.setSelection(this.getDiagram().isShowOnlyCurrent());
    }

    private void refreshShowDefaultLabels() {
        this.showDefaultLabels.setSelection(this.getDiagram().isShowDefaultLabels());
    }

    private void refreshShowRepositoryWorkspaceNames() {
        this.showRepositoryWorkspaceNames.setSelection(this.getDiagram().isShowRepositoryWorkspaceName());
    }

    private void refreshShowStreamOwners() {
        this.showStreamOwners.setSelection(this.getDiagram().isShowStreamOwner());
    }

    private void refreshWarnAddingFlowNodes() {
        this.warnAddingFlowNodes.setText(Integer.toString(this.getDiagram().getWarnAddingFlowNodes()));
    }

    private void refreshAnimationSpeed() {
        this.animationText.setText(Integer.toString(this.getDiagram().getAnimationSpeed()));
    }

    private void refreshLayoutDirection() {
        int index = 0;
        int direction = this.getDiagram().getLayoutDirection();
        Object indexObj = this.layoutDirection.getData(Integer.toString(direction));
        if (indexObj != null && indexObj instanceof Integer) {
            index = (Integer)indexObj;
        }
        this.layoutDirection.select(index);
    }

    private void refreshRouter() {
        int index = 0;
        int direction = this.getDiagram().getRouter();
        Object indexObj = this.router.getData(Integer.toString(direction));
        if (indexObj != null && indexObj instanceof Integer) {
            index = (Integer)indexObj;
        }
        this.router.select(index);
    }

    public void aboutToBeHidden() {
        ((FlowVisDiagram)this.diagramEditPart.getModel2()).deleteObserver(this);
    }

    public void aboutToBeShown() {
        ((FlowVisDiagram)this.diagramEditPart.getModel2()).addObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        FlowVisDiagram.PropertyId id = FlowVisEditPart.getArg(FlowVisDiagram.PropertyId.class, arg);
        if (id != null) {
            switch (id) {
                case LAYOUT_DIRECTION: {
                    this.refreshLayoutDirection();
                    break;
                }
                case ANIMATION_SPEED: {
                    this.refreshAnimationSpeed();
                    break;
                }
                case WARN_ADDING_FLOWS_NODES: {
                    this.refreshWarnAddingFlowNodes();
                    break;
                }
                case SHOW_REPOSITORY_WORKSPACE_NAME: {
                    this.refreshShowRepositoryWorkspaceNames();
                    break;
                }
                case SHOW_STREAM_OWNER: {
                    this.refreshShowStreamOwners();
                    break;
                }
                case SHOW_DEFAULT_LABELS: {
                    this.refreshShowDefaultLabels();
                    break;
                }
                case SHOW_ONLY_CURRENT: {
                    this.refreshShowOnlyCurrent();
                }
            }
        }
    }

    private void setAnimationSpeed() {
        Integer speed = IntegerVerifyListener.verifyInteger(this.animationText.getText(), 0, 999);
        if (speed != null && speed.intValue() != this.getDiagram().getAnimationSpeed()) {
            this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(this.getDiagram(), (Object)FlowVisDiagram.PropertyId.ANIMATION_SPEED, speed, Messages.DiagramPropertySection_22));
        } else {
            this.refreshAnimationSpeed();
        }
    }

    private void setWarnAddingFlowNodes() {
        Integer warnAddingFlowNodesLimit = IntegerVerifyListener.verifyInteger(this.warnAddingFlowNodes.getText(), -1, null);
        if (warnAddingFlowNodesLimit != null && warnAddingFlowNodesLimit.intValue() != this.getDiagram().getWarnAddingFlowNodes()) {
            this.getDiagram().getUtil().getCommandStack().execute((Command)new SetPropertyCommand(this.getDiagram(), (Object)FlowVisDiagram.PropertyId.WARN_ADDING_FLOWS_NODES, warnAddingFlowNodesLimit, Messages.DiagramPropertySection_23));
        } else {
            this.refreshWarnAddingFlowNodes();
        }
    }
}

