/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.model;

import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisConnection;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class FlowVisNode
extends FlowVisModel
implements Serializable {
    private static final long serialVersionUID = -7608320419910630839L;
    private Set<FlowVisConnection> outgoingFlowVisConnections = new HashSet<FlowVisConnection>();
    private Set<FlowVisConnection> outgoing;
    private Set<FlowVisConnection> incomingFlowVisConnections = new HashSet<FlowVisConnection>();
    private Set<FlowVisConnection> incoming;

    protected FlowVisNode() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasOutgoingFlowVisConnection(FlowVisNode target) {
        Set<FlowVisConnection> set = this.outgoingFlowVisConnections;
        synchronized (set) {
            FlowVisConnection c;
            Iterator<FlowVisConnection> iterator = this.outgoingFlowVisConnections.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(c = iterator.next()).getTarget().equals(target));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOutgoingFlowVisConnection(FlowVisConnection connection) {
        Set<FlowVisConnection> set = this.outgoingFlowVisConnections;
        synchronized (set) {
            this.outgoingFlowVisConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeOutgoingFlowVisConnection(FlowVisConnection connection) {
        Set<FlowVisConnection> set = this.outgoingFlowVisConnections;
        synchronized (set) {
            this.outgoingFlowVisConnections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIncomingFlowVisConnection(FlowVisConnection connection) {
        Set<FlowVisConnection> set = this.incomingFlowVisConnections;
        synchronized (set) {
            this.incomingFlowVisConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIncomingFlowVisConnection(FlowVisConnection connection) {
        Set<FlowVisConnection> set = this.incomingFlowVisConnections;
        synchronized (set) {
            this.incomingFlowVisConnections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowVisConnection> getIncomingFlowVisConnections() {
        Set<FlowVisConnection> set = this.incomingFlowVisConnections;
        synchronized (set) {
            return new ArrayList<FlowVisConnection>(this.incomingFlowVisConnections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowVisConnection> getOutgoingFlowVisConnections() {
        Set<FlowVisConnection> set = this.outgoingFlowVisConnections;
        synchronized (set) {
            return new ArrayList<FlowVisConnection>(this.outgoingFlowVisConnections);
        }
    }

    @Override
    protected void setPropertyValue2(Object id, Object value) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return;
        }
        switch (pid) {
            case OUTGOING_CONNECTION: {
                FlowVisConnection connection;
                if (!(value instanceof Collection[])) break;
                Collection[] addRemove = (Collection[])value;
                Collection toAdd = addRemove[0];
                Collection toRemove = addRemove[1];
                for (Object o : toAdd) {
                    if (!(o instanceof FlowVisConnection)) continue;
                    connection = (FlowVisConnection)o;
                    this.addOutgoingFlowVisConnection(connection);
                }
                for (Object o : toRemove) {
                    if (!(o instanceof FlowVisConnection)) continue;
                    connection = (FlowVisConnection)o;
                    this.removeOutgoingFlowVisConnection(connection);
                }
                break;
            }
            case INCOMING_CONNECTION: {
                FlowVisConnection connection;
                if (!(value instanceof Collection[])) break;
                Collection[] addRemove = (Collection[])value;
                Collection toAdd = addRemove[0];
                Collection toRemove = addRemove[1];
                for (Object o : toAdd) {
                    if (!(o instanceof FlowVisConnection)) continue;
                    connection = (FlowVisConnection)o;
                    this.addIncomingFlowVisConnection(connection);
                }
                for (Object o : toRemove) {
                    if (!(o instanceof FlowVisConnection)) continue;
                    connection = (FlowVisConnection)o;
                    this.removeIncomingFlowVisConnection(connection);
                }
                break;
            }
        }
    }

    public Object getPropertyValue(Object id) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return null;
        }
        switch (pid) {
            case INCOMING_CONNECTION: {
                return this.getIncomingFlowVisConnections();
            }
            case OUTGOING_CONNECTION: {
                return this.getOutgoingFlowVisConnections();
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        if (this.incoming != null) {
            this.incomingFlowVisConnections = this.incoming;
            this.incoming = null;
        }
        if (this.outgoing != null) {
            this.outgoingFlowVisConnections = this.outgoing;
            this.outgoing = null;
        }
    }

    public static enum PropertyId {
        INCOMING_CONNECTION,
        OUTGOING_CONNECTION;

    }
}

