/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.model;

import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Note;
import com.ibm.team.repository.common.UUID;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertySource;

public class FlowVisDiagram
extends FlowVisModel
implements IPropertySource,
Serializable {
    private static final long serialVersionUID = -6481217861692933972L;
    private int animationSpeed = 250;
    private Set<FlowNode> flowNodes;
    private Set<Note> notes;
    private int layoutDirection = 4;
    private int router;
    private String repositoryURI;
    private String repositoryUUID;
    private boolean showDefaultLabels = true;
    private boolean showOnlyCurrent = false;
    private boolean showRepositoryWorkspaceName = false;
    private boolean showStreamOwner = false;
    private int warnAddingFlowNodes = 5;
    private double zoom = 1.0;
    private transient Map<UUID, FlowNode> flowNodeMap = new HashMap<UUID, FlowNode>();
    private transient FlowVisUtil util;

    public FlowVisDiagram(FlowVisUtil util) {
        this();
        this.setUtil(util);
    }

    public FlowVisDiagram() {
        this.flowNodes = new HashSet<FlowNode>();
        this.notes = new HashSet<Note>();
    }

    public void addFlowNode(FlowNode flowNode) {
        this.getFlowNodeMap().put(flowNode.getUUID(), flowNode);
        this.flowNodes.add(flowNode);
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public FlowNode getFlowNode(UUID uuid) {
        FlowNode flowNode = this.getFlowNodeMap().get(uuid);
        if (flowNode == null) {
            for (FlowNode node : this.flowNodes) {
                if (!node.getUUID().equals((Object)uuid)) continue;
                flowNode = node;
                this.flowNodeMap.put(uuid, flowNode);
                break;
            }
        }
        return flowNode;
    }

    private Map<UUID, FlowNode> getFlowNodeMap() {
        if (this.flowNodeMap == null) {
            this.flowNodeMap = new HashMap<UUID, FlowNode>();
        }
        return this.flowNodeMap;
    }

    public List<FlowNode> getFlowNodes() {
        return new ArrayList<FlowNode>(this.flowNodes);
    }

    public List<Note> getNotes() {
        return new ArrayList<Note>(this.notes);
    }

    public int getLayoutDirection() {
        return this.layoutDirection;
    }

    public int getRouter() {
        return this.router;
    }

    public Date[] getRepoAccesses() {
        ArrayList<Date[]> dates = new ArrayList<Date[]>();
        for (FlowNode flowNode : this.getFlowNodes()) {
            dates.add(flowNode.getRepoAccesses());
        }
        return FlowVisUtil.getDateRange(dates);
    }

    public String getRepositoryURI() {
        return this.repositoryURI;
    }

    public UUID getRepositoryUUID() {
        return this.repositoryUUID == null ? null : UUID.valueOf((String)this.repositoryUUID);
    }

    public FlowVisUtil getUtil() {
        return this.util;
    }

    public int getWarnAddingFlowNodes() {
        return this.warnAddingFlowNodes;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public boolean isShowDefaultLabels() {
        return this.showDefaultLabels;
    }

    public boolean isShowOnlyCurrent() {
        return this.showOnlyCurrent;
    }

    public boolean isShowRepositoryWorkspaceName() {
        return this.showRepositoryWorkspaceName;
    }

    public boolean isShowStreamOwner() {
        return this.showStreamOwner;
    }

    private void removeFlowNode(FlowNode flowNode) {
        this.getFlowNodeMap().remove(flowNode.getUUID());
        this.flowNodes.remove(flowNode);
    }

    public void setUtil(FlowVisUtil util) {
        this.util = util;
        this.repositoryURI = util.getRepository().getRepositoryURI();
        this.repositoryUUID = util.getRepository().getId() == null ? null : util.getRepository().getId().getUuidValue();
    }

    public void setWarnAddingFlowNodes(int warnAddingFlowNodes) {
        this.warnAddingFlowNodes = warnAddingFlowNodes;
        this.setChanged();
        this.notifyObservers((Object)PropertyId.WARN_ADDING_FLOWS_NODES);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph ").append(this.getRepositoryURI()).append("{");
        int i = 0;
        HashMap<FlowNode, String> ids = new HashMap<FlowNode, String>();
        for (FlowNode flowNode : this.flowNodes) {
            ids.put(flowNode, "n" + i++);
        }
        for (FlowNode flowNode : this.flowNodes) {
            String nodeId = (String)ids.get(flowNode);
            for (Collaboration collaboration : flowNode.getFlowTargetCollaborations()) {
                String targetId = (String)ids.get(collaboration.getTarget());
                builder.append("\n\t").append(nodeId).append("->").append(targetId).append(";");
            }
            builder.append("\n\t").append(nodeId).append("[label=\"").append(flowNode.toString()).append("\"];");
        }
        builder.append("\n}");
        return builder.toString();
    }

    public Object getPropertyValue(Object id) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return null;
        }
        switch (pid) {
            case ANIMATION_SPEED: {
                return this.getAnimationSpeed();
            }
            case SHOW_DEFAULT_LABELS: {
                return this.isShowDefaultLabels();
            }
            case SHOW_ONLY_CURRENT: {
                return this.isShowOnlyCurrent();
            }
            case SHOW_REPOSITORY_WORKSPACE_NAME: {
                return this.isShowRepositoryWorkspaceName();
            }
            case SHOW_STREAM_OWNER: {
                return this.isShowStreamOwner();
            }
            case WARN_ADDING_FLOWS_NODES: {
                return this.getWarnAddingFlowNodes();
            }
            case LAYOUT_DIRECTION: {
                return this.getLayoutDirection();
            }
            case ROUTER: {
                return this.getRouter();
            }
            case FLOW_NODES: {
                return this.getFlowNodes();
            }
            case NOTES: {
                return this.getNotes();
            }
        }
        return null;
    }

    @Override
    protected void setPropertyValue2(Object id, Object value) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return;
        }
        switch (pid) {
            case ANIMATION_SPEED: {
                if (!(value instanceof Integer)) break;
                this.animationSpeed = (Integer)value;
                break;
            }
            case SHOW_DEFAULT_LABELS: {
                if (!(value instanceof Boolean)) break;
                this.showDefaultLabels = (Boolean)value;
                for (FlowNode flowNode : this.getFlowNodes()) {
                    for (Collaboration collaboration2 : flowNode.getFlowTargetCollaborations()) {
                        collaboration2.setChanged();
                        collaboration2.notifyObservers();
                    }
                }
                break;
            }
            case SHOW_ONLY_CURRENT: {
                if (!(value instanceof Boolean)) break;
                this.showOnlyCurrent = (Boolean)value;
                for (FlowNode flowNode : this.getFlowNodes()) {
                    for (Collaboration collaboration2 : flowNode.getFlowTargetCollaborations()) {
                        collaboration2.setChanged();
                        collaboration2.notifyObservers();
                    }
                }
                break;
            }
            case SHOW_REPOSITORY_WORKSPACE_NAME: {
                if (!(value instanceof Boolean)) break;
                this.showRepositoryWorkspaceName = (Boolean)value;
                for (FlowNode flowNode : this.getFlowNodes()) {
                    flowNode.setChanged();
                    flowNode.notifyObservers((Object)FlowNode.PropertyId.SHOW_REPOSITORY_WORKSPACE_NAME);
                }
                break;
            }
            case SHOW_STREAM_OWNER: {
                if (!(value instanceof Boolean)) break;
                this.showStreamOwner = (Boolean)value;
                for (FlowNode flowNode : this.getFlowNodes()) {
                    flowNode.setChanged();
                    flowNode.notifyObservers((Object)FlowNode.PropertyId.SHOW_STREAM_OWNER);
                }
                break;
            }
            case WARN_ADDING_FLOWS_NODES: {
                if (!(value instanceof Integer)) break;
                this.warnAddingFlowNodes = (Integer)value;
                break;
            }
            case LAYOUT_DIRECTION: {
                if (!(value instanceof Integer)) break;
                this.layoutDirection = (Integer)value;
                break;
            }
            case ROUTER: {
                if (!(value instanceof Integer)) break;
                this.router = (Integer)value;
                break;
            }
            case FLOW_NODES: {
                FlowNode flowNode;
                if (!(value instanceof Collection[])) break;
                Collection[] addRemove = (Collection[])value;
                Collection toAdd = addRemove[0];
                Collection toRemove = addRemove[1];
                for (Object o : toAdd) {
                    if (!(o instanceof FlowNode)) continue;
                    flowNode = (FlowNode)o;
                    this.addFlowNode(flowNode);
                }
                for (Object o : toRemove) {
                    if (!(o instanceof FlowNode)) continue;
                    flowNode = (FlowNode)o;
                    this.removeFlowNode(flowNode);
                }
                break;
            }
            case NOTES: {
                Note note;
                if (!(value instanceof Collection[])) break;
                Collection[] addRemove = (Collection[])value;
                Collection toAdd = addRemove[0];
                Collection toRemove = addRemove[1];
                for (Object o : toAdd) {
                    if (!(o instanceof Note)) continue;
                    note = (Note)o;
                    this.notes.add(note);
                }
                for (Object o : toRemove) {
                    if (!(o instanceof Note)) continue;
                    note = (Note)o;
                    this.notes.remove(note);
                }
                break;
            }
        }
    }

    public static enum PropertyId {
        ANIMATION_SPEED,
        FLOW_NODES,
        NOTES,
        LAYOUT_DIRECTION,
        ROUTER,
        REPOSITORY,
        SHOW_DEFAULT_LABELS,
        SHOW_ONLY_CURRENT,
        SHOW_REPOSITORY_WORKSPACE_NAME,
        SHOW_STREAM_OWNER,
        WARN_ADDING_FLOWS_NODES;

    }
}

