/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.model;

import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import java.io.Serializable;

public abstract class FlowVisConnection<Source extends FlowVisNode, Target extends FlowVisNode>
extends FlowVisModel
implements Serializable {
    private static final long serialVersionUID = 5233870268725114170L;
    private Class<Source> sourceClass;
    private Class<Target> targetClass;
    private Source source;
    private Target target;

    public FlowVisConnection(Class<Source> sourceClass, Class<Target> targetClass, Source source, Target target) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.source = source;
        this.target = target;
    }

    public Source getSource() {
        return this.source;
    }

    public Target getTarget() {
        return this.target;
    }

    public String toString() {
        return String.valueOf(this.getSource().toString()) + " -> " + this.getTarget().toString();
    }

    public Object getPropertyValue(Object id) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return null;
        }
        switch (pid) {
            case SOURCE: {
                return this.getSource();
            }
            case TARGET: {
                return this.getTarget();
            }
        }
        return null;
    }

    @Override
    protected void setPropertyValue2(Object id, Object value) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return;
        }
        switch (pid) {
            case SOURCE: {
                if (!this.sourceClass.isInstance(value)) break;
                this.source = (FlowVisNode)this.sourceClass.cast(value);
                break;
            }
            case TARGET: {
                if (!this.targetClass.isInstance(value)) break;
                this.target = (FlowVisNode)this.targetClass.cast(value);
            }
        }
    }

    public static enum PropertyId {
        SOURCE,
        TARGET;

    }
}

