/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.model;

import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Component;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertySource;

public class FlowNode
extends FlowVisNode
implements IPropertySource,
Serializable {
    private static final long serialVersionUID = -4829213317478228876L;
    private FlowVisDiagram diagram;
    private String uuidString;
    private String repoUrl;
    private String repoUUID;
    private String name;
    private Date nameDate;
    private String owner;
    private Date ownerDate;
    private String description;
    private Date descriptionDate;
    private Date collaborationDate;
    private int flowTargetsCount;
    private int outgoingCount;
    private int remoteIncomingCount;
    private int incomingCount;
    private boolean componentsExpanded;
    private List<Component> components;
    private Integer componentCount;
    private Date componentsDate;
    private Rectangle constraint;
    private boolean showRepositoryWorkspaceName;
    private boolean showStreamOwner;
    private FlowNode defaultIncomingFlow;
    private FlowNode defaultFlow;
    private FlowNode defaultOutgoingFlow;
    private Date defaultIncomingFlowDate;
    private Date defaultDate;
    private Date defaultOutgoingFlowDate;
    private FlowNode currentIncomingFlow;
    private FlowNode currentFlow;
    private FlowNode currentOutgoingFlow;
    private Date currentIncomingFlowDate;
    private Date currentDate;
    private Date currentOutgoingFlowDate;
    private boolean isStream;
    private transient IWorkspaceConnection connection;
    private transient UUID connectionUUID;
    private transient boolean componentsLoaded;

    public FlowNode(FlowVisDiagram diagram, IWorkspaceConnection connection) {
        this.diagram = diagram;
        this.connection = connection;
        this.connectionUUID = connection.getResolvedWorkspace().getItemId();
        this.uuidString = this.connectionUUID.getUuidValue();
        this.repoUrl = connection.teamRepository().getRepositoryURI();
        this.repoUUID = connection.teamRepository().getId().getUuidValue();
        this.isStream = connection.isStream();
        this.showRepositoryWorkspaceName = false;
        this.showStreamOwner = false;
        this.constraint = new Rectangle(0, 0, -1, -1);
        this.components = new ArrayList<Component>();
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.connection == null) {
            ITeamRepository repository = RepositoryUtils.getTeamRepository((UUID)this.getRepoUUID(), (String)this.getRepositoryUrl(), (int)0);
            IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(this.getUUID(), null);
            this.connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(wsHandle, monitor);
        }
        return this.connection;
    }

    public void setWorkspaceConnection(IWorkspaceConnection connection) {
        UUID itemId;
        if (connection != null && (itemId = connection.getResolvedWorkspace().getItemId()).equals((Object)this.getUUID()) && connection.teamRepository().getId().equals((Object)this.getRepoUUID())) {
            this.connection = connection;
        }
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        if (this.connection == null) {
            ITeamRepository repository;
            try {
                repository = this.getTeamRepository();
            }
            catch (TeamRepositoryException e) {
                return null;
            }
            for (Object o : SCMPlatform.getWorkspaceManager((ITeamRepository)repository).knownWorkspaceConnections()) {
                IWorkspaceConnection c;
                if (!(o instanceof IWorkspaceConnection) || !(c = (IWorkspaceConnection)o).getResolvedWorkspace().getItemId().equals((Object)this.getUUID())) continue;
                this.connection = c;
                break;
            }
        }
        return this.connection;
    }

    public ITeamRepository getTeamRepository() throws TeamRepositoryException {
        return RepositoryUtils.getTeamRepository((UUID)this.getRepoUUID(), (String)this.getRepositoryUrl(), (int)0);
    }

    public UUID getUUID() {
        if (this.connectionUUID == null) {
            this.connectionUUID = UUID.valueOf((String)this.uuidString);
        }
        return this.connectionUUID;
    }

    public FlowVisDiagram getDiagram() {
        return this.diagram;
    }

    public UUID getRepoUUID() {
        return UUID.valueOf((String)this.repoUUID);
    }

    public String getRepositoryUrl() {
        return this.repoUrl;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getOwnerDate() {
        return this.ownerDate;
    }

    public String getName() {
        if (this.isRemote()) {
            ITeamRepository teamRepository = null;
            try {
                teamRepository = this.getTeamRepository();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            return String.valueOf(this.name) + " [" + com.ibm.team.internal.filesystem.ui.util.RepositoryUtils.getLabel(teamRepository) + "]";
        }
        return this.name;
    }

    public boolean isRemote() {
        return !this.getRepositoryUrl().equals(this.diagram.getRepositoryURI());
    }

    public Date getNameDate() {
        return this.nameDate;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getDescriptionDate() {
        return this.descriptionDate;
    }

    public boolean isComponentsExpanded() {
        return this.componentsExpanded;
    }

    public boolean isStream() {
        return this.isStream;
    }

    public Rectangle getConstraint() {
        return this.constraint.getCopy();
    }

    public boolean isShowRepositoryWorkspaceName() {
        return this.showRepositoryWorkspaceName;
    }

    public boolean isShowStreamOwner() {
        return this.showStreamOwner;
    }

    public Date getCollaborationDate() {
        return this.collaborationDate;
    }

    public Date getCurrentIncomingFlowDate() {
        return this.currentIncomingFlowDate;
    }

    public Date getCurrentOutgoingFlowDate() {
        return this.currentOutgoingFlowDate;
    }

    public Date getDefaultIncomingFlowDate() {
        return this.defaultIncomingFlowDate;
    }

    public Date getDefaultOutgoingFlowDate() {
        return this.defaultOutgoingFlowDate;
    }

    public List<Component> getComponents() {
        return new ArrayList<Component>(this.components);
    }

    public void setComponentsLoaded(boolean componentsLoaded) {
        this.componentsLoaded = componentsLoaded;
    }

    public boolean isComponentsLoaded() {
        return this.componentsLoaded;
    }

    public Integer getComponentCount() {
        return this.componentCount;
    }

    public Integer computeComponentCount(IProgressMonitor monitor) {
        Integer count = null;
        if (this.isComponentsLoaded()) {
            count = this.components.size();
        } else if (this.connection != null) {
            try {
                this.connection.refresh(monitor);
                count = this.connection.getComponents().size();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return count;
    }

    public int getFlowTargetsCount() {
        return this.flowTargetsCount;
    }

    public int getRemoteIncomingCount() {
        return this.remoteIncomingCount;
    }

    public FlowNode getDefaultIncomingFlow() {
        return this.defaultIncomingFlow;
    }

    public FlowNode getDefaultOutgoingFlow() {
        return this.defaultOutgoingFlow;
    }

    public FlowNode getCurrentIncomingFlow() {
        return this.currentIncomingFlow;
    }

    public FlowNode getCurrentOutgoingFlow() {
        return this.currentOutgoingFlow;
    }

    public List<Collaboration> getFlowTargetCollaborations() {
        return FlowVisUtil.filterList(Collaboration.class, this.getOutgoingFlowVisConnections());
    }

    public List<Collaboration> getRemoteIncomingCollaborations() {
        return FlowVisUtil.filterList(Collaboration.class, this.getIncomingFlowVisConnections());
    }

    public Date getComponentsDate() {
        return this.componentsDate;
    }

    @Override
    public Object getPropertyValue(Object id) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return super.getPropertyValue(id);
        }
        switch (pid) {
            case NAME: {
                return this.getName();
            }
            case OWNER: {
                return this.getOwner();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
            case NAME_DATE: {
                return this.getNameDate();
            }
            case OWNER_DATE: {
                return this.getOwnerDate();
            }
            case DESCRIPTION_DATE: {
                return this.getDescriptionDate();
            }
            case CONSTRAINT: {
                return this.getConstraint();
            }
            case SHOW_REPOSITORY_WORKSPACE_NAME: {
                return this.isShowRepositoryWorkspaceName();
            }
            case SHOW_STREAM_OWNER: {
                return this.isShowStreamOwner();
            }
            case COMPONENTS_EXPANDED: {
                return this.isComponentsExpanded();
            }
            case COMPONENTS: {
                return this.getComponents();
            }
            case COMPONENT_COUNT: {
                return this.getComponentCount();
            }
            case COMPONENTS_DATE: {
                return this.getComponentsDate();
            }
            case CURRENT_INCOMING_FLOW: {
                return this.getCurrentIncomingFlow();
            }
            case CURRENT_OUTGOING_FLOW: {
                return this.getCurrentOutgoingFlow();
            }
            case DEFAULT_INCOMING_FLOW: {
                return this.getDefaultIncomingFlow();
            }
            case DEFAULT_OUTGOING_FLOW: {
                return this.getDefaultOutgoingFlow();
            }
            case FLOW_TARGETS_COUNT: {
                return this.getFlowTargetsCount();
            }
            case REMOTE_INCOMING_COUNT: {
                return this.getRemoteIncomingCount();
            }
            case COLLABORATION_DATE: {
                return this.getCollaborationDate();
            }
            case CURRENT_INCOMING_FLOW_DATE: {
                return this.getCurrentIncomingFlowDate();
            }
            case CURRENT_OUTGOING_FLOW_DATE: {
                return this.getCurrentOutgoingFlowDate();
            }
            case DEFAULT_INCOMING_FLOW_DATE: {
                return this.getDefaultIncomingFlowDate();
            }
            case DEFAULT_OUTGOING_FLOW_DATE: {
                return this.getDefaultOutgoingFlowDate();
            }
        }
        return super.getPropertyValue(id);
    }

    @Override
    protected void setPropertyValue2(Object id, Object value) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            super.setPropertyValue2(id, value);
            return;
        }
        switch (pid) {
            case COMPONENTS_EXPANDED: {
                if (!(value instanceof Boolean)) break;
                this.componentsExpanded = (Boolean)value;
                break;
            }
            case COMPONENTS: {
                Component component;
                if (!(value instanceof Collection[])) break;
                Collection[] addRemove = (Collection[])value;
                Collection toAdd = addRemove[0];
                Collection toRemove = addRemove[1];
                for (Object o : toAdd) {
                    if (!(o instanceof Component)) continue;
                    component = (Component)o;
                    this.components.add(component);
                }
                for (Object o : toRemove) {
                    if (!(o instanceof Component)) continue;
                    component = (Component)o;
                    this.components.remove(component);
                }
                Collections.sort(this.components);
                break;
            }
            case COMPONENT_COUNT: {
                if (value != null && !(value instanceof Integer)) break;
                this.componentCount = (Integer)value;
                break;
            }
            case COMPONENTS_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.componentsDate = (Date)value;
                break;
            }
            case CONSTRAINT: {
                if (!(value instanceof Rectangle)) break;
                this.constraint.setBounds((Rectangle)value);
                break;
            }
            case SHOW_REPOSITORY_WORKSPACE_NAME: {
                if (!(value instanceof Boolean)) break;
                this.showRepositoryWorkspaceName = (Boolean)value;
                break;
            }
            case SHOW_STREAM_OWNER: {
                if (!(value instanceof Boolean)) break;
                this.showStreamOwner = (Boolean)value;
                break;
            }
            case DEFAULT_INCOMING_FLOW: {
                if (value != null && !(value instanceof FlowNode)) break;
                this.defaultIncomingFlow = (FlowNode)value;
                break;
            }
            case DEFAULT_OUTGOING_FLOW: {
                if (value != null && !(value instanceof FlowNode)) break;
                this.defaultOutgoingFlow = (FlowNode)value;
                break;
            }
            case CURRENT_INCOMING_FLOW: {
                if (value != null && !(value instanceof FlowNode)) break;
                this.currentIncomingFlow = (FlowNode)value;
                break;
            }
            case CURRENT_OUTGOING_FLOW: {
                if (value != null && !(value instanceof FlowNode)) break;
                this.currentOutgoingFlow = (FlowNode)value;
                break;
            }
            case FLOW_TARGETS_COUNT: {
                if (!(value instanceof Integer)) break;
                this.flowTargetsCount = (Integer)value;
                break;
            }
            case REMOTE_INCOMING_COUNT: {
                if (!(value instanceof Integer)) break;
                this.remoteIncomingCount = (Integer)value;
                break;
            }
            case NAME: {
                if (value != null && !(value instanceof String)) break;
                this.name = (String)value;
                break;
            }
            case OWNER: {
                if (value != null && !(value instanceof String)) break;
                this.owner = (String)value;
                break;
            }
            case NAME_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.nameDate = (Date)value;
                break;
            }
            case DESCRIPTION: {
                if (value != null && !(value instanceof String)) break;
                this.description = (String)value;
                break;
            }
            case DESCRIPTION_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.descriptionDate = (Date)value;
                break;
            }
            case OWNER_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.ownerDate = (Date)value;
                break;
            }
            case COLLABORATION_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.collaborationDate = (Date)value;
                break;
            }
            case CURRENT_INCOMING_FLOW_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.currentIncomingFlowDate = (Date)value;
                break;
            }
            case CURRENT_OUTGOING_FLOW_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.currentOutgoingFlowDate = (Date)value;
                break;
            }
            case DEFAULT_INCOMING_FLOW_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.defaultIncomingFlowDate = (Date)value;
                break;
            }
            case DEFAULT_OUTGOING_FLOW_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.defaultOutgoingFlowDate = (Date)value;
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.name != null) {
            builder.append(this.name);
        }
        if (this.owner != null) {
            builder.append(' ');
            builder.append('(');
            builder.append(this.owner);
            builder.append(')');
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return super.toString();
    }

    public Date[] getRepoAccesses() {
        ArrayList<Date[]> dates = new ArrayList<Date[]>();
        for (Component component : this.getComponents()) {
            dates.add(component.getRepoAccesses());
        }
        dates.add(new Date[]{this.nameDate, this.nameDate});
        dates.add(new Date[]{this.ownerDate, this.ownerDate});
        dates.add(new Date[]{this.descriptionDate, this.descriptionDate});
        dates.add(new Date[]{this.componentsDate, this.componentsDate});
        dates.add(new Date[]{this.collaborationDate, this.collaborationDate});
        dates.add(new Date[]{this.currentIncomingFlowDate, this.currentIncomingFlowDate});
        dates.add(new Date[]{this.currentOutgoingFlowDate, this.currentOutgoingFlowDate});
        dates.add(new Date[]{this.defaultIncomingFlowDate, this.defaultIncomingFlowDate});
        dates.add(new Date[]{this.defaultOutgoingFlowDate, this.defaultOutgoingFlowDate});
        return FlowVisUtil.getDateRange(dates);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        if (this.outgoingCount != 0) {
            this.flowTargetsCount = this.outgoingCount;
            this.outgoingCount = 0;
        }
        if (this.incomingCount != 0) {
            this.remoteIncomingCount = this.incomingCount;
            this.incomingCount = 0;
        }
        if (this.defaultFlow != null) {
            this.defaultIncomingFlow = this.defaultFlow;
            this.defaultOutgoingFlow = this.defaultFlow;
            this.defaultFlow = null;
        }
        if (this.defaultDate != null) {
            this.defaultIncomingFlowDate = this.defaultDate;
            this.defaultOutgoingFlowDate = this.defaultDate;
            this.defaultDate = null;
        }
        if (this.currentFlow != null) {
            this.currentIncomingFlow = this.currentFlow;
            this.currentOutgoingFlow = this.currentFlow;
            this.currentFlow = null;
        }
        if (this.currentDate != null) {
            this.currentIncomingFlowDate = this.currentDate;
            this.currentOutgoingFlowDate = this.currentDate;
            this.currentDate = null;
        }
    }

    public static enum PropertyId {
        NAME,
        NAME_DATE,
        OWNER,
        OWNER_DATE,
        DESCRIPTION,
        DESCRIPTION_DATE,
        CONSTRAINT,
        SHOW_REPOSITORY_WORKSPACE_NAME,
        SHOW_STREAM_OWNER,
        FLOW_TARGETS_COUNT,
        REMOTE_INCOMING_COUNT,
        COMPONENTS,
        COMPONENTS_EXPANDED,
        COMPONENTS_DATE,
        COMPONENT_COUNT,
        CURRENT_INCOMING_FLOW,
        CURRENT_OUTGOING_FLOW,
        CURRENT_INCOMING_FLOW_DATE,
        CURRENT_OUTGOING_FLOW_DATE,
        DEFAULT_INCOMING_FLOW,
        DEFAULT_OUTGOING_FLOW,
        DEFAULT_INCOMING_FLOW_DATE,
        DEFAULT_OUTGOING_FLOW_DATE,
        COLLABORATION_DATE;

    }
}

