/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.model;

import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.Serializable;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class Component
extends FlowVisModel
implements Serializable,
Comparable<Component> {
    private static final long serialVersionUID = -7046726323615716203L;
    private FlowNode flowNode;
    private String uuidString;
    private String name;
    private Date nameDate;
    private transient IComponent component;
    private transient UUID uuid;

    public Component(FlowNode parent, IComponent component) {
        this.flowNode = parent;
        this.component = component;
        this.uuidString = component.getItemId().getUuidValue();
    }

    public String getName() {
        return this.name;
    }

    public Date getNameDate() {
        return this.nameDate;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.valueOf((String)this.uuidString);
        }
        return this.uuid;
    }

    public IComponent getComponent(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.component == null) {
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            ITeamRepository repository = this.flowNode.getDiagram().getUtil().getRepository();
            IItemManager manager = repository.itemManager();
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(this.getUUID(), null);
            this.component = (IComponent)manager.fetchCompleteItem((IItemHandle)componentHandle, 0, (IProgressMonitor)sub.newChild(1));
        }
        return this.component;
    }

    public void setComponent(IComponent component) {
        if (component != null && component.getItemId().equals((Object)this.getUUID())) {
            this.component = component;
        }
    }

    public IComponent getComponent() {
        if (this.component == null) {
            ITeamRepository repository = this.flowNode.getDiagram().getUtil().getRepository();
            IItemManager manager = repository.itemManager();
            for (Object o : manager.getKnownSharedItems(IComponent.ITEM_TYPE)) {
                IComponent c;
                if (!(o instanceof IComponent) || !(c = (IComponent)o).getItemId().equals((Object)this.getUUID())) continue;
                this.component = c;
                break;
            }
        }
        return this.component;
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Override
    public int compareTo(Component o) {
        if (o == null) {
            return -1;
        }
        if (o == this) {
            return 0;
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public Object getPropertyValue(Object id) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return null;
        }
        switch (pid) {
            case NAME: {
                return this.getName();
            }
            case NAME_DATE: {
                return this.getNameDate();
            }
        }
        return null;
    }

    @Override
    protected void setPropertyValue2(Object id, Object value) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return;
        }
        switch (pid) {
            case NAME: {
                if (value != null && !(value instanceof String)) break;
                this.name = (String)value;
                break;
            }
            case NAME_DATE: {
                if (value != null && !(value instanceof Date)) break;
                this.nameDate = (Date)value;
            }
        }
    }

    public Date[] getRepoAccesses() {
        return new Date[]{this.nameDate, this.nameDate};
    }

    public static enum PropertyId {
        NAME,
        NAME_DATE;

    }
}

