/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.model;

import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import java.io.Serializable;

public class Collaboration
extends FlowVisConnection<FlowNode, FlowNode>
implements Serializable {
    private static final long serialVersionUID = 5173951168352848795L;
    private boolean visible = true;

    public Collaboration(FlowNode source, FlowNode target) {
        super(FlowNode.class, FlowNode.class, source, target);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isIncomingFlow() {
        boolean isIncomingFlow = false;
        IWorkspaceConnection sourceWc = ((FlowNode)this.getSource()).getWorkspaceConnection();
        IWorkspaceConnection targetWc = ((FlowNode)this.getTarget()).getWorkspaceConnection();
        if (sourceWc != null && targetWc != null) {
            IFlowTable flowTable = sourceWc.getFlowTable();
            isIncomingFlow = flowTable.getAcceptFlow((IFlowNodeHandle)targetWc.getResolvedWorkspace()) != null;
        }
        return isIncomingFlow;
    }

    public boolean isOutgoingFlow() {
        boolean isOutgoingFlow = false;
        IWorkspaceConnection sourceWc = ((FlowNode)this.getSource()).getWorkspaceConnection();
        IWorkspaceConnection targetWc = ((FlowNode)this.getTarget()).getWorkspaceConnection();
        if (sourceWc != null && targetWc != null) {
            IFlowTable flowTable = sourceWc.getFlowTable();
            isOutgoingFlow = flowTable.getDeliverFlow((IFlowNodeHandle)targetWc.getResolvedWorkspace()) != null;
        }
        return isOutgoingFlow;
    }

    public boolean isCurrentFlow() {
        FlowNode currentIncomingFlow = ((FlowNode)this.getSource()).getCurrentIncomingFlow();
        FlowNode currentOutgoingFlow = ((FlowNode)this.getSource()).getCurrentOutgoingFlow();
        return currentIncomingFlow != null && currentIncomingFlow.equals(this.getTarget()) || currentOutgoingFlow != null && currentOutgoingFlow.equals(this.getTarget());
    }

    public boolean isRemote() {
        return ((FlowNode)this.getSource()).isRemote();
    }

    public boolean isDefaultIncomingFlow() {
        FlowNode defaultIncomingFlow = ((FlowNode)this.getSource()).getDefaultIncomingFlow();
        return defaultIncomingFlow != null && defaultIncomingFlow.equals(this.getTarget());
    }

    public boolean isDefaultOutgoingFlow() {
        FlowNode defaultOutgoingFlow = ((FlowNode)this.getSource()).getDefaultOutgoingFlow();
        return defaultOutgoingFlow != null && defaultOutgoingFlow.equals(this.getTarget());
    }

    @Override
    public Object getPropertyValue(Object id) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            return super.getPropertyValue(id);
        }
        switch (pid) {
            case VISIBLE: {
                return this.isVisible();
            }
            case INCOMING_FLOW: {
                return this.isIncomingFlow();
            }
            case OUTGOING_FLOW: {
                return this.isOutgoingFlow();
            }
        }
        return super.getPropertyValue(id);
    }

    @Override
    protected void setPropertyValue2(Object id, Object value) {
        PropertyId pid = FlowVisUtil.filter(PropertyId.class, id);
        if (pid == null) {
            super.setPropertyValue2(id, value);
            return;
        }
        switch (pid) {
            case VISIBLE: {
                if (!(value instanceof Boolean)) break;
                this.visible = (Boolean)value;
            }
        }
    }

    public static enum PropertyId {
        VISIBLE,
        INCOMING_FLOW,
        OUTGOING_FLOW;

    }
}

