/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.gradient;

import com.ibm.team.internal.filesystem.ui.views.flowvis.gradient.FlowVisScaledGraphics;
import com.ibm.team.internal.filesystem.ui.views.flowvis.gradient.PaintRunnable;
import org.eclipse.draw2d.Graphics;

public class GradientPaint {
    private PaintRunnable gradient;
    private PaintRunnable safe;
    private PaintRunnable rest;

    public GradientPaint(PaintRunnable gradient, PaintRunnable safe, PaintRunnable rest) {
        this.gradient = gradient;
        this.safe = safe;
        this.rest = rest;
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        boolean ok = this.paintGradient(graphics);
        if (ok) {
            this.paintRest(graphics);
        } else {
            Graphics underlyingGraphics = null;
            if (graphics instanceof FlowVisScaledGraphics) {
                FlowVisScaledGraphics flowVisScaledGraphics = (FlowVisScaledGraphics)graphics;
                underlyingGraphics = flowVisScaledGraphics.getUnderlyingGraphics();
                underlyingGraphics.scale(flowVisScaledGraphics.getAbsoluteScale());
            }
            if (underlyingGraphics == null) {
                this.paintSafe(graphics);
                this.paintRest(graphics);
            } else {
                ok = this.paintGradient(underlyingGraphics);
                if (!ok) {
                    this.paintSafe(underlyingGraphics);
                }
                this.paintRest(underlyingGraphics);
                underlyingGraphics.restoreState();
            }
        }
        graphics.popState();
    }

    private void paintRest(Graphics graphics) {
        if (this.rest != null) {
            this.rest.paint(graphics);
        }
    }

    private void paintSafe(Graphics graphics) {
        if (this.safe != null) {
            this.safe.paint(graphics);
        }
    }

    private boolean paintGradient(Graphics graphics) {
        Object pattern = null;
        try {
            try {
                this.gradient.paint(graphics);
                graphics.setBackgroundPattern(null);
            }
            catch (RuntimeException e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                if (stackTrace.length > 0 && stackTrace[0].getMethodName().equals("subclassFunctionMission")) {
                    if (pattern != null) {
                        pattern.dispose();
                    }
                    return false;
                }
                throw e;
            }
        }
        finally {
            if (pattern != null) {
                pattern.dispose();
            }
        }
        return true;
    }
}

