/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.forms.FormColors;

public class PaintHover {
    public static final RGB HOVER_COLOR = new RGB(248, 192, 88);
    public static final RGB HOVER_COLOR2 = new RGB(248, 224, 168);
    private Color[] highlightColor = new Color[2];
    private Color[] hoverColor = new Color[2];
    private Rectangle b;
    private boolean inside;
    private boolean selected;
    private int corner;

    public static Color createInsideColour(ResourceManager resourceManager) {
        if (resourceManager == null) {
            return ColorConstants.listBackground;
        }
        RGB selectedRGB = ColorConstants.menuBackgroundSelected.getRGB();
        RGB back = ColorConstants.listBackground.getRGB();
        return resourceManager.createColor(FormColors.blend((RGB)selectedRGB, (RGB)back, (int)40));
    }

    public PaintHover(ResourceManager resourceManager, int corner) {
        this.highlightColor[0] = ColorConstants.menuBackgroundSelected;
        this.highlightColor[1] = PaintHover.createInsideColour(resourceManager);
        this.hoverColor[0] = resourceManager.createColor(HOVER_COLOR);
        this.hoverColor[1] = resourceManager.createColor(HOVER_COLOR2);
        this.b = new Rectangle();
        this.corner = corner;
    }

    public void setBounds(Rectangle bounds) {
        this.b.setBounds(bounds);
    }

    public Rectangle getRectangle() {
        int offset = 1;
        int shrink = 2;
        if (this.inside) {
            offset = 2;
            shrink = 4;
        }
        return new Rectangle(this.b.x + offset, this.b.y + offset, this.b.width - shrink, this.b.height - shrink);
    }

    public void setInside(boolean inside) {
        this.inside = inside;
    }

    public int getCorner() {
        return this.inside ? this.corner : this.corner + 2;
    }

    public Color getColor() {
        if (this.selected) {
            return this.highlightColor[this.inside ? 1 : 0];
        }
        return this.hoverColor[this.inside ? 1 : 0];
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void paint(Graphics g) {
        g.setLineWidth((int)g.getAbsoluteScale());
        g.setForegroundColor(this.getColor());
        g.drawRoundRectangle(this.getRectangle(), this.getCorner(), this.getCorner());
        g.restoreState();
    }
}

