/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.figures;

import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.IHighlightableFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.PaintHover;
import com.ibm.team.internal.filesystem.ui.views.flowvis.gradient.GradientPaint;
import com.ibm.team.internal.filesystem.ui.views.flowvis.gradient.PaintRunnable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class NoteFigure
extends Figure
implements IHighlightableFigure {
    private TextFlow textFlow;
    private boolean border;
    private int dogear;
    private boolean highlight;
    private boolean hover;
    private GradientPaint gradient;
    private ResourceManager resourceManager;
    private Color dogearColor;
    private PaintHover paintHover;

    public NoteFigure(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.dogear = 16;
        MarginBorder marginBorder = new MarginBorder(this.dogear + 2);
        this.setBorder((Border)marginBorder);
        FlowPage flowPage = new FlowPage();
        this.textFlow = new TextFlow();
        this.textFlow.setLayoutManager((LayoutManager)new ParagraphTextLayout(this.textFlow, 1));
        flowPage.add((IFigure)this.textFlow);
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)flowPage);
        this.paintHover = new PaintHover(resourceManager, 2);
        this.gradient = new GradientPaint(new PaintRunnable(){

            @Override
            public void paint(Graphics g) {
                Rectangle b = NoteFigure.this.getBounds();
                g.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)(b.right() - NoteFigure.this.dogear - 3), (float)(b.bottom() - NoteFigure.this.dogear - 3), (float)(b.right() - 3), (float)(b.bottom() - 3), NoteFigure.this.dogearColor, NoteFigure.this.getForegroundColor()));
                g.fillPolygon(new int[]{b.right() - NoteFigure.this.dogear - 3, b.bottom() - NoteFigure.this.dogear - 3, b.right() - 2, b.bottom() - NoteFigure.this.dogear - 3, b.right() - NoteFigure.this.dogear - 3, b.bottom() - 2});
            }
        }, null, new PaintRunnable(){

            @Override
            public void paint(Graphics g) {
                Rectangle b = NoteFigure.this.getBounds();
                g.drawLine(b.right() - NoteFigure.this.dogear - 3, b.bottom() - NoteFigure.this.dogear - 3, b.right() - 3, b.bottom() - NoteFigure.this.dogear - 3);
                g.drawLine(b.right() - NoteFigure.this.dogear - 3, b.bottom() - NoteFigure.this.dogear - 3, b.right() - NoteFigure.this.dogear - 3, b.bottom() - 3);
            }
        });
    }

    public void setOpaqueBorder(boolean border) {
        this.border = border;
        this.repaint();
    }

    public void setText(String text) {
        this.textFlow.setText(text);
    }

    public String getText() {
        return this.textFlow.getText();
    }

    public void setFont(Font f) {
        this.textFlow.setFont(f);
    }

    public void setFontColor(Color fg) {
        this.textFlow.setForegroundColor(fg);
    }

    protected void paintBorder(Graphics graphics) {
        if (this.border) {
            if (this.isOpaque()) {
                graphics.drawPolygon(this.getOutline());
            } else {
                Rectangle b = this.getBounds().getCopy();
                graphics.drawRectangle(b.x + 3, b.y + 3, b.width - 6, b.height - 6);
            }
        }
    }

    protected void paintFigure(Graphics graphics) {
        int diagonalOffset;
        int corner;
        Color c;
        if (this.isOpaque()) {
            PointList points = this.getOutline();
            graphics.fillPolygon(points);
            if (this.border) {
                this.gradient.paint(graphics);
            }
        }
        Rectangle b = this.getBounds();
        if (this.isHighlighted() || this.isHover()) {
            this.paintHover.setBounds(this.getBounds());
            this.paintHover.setInside(true);
            Rectangle inside = this.paintHover.getRectangle();
            this.paintHover.setSelected(this.isHighlighted());
            c = this.paintHover.getColor();
            if (this.isOpaque()) {
                corner = 2;
                diagonalOffset = 1;
                this.paintOutline(graphics, b, inside, c, corner, diagonalOffset);
            } else {
                this.paintHover.paint(graphics);
            }
        }
        if (this.isHighlighted() || this.isHover()) {
            this.paintHover.setInside(false);
            Rectangle outside = this.paintHover.getRectangle();
            c = this.paintHover.getColor();
            if (this.isOpaque()) {
                corner = 4;
                diagonalOffset = 2;
                this.paintOutline(graphics, b, outside, c, corner, diagonalOffset);
            } else {
                this.paintHover.paint(graphics);
            }
        }
    }

    private void paintOutline(Graphics graphics, Rectangle b, Rectangle r, Color c, int corner, int diagonalOffset) {
        graphics.setLineWidth((int)graphics.getAbsoluteScale());
        graphics.setForegroundColor(c);
        graphics.setClip(new Rectangle(b.x, b.y, b.width, b.height - this.dogear - 2));
        graphics.drawRoundRectangle(r, corner, corner);
        graphics.restoreState();
        graphics.setLineWidth((int)graphics.getAbsoluteScale());
        graphics.setForegroundColor(c);
        graphics.setClip(new Rectangle(b.x, b.y, b.width - this.dogear - 2, b.height));
        graphics.drawRoundRectangle(r, corner, corner);
        graphics.restoreState();
        graphics.setLineWidth((int)graphics.getAbsoluteScale());
        graphics.setForegroundColor(c);
        graphics.drawLine(r.right(), r.bottom() - this.dogear - diagonalOffset, r.right() - this.dogear - diagonalOffset, r.bottom());
        graphics.restoreState();
    }

    private PointList getOutline() {
        PointList points = new PointList();
        Rectangle b = this.getBounds().getCopy();
        b.x += 3;
        b.y += 3;
        b.width -= 6;
        b.height -= 6;
        points.addPoint(b.x, b.y);
        points.addPoint(b.right(), b.y);
        points.addPoint(b.right(), b.bottom() - this.dogear);
        points.addPoint(b.right() - this.dogear, b.bottom());
        points.addPoint(b.x, b.bottom());
        return points;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlight;
    }

    @Override
    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
        this.repaint();
    }

    public void setBackgroundColor(Color bg) {
        super.setBackgroundColor(bg);
        int red = bg.getRed();
        int blue = bg.getBlue();
        int green = bg.getGreen();
        if (red < blue) {
            if (green < red) {
                green /= 4;
            } else {
                red /= 4;
            }
        } else if (green < blue) {
            green /= 4;
        } else {
            blue /= 4;
        }
        this.dogearColor = this.resourceManager.createColor(new RGB(red, green, blue));
    }

    @Override
    public boolean isHover() {
        return this.hover;
    }

    @Override
    public void setHover(boolean hover) {
        this.hover = hover;
        this.repaint();
    }
}

