/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.figures;

import com.ibm.team.filesystem.ui.changes.views.DecorationImageDescriptor;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.DropDown;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.IHighlightableFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.PaintHover;
import com.ibm.team.internal.filesystem.ui.views.flowvis.gradient.GradientPaint;
import com.ibm.team.internal.filesystem.ui.views.flowvis.gradient.PaintRunnable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class FlowNodeFigure
extends Figure
implements IHighlightableFigure {
    public static final ImageDescriptor INCOMING = new DecorationImageDescriptor(ImagePool.WORKSPACE, 12, 0);
    public static final ImageDescriptor OUTGOING = new DecorationImageDescriptor(ImagePool.WORKSPACE, 13, 0);
    private static final int CORNER = 8;
    private static final int INSIDE_CORNER = 6;
    private Color bgColor;
    private Color bgColor2;
    private Color lineColor;
    private Figure componentsFigure;
    private ScrollPane componentsScrollPane;
    private Image expandComponentsIcon;
    private Image collapseComponentsIcon;
    private final Label loadingLabel = new Label(Messages.FlowNodeFigure_0);
    private Label titleLabel;
    private Label expandCollapseLabel;
    private Label expandRemoteIncomingConnectionsLabel;
    private Label expandFlowTargetsConnectionsLabel;
    private DropDown remoteIncomingDropDown;
    private DropDown flowTargetsDropDown;
    private IFigure toolbar;
    private TitleToolTip titleTooltip;
    private GradientPaint gradientPaint;
    private boolean hover;
    private boolean highlight;
    private PaintHover paintHover;

    public FlowNodeFigure(ResourceManager resourceManager, boolean isStream, boolean isRemote) {
        RGB rgbListbg;
        if (isStream) {
            Color grey = resourceManager.getDevice().getSystemColor(15);
            if (isRemote) {
                grey = resourceManager.getDevice().getSystemColor(16);
            }
            RGB rgbGrey = grey.getRGB();
            rgbListbg = ColorConstants.listBackground.getRGB();
            this.bgColor = resourceManager.createColor(FormColors.blend((RGB)rgbListbg, (RGB)rgbGrey, (int)70));
            this.bgColor2 = resourceManager.createColor(FormColors.blend((RGB)rgbListbg, (RGB)rgbGrey, (int)30));
            this.lineColor = grey;
        } else {
            Color darkCyan = resourceManager.getDevice().getSystemColor(14);
            RGB rgbDarkCyan = darkCyan.getRGB();
            rgbListbg = ColorConstants.listBackground.getRGB();
            RGB rgbWhite = new RGB(255, 255, 255);
            this.bgColor = resourceManager.createColor(FormColors.blend((RGB)rgbListbg, (RGB)rgbDarkCyan, (int)90));
            this.bgColor2 = resourceManager.createColor(FormColors.blend((RGB)rgbListbg, (RGB)rgbDarkCyan, (int)70));
            this.lineColor = resourceManager.createColor(FormColors.blend((RGB)rgbWhite, (RGB)rgbDarkCyan, (int)50));
        }
        ImageDescriptor image = isStream ? ImagePool.STREAM : ImagePool.WORKSPACE;
        this.expandComponentsIcon = resourceManager.createImageWithDefault(com.ibm.team.jface.internal.ImagePool.CHEVRON_DN);
        this.collapseComponentsIcon = resourceManager.createImageWithDefault(com.ibm.team.jface.internal.ImagePool.CHEVRON_UP);
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setObserveVisibility(true);
        layout.setStretchMinorAxis(true);
        layout.setMinorAlignment(0);
        this.setLayoutManager((LayoutManager)layout);
        int marginSize = 6;
        if (isRemote) {
            marginSize = 10;
        }
        this.setBorder((Border)new MarginBorder(marginSize));
        final IFigure header = this.createHeader(resourceManager, image);
        this.add(header);
        this.toolbar = this.createToolbar(resourceManager);
        this.add(this.toolbar);
        this.add(this.createComponentsFigure());
        this.setForegroundColor(this.lineColor);
        this.setHighlight(false);
        this.paintHover = new PaintHover(resourceManager, 10);
        this.gradientPaint = new GradientPaint(new PaintRunnable(){

            @Override
            public void paint(Graphics g) {
                Rectangle b = FlowNodeFigure.this.getBounds();
                g.setBackgroundColor(ColorConstants.listBackground);
                Rectangle insideKeyline = new Rectangle(b.x + 4, b.y + 4, b.width - 7, b.height - 7);
                g.fillRoundRectangle(insideKeyline, 8, 8);
                int x = b.x + 3;
                int y = b.y + 3;
                int width = b.width - 6;
                Rectangle r = new Rectangle(x, y, width, header.getBounds().height + 3);
                g.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)b.x, (float)y, (float)b.x, (float)(header.getBounds().bottom() - 1), ColorConstants.listBackground, FlowNodeFigure.this.bgColor));
                g.fillRoundRectangle(r, 8, 8);
                r = new Rectangle(x, header.getBounds().bottom() - 1, width, ((FlowNodeFigure)FlowNodeFigure.this).toolbar.getBounds().height + 2);
                g.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)b.x, (float)(header.getBounds().bottom() - 1), (float)b.x, (float)(FlowNodeFigure.this.toolbar.getBounds().bottom() + 2), FlowNodeFigure.this.bgColor2, ColorConstants.listBackground));
                g.fillRoundRectangle(r, 8, 8);
                g.setBackgroundPattern(new Pattern((Device)Display.getCurrent(), (float)b.x, (float)(header.getBounds().bottom() - 2), (float)b.x, (float)(header.getBounds().bottom() + 1), FlowNodeFigure.this.bgColor, FlowNodeFigure.this.bgColor2));
                g.fillRectangle(x, header.getBounds().bottom() - 2, width, 3);
            }
        }, new PaintRunnable(){

            @Override
            public void paint(Graphics g) {
                FlowNodeFigure.this.fillRectangle(g);
            }
        }, new PaintRunnable(){

            @Override
            public void paint(Graphics g) {
                FlowNodeFigure.this.paintFigure2(g);
            }
        });
    }

    private IFigure createHeader(ResourceManager resourceManager, ImageDescriptor imageDesc) {
        this.titleLabel = new Label(resourceManager.createImageWithDefault(imageDesc));
        this.titleLabel.setLabelAlignment(1);
        this.titleLabel.setForegroundColor(ColorConstants.black);
        this.titleLabel.setBorder((Border)new MarginBorder(2, 0, 0, 2));
        this.titleTooltip = new TitleToolTip(resourceManager);
        this.titleLabel.setToolTip((IFigure)this.titleTooltip);
        return this.titleLabel;
    }

    private static void setToolTip(IFigure figure, String text) {
        IFigure tooltip = figure.getToolTip();
        Label tooltipLabel = null;
        if (tooltip instanceof Label) {
            tooltipLabel = (Label)tooltip;
        } else {
            tooltipLabel = new Label();
            tooltipLabel.setBorder((Border)new MarginBorder(2));
            figure.setToolTip((IFigure)tooltipLabel);
        }
        tooltipLabel.setText(text);
    }

    private IFigure createToolbar(ResourceManager resourceManager) {
        Figure toolbar = new Figure();
        toolbar.setBorder((Border)new MarginBorder(0, 2, 0, 1));
        ToolbarLayout layout = new ToolbarLayout(true);
        layout.setStretchMinorAxis(true);
        layout.setSpacing(8);
        toolbar.setLayoutManager((LayoutManager)layout);
        this.expandCollapseLabel = new Label();
        this.expandCollapseLabel.setForegroundColor(ColorConstants.black);
        FontDescriptor dfd = this.scaleFont(JFaceResources.getDefaultFont().getFontData(), 0.875f);
        Font countFont = resourceManager.createFont(dfd);
        this.expandCollapseLabel.setFont(countFont);
        this.expandCollapseLabel.setLabelAlignment(1);
        toolbar.add((IFigure)this.expandCollapseLabel);
        this.expandRemoteIncomingConnectionsLabel = new Label(resourceManager.createImage(INCOMING));
        this.expandRemoteIncomingConnectionsLabel.setForegroundColor(ColorConstants.black);
        this.expandRemoteIncomingConnectionsLabel.setFont(countFont);
        this.expandRemoteIncomingConnectionsLabel.setTextPlacement(16);
        this.remoteIncomingDropDown = new DropDown((IFigure)this.expandRemoteIncomingConnectionsLabel);
        toolbar.add((IFigure)this.remoteIncomingDropDown);
        this.expandFlowTargetsConnectionsLabel = new Label(resourceManager.createImage(OUTGOING));
        this.expandFlowTargetsConnectionsLabel.setForegroundColor(ColorConstants.black);
        this.expandFlowTargetsConnectionsLabel.setFont(countFont);
        this.expandFlowTargetsConnectionsLabel.setTextPlacement(16);
        this.flowTargetsDropDown = new DropDown((IFigure)this.expandFlowTargetsConnectionsLabel);
        toolbar.add((IFigure)this.flowTargetsDropDown);
        return toolbar;
    }

    private FontDescriptor scaleFont(FontData[] dataArray, float scale) {
        FontData[] fontDataArray = dataArray;
        int n = dataArray.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight((int)((float)data.getHeight() * scale));
            ++n2;
        }
        return FontDescriptor.createFrom((FontData[])dataArray);
    }

    private IFigure createComponentsFigure() {
        this.componentsFigure = new Figure(){

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
            }
        };
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(true);
        this.componentsFigure.setLayoutManager((LayoutManager)layout);
        this.componentsFigure.setBorder((Border)new MarginBorder(2));
        this.componentsFigure.setOpaque(true);
        this.componentsScrollPane = new ScrollPane();
        this.componentsScrollPane.setHorizontalScrollBarVisibility(0);
        this.componentsScrollPane.setContents((IFigure)this.componentsFigure);
        return this.componentsScrollPane;
    }

    protected void paintFigure(Graphics graphics) {
        this.gradientPaint.paint(graphics);
    }

    private void paintFigure2(Graphics graphics) {
        Rectangle b = this.getBounds();
        graphics.setLineWidth(1);
        Rectangle b2 = new Rectangle(b.x + 4, b.y + 4, b.width - 8, b.height - 8);
        graphics.setForegroundColor(ColorConstants.listBackground);
        graphics.drawRoundRectangle(b2, 6, 6);
        if (this.getChildren().contains(this.componentsScrollPane)) {
            Rectangle componentsBounds = this.componentsScrollPane.getBounds();
            graphics.setBackgroundColor(this.componentsFigure.getBackgroundColor());
            graphics.fillRectangle(b.x + 4, componentsBounds.y - 1, b.width - 7, b.bottom() - componentsBounds.y - 8);
            int insideCorner1 = 5;
            graphics.fillRectangle(b.x + insideCorner1, b.bottom() - 8 - 3, b.width - insideCorner1 * 2, 8);
            graphics.fillOval(b.x + 4, b.bottom() - 8 - 3, 8, 8);
            graphics.fillOval(b.right() - 8 - 3, b.bottom() - 8 - 3, 8, 8);
            graphics.setForegroundColor(ColorConstants.listBackground);
            graphics.drawRoundRectangle(b2, 6, 6);
            graphics.drawLine(b.x + 3, componentsBounds.y - 2, b.right() - 4, componentsBounds.y - 2);
            graphics.setForegroundColor(this.lineColor);
            graphics.drawLine(b.x + 3, componentsBounds.y - 1, b.right() - 4, componentsBounds.y - 1);
        }
        Rectangle b1 = new Rectangle(b.x + 3, b.y + 3, b.width - 6, b.height - 6);
        graphics.setForegroundColor(this.lineColor);
        graphics.drawRoundRectangle(b1, 8, 8);
        if (this.isHighlighted() || this.isHover()) {
            graphics.pushState();
            this.paintHover.setBounds(this.getBounds());
            this.paintHover.setSelected(this.isHighlighted());
            this.paintHover.setInside(true);
            this.paintHover.paint(graphics);
            this.paintHover.setInside(false);
            this.paintHover.paint(graphics);
            graphics.popState();
        }
    }

    private void fillRectangle(Graphics graphics) {
        Rectangle b = this.getBounds();
        graphics.setBackgroundColor(this.bgColor);
        Rectangle insideKeyline = new Rectangle(b.x + 4, b.y + 4, b.width - 7, b.height - 7);
        graphics.fillRoundRectangle(insideKeyline, 8, 8);
    }

    public IFigure getComponentsFigure() {
        return this.componentsFigure;
    }

    public void setComponentsExpanded(boolean expanded) {
        if (expanded) {
            this.toolbar.setBorder((Border)new MarginBorder(0, 2, 4, 1));
            this.add((IFigure)this.componentsScrollPane);
        } else {
            this.toolbar.setBorder((Border)new MarginBorder(0, 2, 0, 1));
            if (this.getChildren().contains(this.componentsScrollPane)) {
                this.remove((IFigure)this.componentsScrollPane);
            }
        }
        Image icon = expanded ? this.collapseComponentsIcon : this.expandComponentsIcon;
        this.expandCollapseLabel.setIcon(icon);
    }

    public void setComponentCount(Integer count) {
        if (count != null) {
            this.expandCollapseLabel.setText(count.toString());
            FlowNodeFigure.setToolTip((IFigure)this.expandCollapseLabel, NLS.bind((String)Messages.FlowNodeFigure_9, (Object)count));
        } else {
            this.expandCollapseLabel.setText(Messages.FlowNodeFigure_10);
            FlowNodeFigure.setToolTip((IFigure)this.expandCollapseLabel, Messages.FlowNodeFigure_11);
        }
    }

    public void setFlowTargetsCount(int count, int visible) {
        this.expandFlowTargetsConnectionsLabel.setText(Integer.toString(count));
        FlowNodeFigure.setToolTip((IFigure)this.flowTargetsDropDown, NLS.bind((String)Messages.FlowNodeFigure_12, (Object)visible, (Object)count));
    }

    public void setRemoteIncomingCount(int count, int visible, boolean isStream) {
        this.expandRemoteIncomingConnectionsLabel.setText(Integer.toString(count));
        String tooltip = isStream ? NLS.bind((String)Messages.FlowNodeFigure_RemoteIncomingCountToStream, (Object)visible, (Object)count) : NLS.bind((String)Messages.FlowNodeFigure_RemoteIncomingCountToWorkspace, (Object)visible, (Object)count);
        FlowNodeFigure.setToolTip((IFigure)this.remoteIncomingDropDown, tooltip);
    }

    public void setBusy(boolean busy) {
        if (busy) {
            this.add((IFigure)this.loadingLabel);
        } else if (this.getChildren().contains(this.loadingLabel)) {
            this.remove((IFigure)this.loadingLabel);
        }
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitleTooltip(String name, String owner, String description) {
        this.titleTooltip.setName(name);
        this.titleTooltip.setOwner(owner);
        this.titleTooltip.setDescription(description);
    }

    @Override
    public boolean isHighlighted() {
        return this.highlight;
    }

    @Override
    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
        this.repaint();
    }

    public IFigure getExpandCollapseLabel() {
        return this.expandCollapseLabel;
    }

    public IFigure getRemoteIncomingButton() {
        return this.remoteIncomingDropDown;
    }

    public IFigure getFlowTargetsButton() {
        return this.flowTargetsDropDown;
    }

    @Override
    public boolean isHover() {
        return this.hover;
    }

    @Override
    public void setHover(boolean hover) {
        this.hover = hover;
        this.repaint();
    }

    private static class TitleToolTip
    extends Figure {
        private Label name;
        private Label owner;
        private TextFlow description;
        private GridLayout layout = new GridLayout(2, false);
        private FlowPage flowPage;

        public TitleToolTip(ResourceManager resourceManager) {
            FontData[] fontData;
            this.layout.verticalSpacing = 0;
            this.setLayoutManager((LayoutManager)this.layout);
            FontData[] fontDataArray = fontData = JFaceResources.getDefaultFont().getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                data.setStyle(1);
                ++n2;
            }
            Font f = resourceManager.createFont(FontDescriptor.createFrom((FontData[])fontData));
            Label nameLabel = new Label(Messages.FlowNodeFigure_2);
            nameLabel.setFont(f);
            nameLabel.setLabelAlignment(8);
            this.add((IFigure)nameLabel);
            this.name = new Label();
            this.name.setFont(JFaceResources.getDefaultFont());
            this.name.setLabelAlignment(1);
            this.layout.setConstraint((IFigure)this.name, (Object)this.newGridData());
            this.add((IFigure)this.name);
            Label ownerLabel = new Label(Messages.FlowNodeFigure_3);
            ownerLabel.setFont(f);
            ownerLabel.setLabelAlignment(8);
            this.add((IFigure)ownerLabel);
            this.owner = new Label();
            this.owner.setFont(JFaceResources.getDefaultFont());
            this.owner.setLabelAlignment(1);
            this.layout.setConstraint((IFigure)this.owner, (Object)this.newGridData());
            this.add((IFigure)this.owner);
            this.flowPage = new FlowPage();
            Label descriptionLabel = new Label(Messages.FlowNodeFigure_4);
            descriptionLabel.setFont(f);
            descriptionLabel.setLabelAlignment(8);
            this.layout.setConstraint((IFigure)descriptionLabel, (Object)new GridData(1, 1, false, false));
            this.add((IFigure)descriptionLabel);
            this.description = new TextFlow();
            this.description.setFont(JFaceResources.getDefaultFont());
            this.flowPage.add((IFigure)this.description);
            this.layout.setConstraint((IFigure)this.flowPage, (Object)this.newGridData());
            this.add((IFigure)this.flowPage);
        }

        private GridData newGridData() {
            GridData gridData = new GridData();
            gridData.verticalAlignment = 1;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            return gridData;
        }

        public void setName(String text) {
            this.name.setText(text);
        }

        public void setOwner(String text) {
            this.owner.setText(text);
        }

        public void setDescription(String text) {
            this.description.setText(text);
            GridData gridData = this.newGridData();
            Label temp = new Label(text);
            temp.setFont(JFaceResources.getDefaultFont());
            int descriptionWidth = temp.getPreferredSize().width;
            if (descriptionWidth > 200) {
                descriptionWidth = 200;
            }
            gridData.widthHint = Math.max(descriptionWidth, Math.max(this.name.getPreferredSize().width, this.owner.getPreferredSize().width));
            this.layout.setConstraint((IFigure)this.flowPage, (Object)gridData);
        }
    }
}

