/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;

public class DropDown
extends Figure {
    private IFigure down;
    private IFigure left;
    private int state;
    public static final int INITIAL = 0;
    public static final int HOVER = 1;
    public static final int ARMED = 2;

    public DropDown(IFigure left) {
        ToolbarLayout l = new ToolbarLayout(true);
        l.setStretchMinorAxis(true);
        l.setSpacing(2);
        this.setLayoutManager((LayoutManager)l);
        this.left = left;
        this.down = new Figure(){

            protected void paintFigure(Graphics graphics) {
                graphics.setBackgroundColor(ColorConstants.black);
                int x = this.getBounds().x + (this.getBounds().width - 6) / 2;
                int y = this.getBounds().y + (this.getBounds().height - 4) / 2;
                graphics.fillPolygon(new int[]{x, y, x + 6, y, x + 3, y + 3});
                super.paintFigure(graphics);
            }
        };
        this.down.setBackgroundColor(ColorConstants.black);
        this.down.setBounds(new Rectangle(0, 0, 12, 4));
        this.add(left);
        this.add(this.down);
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                if (me.button == 1) {
                    DropDown.this.setState(2);
                } else {
                    DropDown.this.setState(1);
                }
            }

            public void mouseExited(MouseEvent me) {
                DropDown.this.setState(0);
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        });
        this.setState(0);
    }

    protected void paintFigure(Graphics graphics) {
        if (this.state != 0) {
            Rectangle b = this.getBounds().getCopy();
            b.shrink(1, 1);
            graphics.drawRoundRectangle(b, 3, 3);
            int x = this.down.getBounds().x;
            graphics.drawLine(x, b.y, x, b.bottom());
        }
    }

    public IFigure getLeftFigure() {
        return this.left;
    }

    public IFigure getDownButton() {
        return this.down;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 2) {
            this.setBorder((Border)new MarginBorder(4, 3, 2, 0));
        } else {
            this.setBorder((Border)new MarginBorder(3, 2, 3, 1));
        }
    }
}

