/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.figures;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.IHighlightableFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.PaintHover;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;

public class CollaborationFigure
extends PolylineConnection
implements IHighlightableFigure {
    public static final int[] LINE_DASH = new int[]{1, 3};
    public static final int[] DEFAULT_LINE_DASH = new int[]{6, 2};
    private int[] lineDash = LINE_DASH;
    private Color highlightColor = ColorConstants.menuBackgroundSelected;
    private Color hoverColor;
    private Label incomingLabel;
    private Label outgoingLabel;
    private Label defaultLabel;
    private Label defaultIncomingLabel;
    private Label defaultOutgoingLabel;
    private boolean highlight;
    private boolean hover;

    public CollaborationFigure(ResourceManager resourceManager) {
        this.hoverColor = resourceManager.createColor(PaintHover.HOVER_COLOR);
        this.incomingLabel = new Label(Messages.CollaborationFigure_IncomingLabel);
        this.incomingLabel.setVisible(false);
        this.outgoingLabel = new Label(Messages.CollaborationFigure_OutgoingLabel);
        this.outgoingLabel.setVisible(false);
        this.defaultLabel = new Label(Messages.CollaborationFigure_0);
        this.defaultLabel.setVisible(false);
        this.defaultIncomingLabel = new Label(Messages.CollaborationFigure_DefaultIncomingLabel);
        this.defaultIncomingLabel.setVisible(false);
        this.defaultOutgoingLabel = new Label(Messages.CollaborationFigure_DefaultOutgoingLabel);
        this.defaultOutgoingLabel.setVisible(false);
        ConnectionEndpointLocator locator = new ConnectionEndpointLocator((Connection)this, true);
        locator.setUDistance(16);
        PolygonDecoration arrow = new PolygonDecoration();
        arrow.setScale(5.0, 3.0);
        this.setTargetDecoration((RotatableDecoration)arrow);
        this.add((IFigure)this.incomingLabel, locator);
        this.add((IFigure)this.outgoingLabel, locator);
        this.add((IFigure)this.defaultLabel, locator);
        this.add((IFigure)this.defaultIncomingLabel, locator);
        this.add((IFigure)this.defaultOutgoingLabel, locator);
    }

    public void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        super.paintFigure(graphics);
    }

    protected void outlineShape(Graphics g) {
        g.pushState();
        int lineWidth = this.getLineWidth();
        g.setLineDash(new int[0]);
        g.setForegroundColor(ColorConstants.white);
        g.setLineWidth(lineWidth + 2);
        PointList p = new PointList();
        p.addAll(this.getPoints());
        g.drawPolyline(p);
        g.setLineWidth(lineWidth);
        g.restoreState();
        if (this.isHighlighted()) {
            this.setForegroundColor(this.highlightColor);
        } else if (this.isHover()) {
            this.setForegroundColor(this.hoverColor);
        } else if (this.isCurrent()) {
            this.setForegroundColor(ColorConstants.darkGray);
        } else {
            this.setForegroundColor(ColorConstants.gray);
        }
        if (!this.isCurrent()) {
            g.setLineDash(this.lineDash);
        }
        super.outlineShape(g);
        g.popState();
    }

    @Override
    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
    }

    public void setCurrent(boolean current) {
        if (current) {
            this.setLineStyle(1);
        } else {
            this.setLineStyle(2);
        }
        this.repaint();
    }

    private boolean isCurrent() {
        return this.getLineStyle() == 1;
    }

    public void setDefault(boolean def) {
        this.lineDash = def ? DEFAULT_LINE_DASH : LINE_DASH;
        this.repaint();
    }

    public void setIncomingLabelVisible(boolean visible) {
        this.incomingLabel.setVisible(visible);
        this.outgoingLabel.setVisible(false);
        this.defaultLabel.setVisible(false);
        this.defaultIncomingLabel.setVisible(false);
        this.defaultOutgoingLabel.setVisible(false);
    }

    public void setOutgoingLabelVisible(boolean visible) {
        this.incomingLabel.setVisible(false);
        this.outgoingLabel.setVisible(visible);
        this.defaultLabel.setVisible(false);
        this.defaultIncomingLabel.setVisible(false);
        this.defaultOutgoingLabel.setVisible(false);
    }

    public void setDefaultLabelVisible(boolean visible) {
        this.incomingLabel.setVisible(false);
        this.outgoingLabel.setVisible(false);
        this.defaultLabel.setVisible(visible);
        this.defaultIncomingLabel.setVisible(false);
        this.defaultOutgoingLabel.setVisible(false);
    }

    public void setDefaultIncomingLabelVisible(boolean visible) {
        this.incomingLabel.setVisible(false);
        this.outgoingLabel.setVisible(false);
        this.defaultLabel.setVisible(false);
        this.defaultIncomingLabel.setVisible(visible);
        this.defaultOutgoingLabel.setVisible(false);
    }

    public void setDefaultOutgoingLabelVisible(boolean visible) {
        this.incomingLabel.setVisible(false);
        this.outgoingLabel.setVisible(false);
        this.defaultLabel.setVisible(false);
        this.defaultIncomingLabel.setVisible(false);
        this.defaultOutgoingLabel.setVisible(visible);
    }

    @Override
    public boolean isHighlighted() {
        return this.highlight;
    }

    @Override
    public boolean isHover() {
        return this.hover;
    }

    @Override
    public void setHover(boolean hover) {
        this.hover = hover;
        this.repaint();
    }
}

