/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.ConnectionCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.UserConnectionFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Note;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.UserConnection;
import org.eclipse.draw2d.Connection;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.RGB;

public class NoteGraphicalEditPolicy
extends GraphicalNodeEditPolicy {
    private ResourceManager resourceManager;

    public NoteGraphicalEditPolicy(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    protected Connection createDummyConnection(Request req) {
        UserConnectionFigure noteConnectionFigure = new UserConnectionFigure();
        noteConnectionFigure.setForegroundColor(this.resourceManager.createColor(new RGB(UserConnection.s_color[0], UserConnection.s_color[1], UserConnection.s_color[2])));
        noteConnectionFigure.setLineWidth(UserConnection.s_lineWidth);
        noteConnectionFigure.setLineStyle(UserConnection.s_lineStyle);
        noteConnectionFigure.setLineDash(UserConnection.s_lineDash);
        noteConnectionFigure.setTargetDecoration(UserConnection.s_targetDecoration);
        return noteConnectionFigure;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        FlowVisNode node = (FlowVisNode)this.getHost().getModel();
        Command startCommand = request.getStartCommand();
        if (startCommand instanceof ConnectionCommand) {
            ConnectionCommand cmd = (ConnectionCommand)startCommand;
            FlowVisNode source = cmd.getNewSource();
            if (!ConnectionCommand.canExecute(source, node)) {
                return null;
            }
            cmd.setNewTarget(node);
            cmd.setLabel(Messages.NoteGraphicalEditPolicy_0);
            return cmd;
        }
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        Object type = request.getNewObjectType();
        if (type == null) {
            return null;
        }
        if (UserConnection.class.equals(type)) {
            Note note = (Note)this.getHost().getModel();
            UserConnection<Object, Object> noteConnection = new UserConnection<Object, Object>(Note.class, FlowVisNode.class, null, null);
            ConnectionCommand cmd = new ConnectionCommand(noteConnection, Messages.NoteGraphicalEditPolicy_0);
            cmd.setNewSource(note);
            request.setStartCommand((Command)cmd);
            return cmd;
        }
        return null;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return null;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Object model = request.getConnectionEditPart().getModel();
        if (model instanceof UserConnection) {
            UserConnection conn = (UserConnection)model;
            FlowVisNode node = (FlowVisNode)this.getHost().getModel();
            Object source = conn.getSource();
            if (!ConnectionCommand.canExecute(source, node)) {
                return null;
            }
            ConnectionCommand cmd = new ConnectionCommand(conn, Messages.NoteGraphicalEditPolicy_2);
            cmd.setNewTarget(node);
            return cmd;
        }
        return null;
    }
}

