/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies;

import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.RemoveNotesCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisDiagramEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.NoteEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.UserConnectionEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisConnection;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Note;
import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;

public class NoteComponentEditPolicy
extends ComponentEditPolicy {
    protected Command createDeleteCommand(GroupRequest deleteRequest) {
        Command command = NoteComponentEditPolicy.createDeleteCommand(deleteRequest, NoteComponentEditPolicy.getDiagram(this.getHost()));
        if (command != null) {
            return command;
        }
        return super.createDeleteCommand(deleteRequest);
    }

    public static FlowVisDiagram getDiagram(EditPart host) {
        if (host instanceof NoteEditPart) {
            NoteEditPart noteEditPart = (NoteEditPart)host;
            EditPart parent = noteEditPart.getParent();
            if (parent instanceof FlowVisDiagramEditPart) {
                FlowVisDiagramEditPart flowVisDiagramEditPart = (FlowVisDiagramEditPart)parent;
                return (FlowVisDiagram)flowVisDiagramEditPart.getModel2();
            }
        } else if (host instanceof FlowNodeEditPart) {
            FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)host;
            EditPart parent = flowNodeEditPart.getParent();
            if (parent instanceof FlowVisDiagramEditPart) {
                FlowVisDiagramEditPart flowVisDiagramEditPart = (FlowVisDiagramEditPart)parent;
                return (FlowVisDiagram)flowVisDiagramEditPart.getModel2();
            }
        } else if (host instanceof UserConnectionEditPart) {
            UserConnectionEditPart connection = (UserConnectionEditPart)host;
            return NoteComponentEditPolicy.getDiagram(connection.getSource());
        }
        return null;
    }

    public static Command createDeleteCommand(GroupRequest deleteRequest, FlowVisDiagram diagram) {
        ArrayList<Note> notes = new ArrayList<Note>();
        ArrayList<FlowVisConnection> connections = new ArrayList<FlowVisConnection>();
        for (Object editPart : deleteRequest.getEditParts()) {
            if (editPart instanceof NoteEditPart) {
                NoteEditPart noteEditPart = (NoteEditPart)editPart;
                notes.add((Note)noteEditPart.getModel2());
                continue;
            }
            if (!(editPart instanceof UserConnectionEditPart)) continue;
            UserConnectionEditPart connectionEditPart = (UserConnectionEditPart)editPart;
            connections.add((FlowVisConnection)connectionEditPart.getModel2());
        }
        if (notes.size() > 0 || connections.size() > 0) {
            return new RemoveNotesCommand(notes, connections, diagram);
        }
        return null;
    }
}

