/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies;

import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.ComponentEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.IHighlightableFigure;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;

public class HighlightSelectionEditPolicy
extends ResizableEditPolicy {
    protected List createSelectionHandles() {
        EditPart editPart = this.getHost();
        if (!(editPart instanceof ConnectionEditPart)) {
            return super.createSelectionHandles();
        }
        return Collections.EMPTY_LIST;
    }

    protected void hideSelection() {
        super.hideSelection();
        this.setHighlight(this.getHost(), true, false);
    }

    protected void showSelection() {
        super.showSelection();
        this.setHighlight(this.getHost(), true, true);
    }

    private void setHighlight(Object o, boolean highlight, boolean value) {
        if (o != null && o instanceof GraphicalEditPart) {
            GraphicalEditPart editPart = (GraphicalEditPart)o;
            IFigure figure = editPart.getFigure();
            if (figure instanceof IHighlightableFigure) {
                IHighlightableFigure hFigure = (IHighlightableFigure)figure;
                if (highlight) {
                    hFigure.setHighlight(value);
                } else {
                    hFigure.setHover(value);
                }
            }
            for (Object connection : editPart.getSourceConnections()) {
                this.setHighlight(connection, highlight, value);
            }
            for (Object connection : editPart.getTargetConnections()) {
                this.setHighlight(connection, highlight, value);
            }
        }
    }

    public void eraseTargetFeedback(Request request) {
        this.setHover(false);
    }

    private void setHover(boolean value) {
        EditPart editPart = this.getHost();
        if (editPart instanceof ComponentEditPart) {
            ComponentEditPart componentEditPart = (ComponentEditPart)editPart;
            editPart = componentEditPart.getParent();
        }
        this.setHighlight(editPart, false, value);
    }

    public void showTargetFeedback(Request request) {
        this.setHover(true);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request.getType().equals("selection hover")) {
            return this.getHost();
        }
        return super.getTargetEditPart(request);
    }
}

