/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IWorkspaceSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.WorkspaceSyncContext;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.AddConnectionDialogCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.AddConnectionsCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.CreateNoteCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.CreateWorkspaceCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.SetPropertyCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisDiagramEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.NoteEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies.DragFigureEditPolicy;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Note;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class FlowVisLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (constraint instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)constraint;
            if (child instanceof FlowNodeEditPart) {
                FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)child;
                return new SetPropertyCommand((FlowVisModel)flowNodeEditPart.getModel2(), (Object)FlowNode.PropertyId.CONSTRAINT, rectangle, Messages.FlowVisLayoutEditPolicy_0);
            }
            if (child instanceof NoteEditPart) {
                NoteEditPart noteEditPart = (NoteEditPart)child;
                return new SetPropertyCommand((FlowVisModel)noteEditPart.getModel2(), (Object)Note.PropertyId.CONSTRAINT, rectangle, Messages.FlowVisLayoutEditPolicy_0);
            }
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        PrecisionRectangle rect = null;
        if (child instanceof FlowNodeEditPart) {
            FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)child;
            rect = new PrecisionRectangle(((FlowNode)flowNodeEditPart.getModel2()).getConstraint());
        } else if (child instanceof NoteEditPart) {
            NoteEditPart noteEditPart = (NoteEditPart)child;
            rect = new PrecisionRectangle(((Note)noteEditPart.getModel2()).getConstraint());
        } else {
            rect = new PrecisionRectangle(child.getFigure().getBounds());
        }
        Dimension sizeDelta = request.getSizeDelta();
        Point moveDelta = request.getMoveDelta();
        Rectangle original = rect.getCopy();
        child.getFigure().translateToAbsolute((Translatable)rect);
        rect = rect.getCopy().translate(moveDelta).resize(sizeDelta);
        child.getFigure().translateToRelative((Translatable)rect);
        rect.translate(this.getLayoutOrigin().getNegated());
        if (sizeDelta.width == 0 && sizeDelta.height == 0) {
            Rectangle cons = this.getCurrentConstraintFor(child);
            if (cons != null) {
                rect.setSize(cons.width, cons.height);
            }
        } else {
            Dimension minSize = this.getMinimumSizeFor(child);
            if (rect.width < minSize.width) {
                rect.width = minSize.width;
                if (rect.x > original.right() - minSize.width) {
                    rect.x = original.right() - minSize.width;
                }
            }
            if (rect.height < minSize.height) {
                rect.height = minSize.height;
                if (rect.y > original.bottom() - minSize.height) {
                    rect.y = original.bottom() - minSize.height;
                }
            }
        }
        return this.getConstraintFor((Rectangle)rect);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        FlowVisDiagram diagram = this.getDiagram();
        if (diagram == null) {
            return null;
        }
        Object type = request.getNewObjectType();
        if (type instanceof Object[]) {
            Object[] typeDetails = (Object[])type;
            Class cls = (Class)typeDetails[0];
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            Point location = constraint.getLocation();
            if (cls == Note.class) {
                return new CreateNoteCommand(diagram, constraint, (Note)request.getNewObject());
            }
            if (cls == WORKSPACES_OR_STREAMS.class) {
                WORKSPACES_OR_STREAMS showWorkspaces = (WORKSPACES_OR_STREAMS)((Object)typeDetails[1]);
                AddConnectionDialogCommand command = new AddConnectionDialogCommand(showWorkspaces, location);
                command.setDiagram(diagram);
                return command;
            }
            if (cls == IWorkspaceConnection.class) {
                Boolean isStream = (Boolean)typeDetails[1];
                CreateWorkspaceCommand command = new CreateWorkspaceCommand((boolean)isStream, location);
                command.setDiagram(diagram);
                return command;
            }
        } else if (type instanceof List) {
            List list = (List)type;
            AddConnectionsCommand command = new AddConnectionsCommand();
            command.setDiagram(diagram);
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            command.setLocation(constraint.getLocation());
            for (Object o : list) {
                if (o instanceof AbstractPlaceWrapper) {
                    AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)o);
                    command.addWorkspace((IWorkspaceHandle)wrapper.getWorkspace().getItemHandle());
                    continue;
                }
                if (!(o instanceof WorkspaceSyncContext)) continue;
                IWorkspaceSyncContext context = (IWorkspaceSyncContext)o;
                command.addWorkspace((IWorkspaceHandle)context.getLocal().getResolvedWorkspace());
            }
            return command;
        }
        return null;
    }

    private FlowVisDiagram getDiagram() {
        EditPart host = this.getHost();
        FlowVisDiagram diagram = null;
        if (host instanceof FlowVisDiagramEditPart) {
            FlowVisDiagramEditPart flowVisDiagramEditPart = (FlowVisDiagramEditPart)host;
            diagram = (FlowVisDiagram)flowVisDiagramEditPart.getModel2();
        }
        return diagram;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof FlowNodeEditPart) {
            return new DragFigureEditPolicy();
        }
        if (child instanceof NoteEditPart) {
            return new DragFigureEditPolicy();
        }
        return super.createChildEditPolicy(child);
    }

    protected IFigure getFeedbackLayer() {
        return this.getLayer("Scaled Feedback Layer");
    }
}

