/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.AddRemoveCollaborationCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.ConnectionCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.SetCurrentTargetCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.CollaborationFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.UserConnectionFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Note;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.UserConnection;
import org.eclipse.draw2d.Connection;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jface.resource.ResourceManager;

public class FlowNodeGraphicalEditPolicy
extends GraphicalNodeEditPolicy {
    private ResourceManager resourceManager;

    public FlowNodeGraphicalEditPolicy(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    protected Connection createDummyConnection(Request req) {
        CreateConnectionRequest createConnectionRequest;
        if (req instanceof CreateConnectionRequest && Collaboration.class.equals((createConnectionRequest = (CreateConnectionRequest)req).getNewObjectType())) {
            CollaborationFigure collaborationFigure = new CollaborationFigure(this.resourceManager);
            collaborationFigure.setDefault(false);
            collaborationFigure.setCurrent(false);
            return collaborationFigure;
        }
        UserConnectionFigure userConnectionFigure = new UserConnectionFigure();
        userConnectionFigure.setLineWidth(UserConnection.s_lineWidth);
        userConnectionFigure.setForegroundColor(FlowVisEditPart.createColor(this.resourceManager, UserConnection.s_color));
        userConnectionFigure.setLineStyle(UserConnection.s_lineStyle);
        userConnectionFigure.setLineDash(UserConnection.s_lineDash);
        userConnectionFigure.setTargetDecoration(UserConnection.s_targetDecoration);
        return userConnectionFigure;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        FlowNode node = (FlowNode)this.getHost().getModel();
        Command cmd = request.getStartCommand();
        ConnectionCommand connectionCommand = null;
        AddRemoveCollaborationCommand addRemoveCollaborationCommand = null;
        FlowVisNode source = null;
        if (cmd instanceof ConnectionCommand) {
            connectionCommand = (ConnectionCommand)cmd;
            source = connectionCommand.getNewSource();
        } else if (cmd instanceof AddRemoveCollaborationCommand) {
            addRemoveCollaborationCommand = (AddRemoveCollaborationCommand)cmd;
            source = addRemoveCollaborationCommand.getSource();
        }
        if (!ConnectionCommand.canExecute(source, node)) {
            return null;
        }
        if (connectionCommand != null) {
            connectionCommand.setNewTarget(node);
        } else if (addRemoveCollaborationCommand != null) {
            addRemoveCollaborationCommand.setTarget(node);
        }
        return cmd;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        Object type = request.getNewObjectType();
        if (type == null) {
            return null;
        }
        if (Collaboration.class.equals(type)) {
            FlowNode node = (FlowNode)this.getHost().getModel();
            AddRemoveCollaborationCommand cmd = new AddRemoveCollaborationCommand(new Collaboration(node, null), true);
            request.setStartCommand((Command)cmd);
            return cmd;
        }
        if (UserConnection.class.equals(type)) {
            FlowNode node = (FlowNode)this.getHost().getModel();
            UserConnection<Object, Object> connection = new UserConnection<Object, Object>(FlowNode.class, FlowVisNode.class, null, null);
            ConnectionCommand cmd = new ConnectionCommand(connection, Messages.FlowNodeGraphicalEditPolicy_0);
            cmd.setNewSource(node);
            request.setStartCommand((Command)cmd);
            return cmd;
        }
        return null;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        return null;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Object model = request.getConnectionEditPart().getModel();
        if (model instanceof UserConnection) {
            UserConnection conn = (UserConnection)model;
            FlowVisNode node = (FlowVisNode)this.getHost().getModel();
            Object source = conn.getSource();
            if (!(source instanceof Note)) {
                return null;
            }
            if (!ConnectionCommand.canExecute(source, node)) {
                return null;
            }
            ConnectionCommand cmd = new ConnectionCommand(conn, Messages.FlowNodeGraphicalEditPolicy_1);
            cmd.setNewTarget(node);
            return cmd;
        }
        if (model instanceof Collaboration) {
            Collaboration retargetingCollaboration = (Collaboration)model;
            FlowNode flowNode = (FlowNode)this.getHost().getModel();
            if (flowNode.equals(retargetingCollaboration.getTarget())) {
                return null;
            }
            if (!request.isMovingStartAnchor() && retargetingCollaboration.isCurrentFlow()) {
                FlowNode source = (FlowNode)retargetingCollaboration.getSource();
                Collaboration existingCollaboration = null;
                for (Collaboration c : source.getFlowTargetCollaborations()) {
                    FlowNode target = (FlowNode)c.getTarget();
                    if (!flowNode.equals(target)) continue;
                    existingCollaboration = c;
                    break;
                }
                if (existingCollaboration == null) {
                    return new AddRemoveCollaborationCommand(new Collaboration(source, flowNode), true, true);
                }
                return new SetCurrentTargetCommand(source, flowNode);
            }
        }
        return null;
    }
}

