/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies;

import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisDiagramEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.NoteEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies.HighlightSelectionEditPolicy;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.Handle;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Note;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.jface.resource.ResourceManager;

public class DragFigureEditPolicy
extends HighlightSelectionEditPolicy {
    @Override
    protected List createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.getHost();
        ResourceManager resourceManager = null;
        if (graphicalEditPart instanceof FlowNodeEditPart) {
            FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)graphicalEditPart;
            resourceManager = flowNodeEditPart.getResourceManager();
        } else if (graphicalEditPart instanceof NoteEditPart) {
            NoteEditPart noteEditPart = (NoteEditPart)graphicalEditPart;
            resourceManager = noteEditPart.getResourceManager();
        }
        list.add(new Handle(graphicalEditPart, 9, resourceManager));
        list.add(new Handle(graphicalEditPart, 17, resourceManager));
        list.add(new Handle(graphicalEditPart, 12, resourceManager));
        list.add(new Handle(graphicalEditPart, 20, resourceManager));
        return list;
    }

    @Override
    protected void hideSelection() {
        super.hideSelection();
    }

    @Override
    protected void showSelection() {
        super.showSelection();
        IFigure figure = this.getFigure();
        figure.getParent().add(figure);
    }

    private IFigure getFigure() {
        IFigure figure = ((GraphicalEditPart)this.getHost()).getFigure();
        return figure;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        Rectangle constraint = this.getConstraint();
        double zoom = this.getDiagram().getUtil().getZoomManager().getZoom();
        constraint.translate(request.getMoveDelta().getCopy().scale(1.0 / zoom));
        constraint.resize(request.getSizeDelta().getCopy().scale(1.0 / zoom));
        IFigure feedback = this.getDragSourceFeedbackFigure();
        feedback.getParent().setConstraint(feedback, (Object)constraint);
    }

    public void eraseSourceFeedback(Request request) {
        Rectangle constraint = this.getConstraint();
        IFigure feedback = this.getDragSourceFeedbackFigure();
        feedback.getParent().setConstraint(feedback, (Object)constraint);
    }

    private Rectangle getConstraint() {
        EditPart host = this.getHost();
        Rectangle constraint = null;
        FlowVisNode fvNode = null;
        Enum id = null;
        if (host instanceof FlowNodeEditPart) {
            FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)host;
            FlowNode node = (FlowNode)flowNodeEditPart.getModel2();
            constraint = node.getConstraint();
            fvNode = node;
            id = FlowNode.PropertyId.CONSTRAINT;
        } else if (host instanceof NoteEditPart) {
            NoteEditPart noteEditPart = (NoteEditPart)host;
            Note note = (Note)noteEditPart.getModel2();
            constraint = note.getConstraint();
            fvNode = note;
            id = Note.PropertyId.CONSTRAINT;
        }
        boolean needsFix = false;
        IFigure feedback = this.getDragSourceFeedbackFigure();
        if (constraint.width == -1) {
            constraint.width = feedback.getBounds().width;
            needsFix = true;
        }
        if (constraint.height == -1) {
            constraint.height = feedback.getBounds().height;
            needsFix = true;
        }
        if (needsFix && fvNode != null) {
            fvNode.setPropertyValue(id, constraint);
        }
        return constraint;
    }

    private FlowVisDiagram getDiagram() {
        EditPart host = this.getHost();
        FlowVisDiagram diagram = null;
        if (host instanceof FlowNodeEditPart) {
            FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)host;
            FlowNode node = (FlowNode)flowNodeEditPart.getModel2();
            diagram = node.getDiagram();
        } else if (host instanceof NoteEditPart) {
            NoteEditPart noteEditPart = (NoteEditPart)host;
            FlowVisDiagramEditPart flowVisDiagramEditPart = (FlowVisDiagramEditPart)noteEditPart.getParent();
            diagram = (FlowVisDiagram)flowVisDiagramEditPart.getModel2();
        }
        return diagram;
    }

    protected IFigure getDragSourceFeedbackFigure() {
        return this.getFigure();
    }
}

