/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editparts;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisConnectionEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.UserConnectionFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.UserConnection;
import java.util.Observable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class UserConnectionEditPart
extends FlowVisConnectionEditPart<UserConnection, UserConnectionFigure> {
    private AccessibleEditPart fAccessibleEditPart;

    public UserConnectionEditPart(ResourceManager resourceManager) {
        super(resourceManager);
    }

    protected IFigure createFigure() {
        return new UserConnectionFigure();
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
    }

    @Override
    public void refresh(Observable o, Object arg) {
        UserConnection.PropertyId id = FlowVisEditPart.getArg(UserConnection.PropertyId.class, arg);
        if (id == null) {
            super.refresh(o, arg);
            return;
        }
        switch (id) {
            case COLOR: {
                this.refreshColor();
                break;
            }
            case LINE_WIDTH: {
                this.refreshLineWidth();
                break;
            }
            case LINE_DASH: {
                this.refreshLineDash();
                break;
            }
            case LINE_STYLE: {
                this.refreshLineStyle();
                break;
            }
            case TARGET_DECORATION: {
                this.refreshTargetDecoration();
            }
        }
    }

    public void refreshVisuals() {
        this.refreshColor();
        this.refreshLineWidth();
        this.refreshLineDash();
        this.refreshLineStyle();
        this.refreshTargetDecoration();
    }

    private void refreshColor() {
        int[] rgb = ((UserConnection)this.getModel2()).getColor();
        ((UserConnectionFigure)((Object)this.getFigure2())).setForegroundColor(FlowVisEditPart.createColor(this.getResourceManager(), rgb));
    }

    private void refreshLineWidth() {
        ((UserConnectionFigure)((Object)this.getFigure2())).setLineWidth(((UserConnection)this.getModel2()).getLineWidth());
    }

    private void refreshLineDash() {
        ((UserConnectionFigure)((Object)this.getFigure2())).setLineDash(((UserConnection)this.getModel2()).getLineDash());
    }

    private void refreshLineStyle() {
        ((UserConnectionFigure)((Object)this.getFigure2())).setLineStyle(((UserConnection)this.getModel2()).getLineStyle());
    }

    private void refreshTargetDecoration() {
        ((UserConnectionFigure)((Object)this.getFigure2())).setTargetDecoration(((UserConnection)this.getModel2()).getTargetDecoration());
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.fAccessibleEditPart == null) {
            this.fAccessibleEditPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    String editPartType = Messages.UserConnectionEditPart_0;
                    String flowNodeConnection = Messages.UserConnectionEditPart_1;
                    FlowNodeEditPart flowNode = null;
                    if (UserConnectionEditPart.this.getSource() instanceof FlowNodeEditPart) {
                        flowNode = (FlowNodeEditPart)UserConnectionEditPart.this.getSource();
                    } else if (UserConnectionEditPart.this.getTarget() instanceof FlowNodeEditPart) {
                        flowNode = (FlowNodeEditPart)UserConnectionEditPart.this.getTarget();
                    }
                    if (flowNode != null) {
                        String flowNodeType = ((FlowNode)flowNode.getModel2()).isStream() ? Messages.UserConnectionEditPart_2 : Messages.UserConnectionEditPart_3;
                        String flowNodeName = ((FlowNode)flowNode.getModel2()).getName();
                        flowNodeConnection = NLS.bind((String)Messages.UserConnectionEditPart_4, (Object)flowNodeType, (Object)flowNodeName);
                    }
                    e.result = NLS.bind((String)Messages.FlowNodeEditPart_0, (Object)editPartType, (Object)NLS.bind((String)Messages.UserConnectionEditPart_5, (Object)flowNodeConnection));
                }
            };
        }
        return this.fAccessibleEditPart;
    }
}

