/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editparts;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.SetPropertyCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.AbstractDirectEditManager;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies.NoteComponentEditPolicy;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies.NoteGraphicalEditPolicy;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.NoteFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Note;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class NoteEditPart
extends FlowVisEditPart<Note, NoteFigure>
implements NodeEditPart {
    private ResourceManager fResourceManager;
    private AccessibleEditPart fAccessibleEditPart;
    private ConnectionAnchor anchor;

    public NoteEditPart(ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    protected IFigure createFigure() {
        return new NoteFigure(this.fResourceManager);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                String text = (String)request.getCellEditor().getValue();
                NoteEditPart noteEditPart = (NoteEditPart)this.getHost();
                Note note = (Note)noteEditPart.getModel2();
                SetPropertyCommand command = new SetPropertyCommand(note, (Object)Note.PropertyId.TEXT, text, Messages.NoteEditPart_0);
                command.add(new UpdateArg(note, (Object)Note.PropertyId.CONSTRAINT, noteEditPart.getFigure().getBounds()));
                return command;
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
                String value = (String)request.getCellEditor().getValue();
                NoteEditPart noteEditPart = (NoteEditPart)this.getHost();
                NoteFigure noteFigure = (NoteFigure)noteEditPart.getFigure2();
                noteFigure.setText(value);
                Rectangle bounds = ((Note)noteEditPart.getModel2()).getConstraint();
                int figureWidth = noteFigure.getBounds().width;
                Dimension preferredSize = noteFigure.getPreferredSize(figureWidth, -1);
                if (bounds.width < 0) {
                    bounds.width = figureWidth;
                }
                if (bounds.height < preferredSize.height) {
                    bounds.height = -1;
                    noteFigure.getParent().setConstraint((IFigure)noteFigure, (Object)bounds);
                }
                noteFigure.getUpdateManager().performUpdate();
            }
        });
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new NoteComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new NoteGraphicalEditPolicy(this.fResourceManager));
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return new Command(){

                    public void execute() {
                        NoteEditPart.this.performRequest((Request)new DirectEditRequest());
                    }
                };
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }
        });
    }

    public void performRequest(Request req) {
        if (req.getType() == "direct edit") {
            new AbstractDirectEditManager(this){

                @Override
                protected String getText() {
                    return ((NoteFigure)((NoteEditPart)this.getEditPart()).getFigure2()).getText();
                }
            }.show();
        } else {
            super.performRequest(req);
        }
    }

    @Override
    public void refresh(Observable o, Object arg) {
        Note.PropertyId id = NoteEditPart.getArg(Note.PropertyId.class, arg);
        FlowVisNode.PropertyId id2 = NoteEditPart.getArg(FlowVisNode.PropertyId.class, arg);
        if (id != null) {
            switch (id) {
                case CONSTRAINT: {
                    this.refreshConstraint();
                    break;
                }
                case TEXT: {
                    this.refreshText();
                    break;
                }
                case BACKGROUND_COLOR: {
                    this.refreshBackground();
                    break;
                }
                case BORDER: {
                    this.refreshBorder();
                    break;
                }
                case BORDER_COLOR: {
                    this.refreshForeground();
                    break;
                }
                case FONT: {
                    this.refreshFont();
                    break;
                }
                case FONT_COLOR: {
                    this.refreshFontColor();
                    break;
                }
                case OPAQUE: {
                    this.refreshOpaque();
                }
            }
        } else if (id2 != null) {
            switch (id2) {
                case INCOMING_CONNECTION: {
                    this.refreshTargetConnections();
                    break;
                }
                case OUTGOING_CONNECTION: {
                    this.refreshSourceConnections();
                }
            }
        } else {
            super.refresh(o, arg);
        }
    }

    protected void registerVisuals() {
        super.registerVisuals();
        this.refreshText();
        this.refreshConstraint();
        this.refreshBackground();
        this.refreshBorder();
        this.refreshForeground();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshOpaque();
    }

    private void refreshBackground() {
        NoteFigure noteFigure = (NoteFigure)this.getFigure2();
        int[] rgb = ((Note)this.getModel2()).getBackgroundColor();
        noteFigure.setBackgroundColor(NoteEditPart.createColor(this.fResourceManager, rgb));
    }

    private void refreshForeground() {
        NoteFigure noteFigure = (NoteFigure)this.getFigure2();
        int[] rgb = ((Note)this.getModel2()).getBorderColor();
        noteFigure.setForegroundColor(NoteEditPart.createColor(this.fResourceManager, rgb));
    }

    private void refreshFontColor() {
        NoteFigure noteFigure = (NoteFigure)this.getFigure2();
        int[] rgb = ((Note)this.getModel2()).getFontColor();
        noteFigure.setFontColor(NoteEditPart.createColor(this.fResourceManager, rgb));
    }

    public void refreshFont() {
        ((NoteFigure)this.getFigure2()).setFont(((Note)this.getModel2()).getFont().getFont(this.fResourceManager));
    }

    public void refreshBorder() {
        ((NoteFigure)this.getFigure2()).setOpaqueBorder(((Note)this.getModel2()).isOpaqueBorder());
    }

    public void refreshOpaque() {
        ((NoteFigure)this.getFigure2()).setOpaque(((Note)this.getModel2()).isOpaque());
    }

    protected void refreshConstraint() {
        NoteFigure noteFigure = (NoteFigure)this.getFigure2();
        noteFigure.getParent().setConstraint((IFigure)noteFigure, (Object)((Note)this.getModel2()).getConstraint());
    }

    protected void refreshText() {
        ((NoteFigure)this.getFigure2()).setText(((Note)this.getModel2()).getText());
    }

    protected List getModelSourceConnections() {
        return ((Note)this.getModel2()).getOutgoingFlowVisConnections();
    }

    protected List getModelTargetConnections() {
        return ((Note)this.getModel2()).getIncomingFlowVisConnections();
    }

    private ConnectionAnchor getAnchor() {
        if (this.anchor == null) {
            this.anchor = new ChopboxAnchor(this.getFigure()){

                protected Rectangle getBox() {
                    return super.getBox().getCopy().shrink(2, 2);
                }
            };
        }
        return this.anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.fAccessibleEditPart == null) {
            this.fAccessibleEditPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    String editPartType = Messages.NoteEditPart_2;
                    e.result = NLS.bind((String)Messages.NoteEditPart_1, (Object)editPartType, (Object)((NoteFigure)NoteEditPart.this.getFigure2()).getText());
                }
            };
        }
        return this.fAccessibleEditPart;
    }
}

