/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editparts;

import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies.FlowVisLayoutEditPolicy;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class FlowVisDiagramEditPart
extends FlowVisEditPart<FlowVisDiagram, IFigure> {
    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        figure.setBorder((Border)new MarginBorder(30));
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        figure.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        FlowVisLayoutEditPolicy editPolicy = new FlowVisLayoutEditPolicy();
        editPolicy.setXyLayout((XYLayout)this.getContentPane().getLayoutManager());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)editPolicy);
    }

    protected List getModelChildren() {
        ArrayList<FlowVisNode> list = new ArrayList<FlowVisNode>();
        FlowVisDiagram diagram = (FlowVisDiagram)this.getModel2();
        list.addAll(diagram.getFlowNodes());
        list.addAll(diagram.getNotes());
        return list;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshRouter();
    }

    @Override
    public void refresh(Observable observable, Object arg) {
        block12: {
            block11: {
                FlowVisDiagram.PropertyId id = FlowVisDiagramEditPart.getArg(FlowVisDiagram.PropertyId.class, arg);
                if (id == null) break block11;
                switch (id) {
                    case FLOW_NODES: {
                        this.refreshChildren();
                        Collection[] c = FlowVisDiagramEditPart.getArg(Collection[].class, arg);
                        if (c != null && c.length == 3) {
                            Point p = (Point)c[2].iterator().next();
                            this.getFigure().getLayoutManager().layout(this.getFigure());
                            HashMap<Object, Rectangle> modelToEditPart = new HashMap<Object, Rectangle>();
                            HashMap<Object, Dimension> modelToPreferredSize = new HashMap<Object, Dimension>();
                            for (Object o : this.getChildren()) {
                                if (!(o instanceof FlowVisEditPart)) continue;
                                FlowVisEditPart editPart = (FlowVisEditPart)o;
                                Object model = editPart.getModel2();
                                IFigure figure = editPart.getFigure();
                                Rectangle contraint = figure.getBounds();
                                modelToEditPart.put(model, contraint);
                                modelToPreferredSize.put(model, figure.getPreferredSize());
                            }
                            int x = p.x;
                            int y = p.y;
                            Animation.markBegin();
                            HashSet toAdd = new HashSet();
                            toAdd.addAll(c[0]);
                            for (Object o : c[0]) {
                                if (!(o instanceof FlowNode)) continue;
                                FlowNode flowNode = (FlowNode)o;
                                Dimension preferredSize = (Dimension)modelToPreferredSize.get(flowNode);
                                if (preferredSize == null) {
                                    preferredSize = new Dimension(-1, -1);
                                }
                                boolean collision = true;
                                block7: while (collision) {
                                    for (Map.Entry entry : modelToEditPart.entrySet()) {
                                        Rectangle constraint = (Rectangle)entry.getValue();
                                        Rectangle constraint2 = new Rectangle(x, y, preferredSize.width, preferredSize.height);
                                        if (toAdd.contains(entry.getKey()) || !constraint.touches(constraint2)) continue;
                                        x = p.x;
                                        y = constraint.y + constraint.height + 32;
                                        continue block7;
                                    }
                                    collision = false;
                                }
                                flowNode.setPropertyValue((Object)FlowNode.PropertyId.CONSTRAINT, new Rectangle(x, y, preferredSize.width, preferredSize.height));
                                x += preferredSize.width + 32;
                                toAdd.remove(flowNode);
                            }
                            Animation.run((int)((FlowVisDiagram)this.getModel2()).getAnimationSpeed());
                            break;
                        }
                        break block12;
                    }
                    case ROUTER: {
                        this.refreshRouter();
                        break;
                    }
                    case NOTES: {
                        this.refreshChildren();
                    }
                }
                break block12;
            }
            super.refresh(observable, arg);
        }
    }

    private void refreshRouter() {
        Animation.markBegin();
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        FanRouter router = new FanRouter();
        switch (((FlowVisDiagram)this.getModel2()).getRouter()) {
            case 1: {
                router.setNextRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            case 2: {
                router.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
                break;
            }
            default: {
                router.setNextRouter((ConnectionRouter)new ShortestPathConnectionRouter(this.getFigure()));
            }
        }
        cLayer.setConnectionRouter((ConnectionRouter)router);
        Animation.run((int)((FlowVisDiagram)this.getModel2()).getAnimationSpeed());
    }
}

