/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editparts;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.ExpandComponentsCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.ExpandFlowTargetsCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.ExpandRemoteIncomingCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.RemoveFlowNodesCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies.FlowNodeGraphicalEditPolicy;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.DropDown;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.FlowNodeFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Component;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class FlowNodeEditPart
extends FlowVisEditPart<FlowNode, FlowNodeFigure>
implements NodeEditPart {
    private ResourceManager fResourceManager;
    private AccessibleEditPart fAccessibleEditPart;
    private Listener expandFlowTargetsListener = new Listener(){

        public void handleEvent(Event event) {
            FlowVisUtil util = ((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram().getUtil();
            util.getCommandStack().execute((Command)new ExpandFlowTargetsCommand(FlowNodeEditPart.this));
        }
    };
    private Listener collapseFlowTargetsListener = new Listener(){

        public void handleEvent(Event event) {
            FlowVisUtil util = ((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram().getUtil();
            ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
            List<Collaboration> collaborations = ((FlowNode)FlowNodeEditPart.this.getModel2()).getFlowTargetCollaborations();
            for (Collaboration collaboration : collaborations) {
                nodes.add((FlowNode)collaboration.getTarget());
            }
            if (nodes.size() > 0) {
                util.getCommandStack().execute((Command)new RemoveFlowNodesCommand(((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram(), nodes));
            }
        }
    };
    private Listener expandRemoteIncomingListener = new Listener(){

        public void handleEvent(Event event) {
            FlowVisUtil util = ((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram().getUtil();
            util.getCommandStack().execute((Command)new ExpandRemoteIncomingCommand(FlowNodeEditPart.this));
        }
    };
    private Listener collapseRemoteIncomingListener = new Listener(){

        public void handleEvent(Event event) {
            FlowVisUtil util = ((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram().getUtil();
            List<Collaboration> collaborations = ((FlowNode)FlowNodeEditPart.this.getModel2()).getRemoteIncomingCollaborations();
            ArrayList<FlowNode> nodes = new ArrayList<FlowNode>();
            for (Collaboration collaboration : collaborations) {
                nodes.add((FlowNode)collaboration.getSource());
            }
            if (nodes.size() > 0) {
                util.getCommandStack().execute((Command)new RemoveFlowNodesCommand(((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram(), nodes));
            }
        }
    };
    private ConnectionAnchor anchor;

    public FlowNodeEditPart(ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    protected IFigure createFigure() {
        FlowNode flowNode = (FlowNode)this.getModel2();
        boolean isStream = flowNode.isStream();
        FlowNodeFigure flowNodeFigure = new FlowNodeFigure(this.fResourceManager, isStream, flowNode.isRemote());
        flowNodeFigure.setComponentsExpanded(flowNode.isComponentsExpanded());
        return flowNodeFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                return new RemoveFlowNodesCommand(((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram(), Collections.singleton((FlowNode)FlowNodeEditPart.this.getModel2()));
            }
        });
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new FlowNodeGraphicalEditPolicy(this.fResourceManager));
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTracker((EditPart)this){

            protected boolean handleButtonDown(int button) {
                FlowVisUtil util;
                double zoom;
                FlowNodeFigure f = (FlowNodeFigure)FlowNodeEditPart.this.getFigure2();
                IFigure target = this.getFigure(f, zoom = (util = ((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram().getUtil()).getZoomManager().getZoom());
                if (target != null && target.getParent() instanceof DropDown) {
                    DropDown dropDown = (DropDown)target.getParent();
                    dropDown.setState(button == 1 ? 2 : 0);
                }
                return super.handleButtonDown(button);
            }

            protected boolean handleDragStarted() {
                FlowNodeFigure f = (FlowNodeFigure)FlowNodeEditPart.this.getFigure2();
                ((DropDown)f.getRemoteIncomingButton()).setState(0);
                ((DropDown)f.getFlowTargetsButton()).setState(0);
                return super.handleDragStarted();
            }

            protected boolean handleButtonUp(int button) {
                if (button == 1 && this.isInState(2)) {
                    FlowVisUtil util;
                    double zoom;
                    FlowNodeFigure f = (FlowNodeFigure)FlowNodeEditPart.this.getFigure2();
                    IFigure target = this.getFigure(f, zoom = (util = ((FlowNode)FlowNodeEditPart.this.getModel2()).getDiagram().getUtil()).getZoomManager().getZoom());
                    if (target != null && target.getParent() instanceof DropDown) {
                        DropDown dropDown = (DropDown)target.getParent();
                        if (dropDown == f.getRemoteIncomingButton()) {
                            Listener expand = FlowNodeEditPart.this.expandRemoteIncomingListener;
                            Listener collapse = FlowNodeEditPart.this.collapseRemoteIncomingListener;
                            if (target == dropDown.getDownButton()) {
                                String collapseLabel;
                                String expandLabel;
                                int count = ((FlowNode)FlowNodeEditPart.this.getModel2()).getRemoteIncomingCount();
                                int visible = ((FlowNode)FlowNodeEditPart.this.getModel2()).getRemoteIncomingCollaborations().size();
                                boolean isStream = ((FlowNode)FlowNodeEditPart.this.getModel2()).isStream();
                                if (isStream) {
                                    expandLabel = Messages.FlowNodeEditPart_ShowRemoteIncomingFlowsToStream;
                                    collapseLabel = Messages.FlowNodeEditPart_HideRemoteIncomingFlowsToStream;
                                } else {
                                    expandLabel = Messages.FlowNodeEditPart_ShowRemoteIncomingFlowsToWorkspace;
                                    collapseLabel = Messages.FlowNodeEditPart_HideRemoteIncomingFlowsToWorkspace;
                                }
                                this.openMenu((IFigure)dropDown, util, expandLabel, collapseLabel, expand, collapse, visible != count, visible != 0);
                            } else if (target == dropDown.getLeftFigure()) {
                                expand.handleEvent(null);
                            }
                            dropDown.setState(0);
                        } else if (dropDown == f.getFlowTargetsButton()) {
                            Listener expand = FlowNodeEditPart.this.expandFlowTargetsListener;
                            Listener collapse = FlowNodeEditPart.this.collapseFlowTargetsListener;
                            if (target == dropDown.getDownButton()) {
                                int count = ((FlowNode)FlowNodeEditPart.this.getModel2()).getFlowTargetsCount();
                                int visible = ((FlowNode)FlowNodeEditPart.this.getModel2()).getFlowTargetCollaborations().size();
                                this.openMenu((IFigure)dropDown, util, Messages.FlowNodeFigure_8, Messages.FlowNodeFigure_7, expand, collapse, visible != count, visible != 0);
                            } else if (target == dropDown.getLeftFigure()) {
                                expand.handleEvent(null);
                            }
                            dropDown.setState(0);
                        } else {
                            dropDown.setState(1);
                        }
                    } else if (target == f.getExpandCollapseLabel()) {
                        util.getCommandStack().execute((Command)new ExpandComponentsCommand(FlowNodeEditPart.this));
                    }
                }
                return super.handleButtonUp(button);
            }

            private IFigure getFigure(FlowNodeFigure f, double zoom) {
                Point p = this.getCurrentInput().getMouseLocation().getCopy();
                Point p2 = p.getCopy();
                p2.scale(1.0 / zoom);
                f.translateToAbsolute((Translatable)p2);
                p.x += p.x - p2.x;
                p.y += p.y - p2.y;
                p.scale(1.0 / zoom);
                IFigure target = f.findFigureAt(p.x, p.y);
                return target;
            }

            private void openMenu(IFigure target, FlowVisUtil util, String expandLabel, String collapseLabel, Listener expand, Listener collapse, boolean expandEnabled, boolean collapseEnabled) {
                Menu menu = new Menu((Decorations)util.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setImage(FlowNodeEditPart.this.fResourceManager.createImage(ImagePool.EXPANDALL_ICON));
                item.setText(expandLabel);
                item.setEnabled(expandEnabled);
                item.addListener(13, expand);
                item = new MenuItem(menu, 8);
                item.setImage(FlowNodeEditPart.this.fResourceManager.createImage(ImagePool.COLLAPSEALL_ICON));
                item.setText(collapseLabel);
                item.setEnabled(collapseEnabled);
                item.addListener(13, collapse);
                Rectangle b = target.getBounds().getCopy();
                target.translateToAbsolute((Translatable)b);
                Control control = util.getGraphicalViewer().getControl();
                org.eclipse.swt.graphics.Point loc = control.getDisplay().map(control, null, b.x, b.bottom());
                menu.setLocation(loc.x, loc.y);
                menu.setVisible(true);
            }
        };
    }

    @Override
    public void refresh(Observable observable, Object arg) {
        block25: {
            FlowVisNode.PropertyId id2;
            block24: {
                FlowNode.PropertyId id = FlowNodeEditPart.getArg(FlowNode.PropertyId.class, arg);
                id2 = FlowNodeEditPart.getArg(FlowVisNode.PropertyId.class, arg);
                if (id == null) break block24;
                switch (id) {
                    case NAME: {
                        this.refreshName();
                        this.setConstraintToFigurePreferredSize();
                        break;
                    }
                    case OWNER: {
                        this.refreshName();
                        this.setConstraintToFigurePreferredSize();
                        break;
                    }
                    case DESCRIPTION: {
                        this.refreshToolTip();
                        break;
                    }
                    case FLOW_TARGETS_COUNT: {
                        this.refreshFlowTargetsCount();
                        this.setConstraintToFigurePreferredSize();
                        break;
                    }
                    case REMOTE_INCOMING_COUNT: {
                        this.refreshRemoteIncomingCount();
                        this.setConstraintToFigurePreferredSize();
                        break;
                    }
                    case CONSTRAINT: {
                        this.refreshConstraint();
                        break;
                    }
                    case COMPONENTS: {
                        this.refreshChildren();
                        if (((FlowNode)this.getModel2()).isComponentsExpanded()) {
                            this.setConstraintToFigurePreferredSize();
                            break;
                        }
                        break block25;
                    }
                    case COMPONENT_COUNT: {
                        this.refreshComponentCount();
                        this.setConstraintToFigurePreferredSize();
                        break;
                    }
                    case COMPONENTS_EXPANDED: {
                        this.setConstraintToFigurePreferredSize();
                        break;
                    }
                    case SHOW_REPOSITORY_WORKSPACE_NAME: {
                        this.refreshName();
                        this.setConstraintToFigurePreferredSize();
                        break;
                    }
                    case SHOW_STREAM_OWNER: {
                        this.refreshName();
                        this.setConstraintToFigurePreferredSize();
                        break;
                    }
                    case CURRENT_INCOMING_FLOW: {
                        this.refreshCurrentFlow();
                        break;
                    }
                    case CURRENT_OUTGOING_FLOW: {
                        this.refreshCurrentFlow();
                        break;
                    }
                    case DEFAULT_INCOMING_FLOW: {
                        this.refreshDefaultFlow();
                        break;
                    }
                    case DEFAULT_OUTGOING_FLOW: {
                        this.refreshDefaultFlow();
                    }
                }
                break block25;
            }
            if (id2 != null) {
                switch (id2) {
                    case INCOMING_CONNECTION: {
                        this.refreshTargetConnections();
                        break;
                    }
                    case OUTGOING_CONNECTION: {
                        this.refreshSourceConnections();
                    }
                }
            } else {
                super.refresh(observable, arg);
            }
        }
    }

    private void setConstraintToFigurePreferredSize() {
        FlowNode flowNode = (FlowNode)this.getModel2();
        Rectangle constraint = flowNode.getConstraint();
        FlowNodeFigure flowNodeFigure = (FlowNodeFigure)this.getFigure2();
        flowNodeFigure.setComponentsExpanded(flowNode.isComponentsExpanded());
        constraint.setSize(flowNodeFigure.getPreferredSize());
        ((FlowNode)this.getModel2()).setPropertyValue((Object)FlowNode.PropertyId.CONSTRAINT, constraint);
    }

    protected void refreshDefaultFlow() {
        this.refreshCurrentFlow();
    }

    protected void refreshCurrentFlow() {
        for (Object o : this.getSourceConnections()) {
            if (!(o instanceof EditPart)) continue;
            EditPart editPart = (EditPart)o;
            editPart.refresh();
        }
    }

    protected List getModelSourceConnections() {
        return ((FlowNode)this.getModel2()).getOutgoingFlowVisConnections();
    }

    protected List getModelTargetConnections() {
        return ((FlowNode)this.getModel2()).getIncomingFlowVisConnections();
    }

    protected List getModelChildren() {
        return new ArrayList<Component>(((FlowNode)this.getModel2()).getComponents());
    }

    protected void refreshSourceConnections() {
        super.refreshSourceConnections();
        this.refreshFlowTargetsCount();
    }

    private void refreshFlowTargetsCount() {
        FlowNode flowNode = (FlowNode)this.getModel2();
        ((FlowNodeFigure)this.getFigure2()).setFlowTargetsCount(flowNode.getFlowTargetsCount(), flowNode.getFlowTargetCollaborations().size());
    }

    protected void refreshTargetConnections() {
        super.refreshTargetConnections();
        this.refreshRemoteIncomingCount();
    }

    private void refreshRemoteIncomingCount() {
        FlowNode flowNode = (FlowNode)this.getModel2();
        ((FlowNodeFigure)this.getFigure2()).setRemoteIncomingCount(flowNode.getRemoteIncomingCount(), flowNode.getRemoteIncomingCollaborations().size(), flowNode.isStream());
    }

    protected void refreshConstraint() {
        FlowNodeFigure flowNodeFigure = (FlowNodeFigure)this.getFigure2();
        flowNodeFigure.getParent().setConstraint((IFigure)flowNodeFigure, (Object)((FlowNode)this.getModel2()).getConstraint());
    }

    protected void refreshName() {
        FlowNode flowNode = (FlowNode)this.getModel2();
        if (flowNode.isStream()) {
            boolean showOwner = false;
            showOwner = flowNode.isShowStreamOwner() || flowNode.getDiagram().isShowStreamOwner();
            ((FlowNodeFigure)this.getFigure2()).setTitle(showOwner ? flowNode.getOwner() : flowNode.getName());
        } else {
            boolean showName = false;
            showName = flowNode.isShowRepositoryWorkspaceName() || flowNode.getDiagram().isShowRepositoryWorkspaceName();
            ((FlowNodeFigure)this.getFigure2()).setTitle(showName ? flowNode.getName() : flowNode.getOwner());
        }
        this.refreshToolTip();
    }

    protected void refreshToolTip() {
        FlowNode flowNode = (FlowNode)this.getModel2();
        ((FlowNodeFigure)this.getFigure2()).setTitleTooltip(flowNode.getName(), flowNode.getOwner(), flowNode.getDescription());
    }

    protected void refreshComponentCount() {
        FlowNode flowNode = (FlowNode)this.getModel2();
        FlowNodeFigure flowNodeFigure = (FlowNodeFigure)this.getFigure2();
        flowNodeFigure.setComponentCount(flowNode.getComponentCount());
    }

    public IFigure getContentPane() {
        FlowNodeFigure flowNodeFigure = (FlowNodeFigure)this.getFigure2();
        return flowNodeFigure.getComponentsFigure();
    }

    protected void refreshVisuals() {
        this.refreshFlowTargetsCount();
        this.refreshRemoteIncomingCount();
        this.refreshComponentCount();
        this.refreshName();
        this.refreshToolTip();
        this.refreshConstraint();
    }

    private ConnectionAnchor getAnchor() {
        if (this.anchor == null) {
            this.anchor = new ChopboxAnchor(this.getFigure()){

                protected Rectangle getBox() {
                    return super.getBox().getCopy().shrink(2, 2);
                }
            };
        }
        return this.anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getAnchor();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.fAccessibleEditPart == null) {
            this.fAccessibleEditPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    String editPartType = ((FlowNode)FlowNodeEditPart.this.getModel2()).isStream() ? Messages.FlowNodeEditPart_1 : Messages.FlowNodeEditPart_2;
                    e.result = NLS.bind((String)Messages.FlowNodeEditPart_0, (Object)editPartType, (Object)((FlowNode)FlowNodeEditPart.this.getModel2()).getName());
                }
            };
        }
        return this.fAccessibleEditPart;
    }
}

