/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editparts;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies.HighlightSelectionEditPolicy;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.ComponentFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Component;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class ComponentEditPart
extends FlowVisEditPart<Component, ComponentFigure> {
    private ResourceManager fResourceManager;
    private AccessibleEditPart fAccessibleEditPart;

    public ComponentEditPart(ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
    }

    protected IFigure createFigure() {
        ComponentFigure componentFigure = new ComponentFigure(this.fResourceManager);
        return componentFigure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HighlightSelectionEditPolicy(){

            @Override
            protected List createSelectionHandles() {
                return Collections.EMPTY_LIST;
            }
        });
    }

    public DragTracker getDragTracker(Request request) {
        return new SelectEditPartTracker((EditPart)this);
    }

    @Override
    public void refresh(Observable o, Object arg) {
        Component.PropertyId id = ComponentEditPart.getArg(Component.PropertyId.class, arg);
        if (id != null) {
            switch (id) {
                case NAME: {
                    this.refreshName();
                }
            }
        } else {
            super.refresh(o, arg);
        }
    }

    protected void registerVisuals() {
        super.registerVisuals();
        this.refreshName();
    }

    public void refreshName() {
        ComponentFigure componentFigure = (ComponentFigure)this.getFigure2();
        componentFigure.setText(((Component)this.getModel2()).getName());
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.fAccessibleEditPart == null) {
            this.fAccessibleEditPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                public void getName(AccessibleEvent e) {
                    String editPartType = Messages.ComponentEditPart_1;
                    e.result = NLS.bind((String)Messages.ComponentEditPart_0, (Object)editPartType, (Object)((ComponentFigure)ComponentEditPart.this.getFigure2()).getText());
                }
            };
        }
        return this.fAccessibleEditPart;
    }
}

