/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.editparts;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.SetPropertyCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisConnectionEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editpolicies.HighlightSelectionEditPolicy;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.CollaborationFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.FlowNodeFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ComponentEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;

public class CollaborationEditPart
extends FlowVisConnectionEditPart<Collaboration, CollaborationFigure> {
    private AccessibleEditPart fAccessibleEditPart;

    public CollaborationEditPart(ResourceManager resourceManager) {
        super(resourceManager);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy(){

            protected List createSelectionHandles() {
                ArrayList<ConnectionEndpointHandle> list = new ArrayList<ConnectionEndpointHandle>();
                list.add(new ConnectionEndpointHandle((ConnectionEditPart)CollaborationEditPart.this, true, 2));
                list.add(new ConnectionEndpointHandle((ConnectionEditPart)CollaborationEditPart.this, !((Collaboration)CollaborationEditPart.this.getModel2()).isCurrentFlow(), 3));
                return list;
            }
        });
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected Command createDeleteCommand(GroupRequest deleteRequest) {
                return new SetPropertyCommand((FlowVisModel)CollaborationEditPart.this.getModel2(), (Object)Collaboration.PropertyId.VISIBLE, false, null);
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)new HighlightSelectionEditPolicy());
    }

    protected IFigure createFigure() {
        CollaborationFigure connector = new CollaborationFigure(this.getResourceManager());
        EditPart editPart = this.getSource();
        this.initHighlight(connector, editPart);
        if (!connector.isHighlighted()) {
            this.initHighlight(connector, this.getTarget());
        }
        return connector;
    }

    private void initHighlight(CollaborationFigure connector, EditPart editPart) {
        if (editPart instanceof FlowNodeEditPart) {
            FlowNodeEditPart flowNodeEditPart = (FlowNodeEditPart)editPart;
            FlowNodeFigure figure = (FlowNodeFigure)flowNodeEditPart.getFigure2();
            connector.setHighlight(figure.isHighlighted());
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshDirection();
        this.refreshCurrent();
        this.refreshDefault();
    }

    private void refreshDirection() {
        Collaboration collaboration = (Collaboration)this.getModel2();
        CollaborationFigure collaborationFigure = (CollaborationFigure)this.getFigure2();
        if (collaboration.isIncomingFlow() && !collaboration.isOutgoingFlow()) {
            collaborationFigure.setIncomingLabelVisible(true);
        } else if (!collaboration.isIncomingFlow() && collaboration.isOutgoingFlow()) {
            collaborationFigure.setOutgoingLabelVisible(true);
        } else {
            collaborationFigure.setIncomingLabelVisible(false);
            collaborationFigure.setOutgoingLabelVisible(false);
        }
    }

    private void refreshCurrent() {
        Collaboration collaboration = (Collaboration)this.getModel2();
        FlowNode source = (FlowNode)collaboration.getSource();
        CollaborationFigure collaborationFigure = (CollaborationFigure)this.getFigure2();
        boolean isCurrent = collaboration.isCurrentFlow();
        collaborationFigure.setCurrent(isCurrent);
        boolean visible = collaboration.isVisible();
        if (source.getDiagram().isShowOnlyCurrent()) {
            visible &= isCurrent;
        }
        collaborationFigure.setVisible(visible);
    }

    private void refreshVisible() {
        this.refreshCurrent();
    }

    private void refreshDefault() {
        Collaboration collaboration = (Collaboration)this.getModel2();
        FlowNode source = (FlowNode)collaboration.getSource();
        CollaborationFigure collaborationFigure = (CollaborationFigure)this.getFigure2();
        collaborationFigure.setDefault(collaboration.isDefaultIncomingFlow() || collaboration.isDefaultOutgoingFlow());
        boolean showDefaultLabels = source.getDiagram().isShowDefaultLabels();
        if (collaboration.isDefaultIncomingFlow() && collaboration.isDefaultOutgoingFlow()) {
            collaborationFigure.setDefaultLabelVisible(showDefaultLabels);
        } else if (collaboration.isDefaultIncomingFlow()) {
            collaborationFigure.setDefaultIncomingLabelVisible(showDefaultLabels);
        } else if (collaboration.isDefaultOutgoingFlow()) {
            collaborationFigure.setDefaultOutgoingLabelVisible(showDefaultLabels);
        }
    }

    @Override
    public void refresh(Observable o, Object arg) {
        Collaboration.PropertyId id = FlowVisEditPart.getArg(Collaboration.PropertyId.class, arg);
        if (id == null) {
            super.refresh(o, arg);
        }
        if (id != null) {
            switch (id) {
                case VISIBLE: {
                    this.refreshVisible();
                    break;
                }
                case INCOMING_FLOW: {
                    this.refreshDirection();
                    break;
                }
                case OUTGOING_FLOW: {
                    this.refreshDirection();
                }
            }
        } else {
            super.refresh(o, arg);
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.fAccessibleEditPart == null) {
            this.fAccessibleEditPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    String editPartType = Messages.CollaborationEditPart_0;
                    String sourceName = Messages.CollaborationEditPart_1;
                    if (CollaborationEditPart.this.getSource() instanceof FlowNodeEditPart) {
                        FlowNodeEditPart flowNode = (FlowNodeEditPart)CollaborationEditPart.this.getSource();
                        String flowNodeType = ((FlowNode)flowNode.getModel2()).isStream() ? Messages.CollaborationEditPart_3 : Messages.CollaborationEditPart_4;
                        String flowNodeName = ((FlowNode)flowNode.getModel2()).getName();
                        sourceName = NLS.bind((String)Messages.CollaborationEditPart_2, (Object)flowNodeType, (Object)flowNodeName);
                    }
                    String targetName = Messages.CollaborationEditPart_1;
                    if (CollaborationEditPart.this.getTarget() instanceof FlowNodeEditPart) {
                        FlowNodeEditPart flowNode = (FlowNodeEditPart)CollaborationEditPart.this.getTarget();
                        String flowNodeType = ((FlowNode)flowNode.getModel2()).isStream() ? Messages.CollaborationEditPart_3 : Messages.CollaborationEditPart_4;
                        String flowNodeName = ((FlowNode)flowNode.getModel2()).getName();
                        targetName = NLS.bind((String)Messages.CollaborationEditPart_2, (Object)flowNodeType, (Object)flowNodeName);
                    }
                    e.result = NLS.bind((String)Messages.CollaborationEditPart_6, (Object)editPartType, (Object)NLS.bind((String)Messages.CollaborationEditPart_5, (Object)sourceName, (Object)targetName));
                }
            };
        }
        return this.fAccessibleEditPart;
    }
}

