/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs;

import com.ibm.team.filesystem.ui.views.SimplePartInput;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.AddConnectionsCommand;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IMnemonicGenerationAlgorithm;
import com.ibm.team.repository.rcp.ui.parts.IPartFactory;
import com.ibm.team.repository.rcp.ui.parts.PartFactory;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.WidgetToolkit;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.MnemonicGenerator;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import java.util.Map;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.Preferences;

public class SelectRepositoryPart
extends AbstractPart {
    private SimplePartInput<Map<ITeamRepository, AddConnectionsCommand>, ITeamRepository> input;
    private RepositoryCombo repo;
    private Label count;
    ISelectionChangedListener repoChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SelectRepositoryPart.this.updateEnablement();
        }
    };
    private Control okayButton;

    public SelectRepositoryPart(IControlSite site, SimplePartInput<Map<ITeamRepository, AddConnectionsCommand>, ITeamRepository> input) {
        super(site, input);
        WidgetFactoryContext context = site.getContext();
        MnemonicGenerator mnemonics = new MnemonicGenerator((IMnemonicGenerationAlgorithm)site.getMnemonicGenerator());
        site.getNameable().setName(Messages.SelectRepositoryPart_0);
        site.getNameable().setImage(ImagePool.CHOICE);
        this.input = input;
        Composite parent = site.getParent();
        WidgetToolkit toolkit = site.getToolkit();
        toolkit.createLabel(parent, mnemonics.generate(Messages.SelectRepositoryPart_1));
        this.repo = new RepositoryCombo(parent, (Preferences)this.getConfigPrefs(), context);
        ITeamRepository repository = null;
        int max = 0;
        for (Map.Entry<ITeamRepository, AddConnectionsCommand> entry : input.getInput().entrySet()) {
            AddConnectionsCommand command = entry.getValue();
            if (command == null || command.workspacesSize() <= max) continue;
            max = command.workspacesSize();
            repository = entry.getKey();
        }
        if (repository != null) {
            this.repo.setSelectedElement(repository);
        }
        GridDataFactory.fillDefaults().grab(true, false).hint(300, -1).applyTo(this.repo.getControl());
        this.count = toolkit.createLabel(parent, "");
        GridDataFactory.generate((Control)this.count, (int)2, (int)1);
        ButtonBar bbar = MessageDialogFactory.createOkayCancelBar((WidgetToolkit)toolkit, (Composite)parent, (IPartResult)new IPartResult(){

            public void setResult(Object result) {
                if (result == MessageDialogFactory.OKAY.getValue()) {
                    SelectRepositoryPart.this.doOkay();
                } else {
                    SelectRepositoryPart.this.doCancel();
                }
            }
        });
        GridDataFactory.generate((Control)bbar.getControl(), (int)2, (int)1);
        this.okayButton = bbar.getButton(MessageDialogFactory.OKAY.getValue());
        Dialog.applyDialogFont((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(parent);
        this.repo.getSelectionProvider().addSelectionChangedListener(this.repoChangedListener);
        site.setDefaultButton((Button)this.okayButton);
        this.updateEnablement();
    }

    protected IEclipsePreferences getConfigPrefs() {
        IEclipsePreferences result = new ConfigurationScope().getNode("com.ibm.team.filesystem.ide.ui/" + ((Object)((Object)this)).getClass().getName());
        return result;
    }

    protected void updateEnablement() {
        ITeamRepository repo = this.getRepository();
        boolean enabled = repo != null;
        AddConnectionsCommand command = this.input.getInput().get(repo);
        int size = command == null ? 0 : command.workspacesSize();
        this.count.setText(NLS.bind((String)Messages.SelectRepositoryPart_3, (Object)size));
        this.okayButton.setEnabled(enabled);
    }

    private ITeamRepository getRepository() {
        return this.repo.getRepository();
    }

    protected void doOkay() {
        if (!this.okayButton.isEnabled()) {
            return;
        }
        this.input.setResult(this.getRepository());
        this.getControlSite().close();
    }

    protected void doCancel() {
        this.getControlSite().close();
    }

    public static void openDialog(UIContext context, Map<ITeamRepository, AddConnectionsCommand> input, IPartResult<ITeamRepository> result) {
        Parts.openDialog((Shell)context.getShell(), new SimplePartInput<Map<ITeamRepository, AddConnectionsCommand>, ITeamRepository>(input, result), (IPartFactory)new PartFactory(SelectRepositoryPart.class));
    }
}

