/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs;

import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowNodesCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs.ConnectionQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.query.IPageable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.UnionSet;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;

public class MultiRepoConnectionQuery
extends UnionSet<Map.Entry<IWorkspaceConnection, String>>
implements IPageable,
IValueChangeListener {
    private ArrayList<ConnectionQuery> connectionQueries = new ArrayList();
    private WritableValue hasMore = new WritableValue();
    private WritableValue fetchedSize = new WritableValue();
    private WritableValue totalSize = new WritableValue();

    public MultiRepoConnectionQuery(Collection<IFlowEntry> flowEntries, ITeamRepository defaultRepo, IOperationRunner runner) {
        Map<ITeamRepository, List<IWorkspaceHandle>> groupByRepo = FlowNodesCommand.groupByRepository(flowEntries, defaultRepo);
        for (Map.Entry<ITeamRepository, List<IWorkspaceHandle>> entry : groupByRepo.entrySet()) {
            ConnectionQuery connectionQuery = new ConnectionQuery(entry.getValue(), entry.getKey(), runner);
            connectionQuery.hasMore().addValueChangeListener((IValueChangeListener)this);
            connectionQuery.fetchedSize().addValueChangeListener((IValueChangeListener)this);
            connectionQuery.totalSize().addValueChangeListener((IValueChangeListener)this);
            this.connectionQueries.add(connectionQuery);
            this.add((ISetWithListeners)connectionQuery);
        }
        this.handleValueChange(null);
    }

    public void goMore() {
        for (ConnectionQuery connectionQuery : this.connectionQueries) {
            if (!connectionQuery.hasMore().getValue().equals(Boolean.TRUE)) continue;
            connectionQuery.goMore();
            return;
        }
    }

    public IObservableValue hasMore() {
        return this.hasMore;
    }

    public IObservableValue fetchedSize() {
        return this.fetchedSize;
    }

    public IObservableValue totalSize() {
        return this.totalSize;
    }

    public int numStreams() {
        int streams = 0;
        for (ConnectionQuery connectionQuery : this.connectionQueries) {
            streams += connectionQuery.numStreams();
        }
        return streams;
    }

    public void setQueryStreamsFirst(boolean streamsFirst) {
        for (ConnectionQuery connectionQuery : this.connectionQueries) {
            connectionQuery.setQueryStreamsFirst(streamsFirst);
        }
    }

    public void handleValueChange(ValueChangeEvent event) {
        boolean hasMoreAggregate = false;
        long fetchedSizeAggregate = 0L;
        long totalSizeAggregate = 0L;
        for (ConnectionQuery connectionQuery : this.connectionQueries) {
            Number n;
            Object o = connectionQuery.hasMore().getValue();
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                hasMoreAggregate |= b.booleanValue();
            }
            if ((o = connectionQuery.fetchedSize().getValue()) instanceof Number) {
                n = (Number)o;
                fetchedSizeAggregate += n.longValue();
            }
            if (!((o = connectionQuery.totalSize().getValue()) instanceof Number)) continue;
            n = (Number)o;
            totalSizeAggregate += n.longValue();
        }
        Object o = this.hasMore.getValue();
        Boolean newHasMore = hasMoreAggregate;
        if (!newHasMore.equals(o)) {
            this.hasMore.setValue((Object)newHasMore);
        }
        o = this.fetchedSize.getValue();
        Long newFetchedSize = fetchedSizeAggregate;
        if (!newFetchedSize.equals(o)) {
            this.fetchedSize.setValue((Object)fetchedSizeAggregate);
        }
        o = this.totalSize.getValue();
        Long newTotalSize = totalSizeAggregate;
        if (!newTotalSize.equals(o)) {
            this.totalSize.setValue((Object)totalSizeAggregate);
        }
    }

    public synchronized void dispose() {
        for (ConnectionQuery connectionQuery : this.connectionQueries) {
            connectionQuery.hasMore().removeValueChangeListener((IValueChangeListener)this);
            connectionQuery.fetchedSize().removeValueChangeListener((IValueChangeListener)this);
            connectionQuery.totalSize().removeValueChangeListener((IValueChangeListener)this);
        }
        super.dispose();
    }
}

