/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowNodesCommand;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.query.PagedQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;

public class ConnectionQuery
extends PagedQuery<Map.Entry<IWorkspaceConnection, String>> {
    private LinkedHashMap<UUID, IWorkspaceHandle> handles;
    private Map<IWorkspaceConnection, String> connections;
    private boolean queryStreamsFirst;
    private int numStreams = -1;

    public ConnectionQuery(List<IWorkspaceHandle> handles, ITeamRepository repository, IOperationRunner runner) {
        super(repository, runner);
        this.handles = new LinkedHashMap(handles.size());
        for (IWorkspaceHandle handle : handles) {
            this.handles.put(handle.getItemId(), handle);
        }
        this.connections = new HashMap<IWorkspaceConnection, String>();
    }

    protected PagedQuery.QueryResult<Map.Entry<IWorkspaceConnection, String>> fetchNextPage(int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ConnectionQuery_0, (int)3);
        sub.setTaskName(Messages.ConnectionQuery_0);
        if (this.queryStreamsFirst && this.numStreams < 0 && this.handles.size() > pageSize) {
            List workspaces = this.getRepository().itemManager().fetchPartialItems(new ArrayList<IWorkspaceHandle>(this.handles.values()), 0, Collections.singletonList(IWorkspace.STREAM_PROPERTY), (IProgressMonitor)sub.newChild(1));
            this.numStreams = this.numStreamConnections();
            for (IWorkspace workspace : workspaces) {
                if (workspace.isStream()) {
                    ++this.numStreams;
                    continue;
                }
                UUID uuid = workspace.getItemId();
                IWorkspaceHandle handle = this.handles.get(uuid);
                if (handle == null) continue;
                this.handles.remove(uuid);
                this.handles.put(uuid, handle);
            }
        }
        sub.setWorkRemaining(2);
        ArrayList<IWorkspaceHandle> toFetch = new ArrayList<IWorkspaceHandle>();
        Iterator<Map.Entry<UUID, IWorkspaceHandle>> iter = this.handles.entrySet().iterator();
        int i = 0;
        while (iter.hasNext() && i < pageSize) {
            IWorkspaceHandle handle = iter.next().getValue();
            iter.remove();
            toFetch.add(handle);
            ++i;
        }
        List<IWorkspaceConnection> workspaceConnections = ConnectionQuery.getWorkspaceConnectionsFromHandles(this.getRepository(), toFetch, (IProgressMonitor)sub.newChild(1));
        sub.setWorkRemaining(workspaceConnections.size());
        Map<IWorkspaceConnection, String> ownerNames = FlowNodesCommand.getOwnerNames(workspaceConnections, (IProgressMonitor)sub.newChild(1));
        this.connections.putAll(ownerNames);
        PagedQuery.QueryResult result = new PagedQuery.QueryResult(new ArrayList<Map.Entry<IWorkspaceConnection, String>>(this.connections.entrySet()), (long)(this.handles.size() + this.connections.size()), this.handles.size() > 0);
        return result;
    }

    private static List<IWorkspaceConnection> getWorkspaceConnectionsFromHandles(ITeamRepository repo, List<? extends IWorkspaceHandle> workspaceHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)workspaceHandles.size());
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        List fetched = workspaceManager.getWorkspaceConnections(workspaceHandles, (IProgressMonitor)sub.newChild(workspaceHandles.size()));
        ArrayList<IWorkspaceConnection> connections = new ArrayList<IWorkspaceConnection>();
        int i = 0;
        while (i < fetched.size()) {
            IWorkspaceConnection connection = (IWorkspaceConnection)fetched.get(i);
            if (connection == null) {
                ItemNotFoundException e = new ItemNotFoundException((IItemHandle)workspaceHandles.get(i));
                StatusUtil.log((IStatus)StatusUtil.newStatus(FlowNodesCommand.class, (Throwable)e));
            } else {
                connections.add(connection);
            }
            ++i;
        }
        return connections;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    public String getName() {
        return Messages.ConnectionQuery_0;
    }

    public int numStreams() {
        if (this.handles.isEmpty()) {
            this.numStreams = this.numStreamConnections();
        }
        return this.numStreams;
    }

    public int numHandles() {
        return this.handles.size();
    }

    public int numStreamConnections() {
        int numStreams = 0;
        for (IWorkspaceConnection connection : this.connections.keySet()) {
            if (!connection.isStream()) continue;
            ++numStreams;
        }
        return numStreams;
    }

    public void setQueryStreamsFirst(boolean queryStreamsFirst) {
        this.queryStreamsFirst = queryStreamsFirst;
    }
}

