/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.TableOrTreeResizer;
import com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs.MultiRepoConnectionQuery;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.repository.rcp.ui.internal.query.PagedTable;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AddConnectionDialog
extends Wizard {
    private PagedTable<Map.Entry<IWorkspaceConnection, String>> pagedTable;
    Button fSelectWorkspacesButton;
    Button fSelectStreamsButton;
    private Map<IWorkspaceConnection, String> selection;
    private Collection<IFlowEntry> handles;
    private ITeamRepository repo;
    private IOperationRunner runner;
    private boolean streamsFirstDefault;

    public AddConnectionDialog(Collection<IFlowEntry> handles, ITeamRepository repo, IOperationRunner runner, boolean streamsFirstDefault) {
        this.setWindowTitle(Messages.AddConnectionDialog_0);
        this.handles = handles;
        this.repo = repo;
        this.runner = runner;
        this.streamsFirstDefault = streamsFirstDefault;
    }

    public void addPages() {
        this.addPage((IWizardPage)new Page());
    }

    public Map<IWorkspaceConnection, String> getSelection() {
        return this.selection;
    }

    public boolean performFinish() {
        this.updateSelection();
        return true;
    }

    private Map<IWorkspaceConnection, String> updateSelection() {
        this.selection = new HashMap<IWorkspaceConnection, String>();
        TableItem[] tableItemArray = this.pagedTable.getViewer().getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry entry;
            Object key;
            Object data;
            TableItem item = tableItemArray[n2];
            if (item.getChecked() && (data = item.getData()) instanceof Map.Entry && (key = (entry = (Map.Entry)data).getKey()) instanceof IWorkspaceConnection) {
                IWorkspaceConnection connection = (IWorkspaceConnection)key;
                Object value = entry.getValue();
                if (value instanceof String) {
                    String name = (String)value;
                    this.selection.put(connection, name);
                }
            }
            ++n2;
        }
        return this.selection;
    }

    private void updateEnablement() {
        boolean containsWorkspaces = false;
        boolean containsStreams = false;
        if (this.pagedTable != null && !this.pagedTable.getViewer().getTable().isDisposed()) {
            TableItem[] tableItemArray = this.pagedTable.getViewer().getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                Map.Entry entry;
                Object key;
                TableItem item = tableItemArray[n2];
                Object data = item.getData();
                if (data instanceof Map.Entry && (key = (entry = (Map.Entry)data).getKey()) instanceof IWorkspaceConnection) {
                    IWorkspaceConnection connection = (IWorkspaceConnection)key;
                    if (connection.isStream()) {
                        containsStreams = true;
                    } else {
                        containsWorkspaces = true;
                    }
                }
                if (containsWorkspaces && containsStreams) break;
                ++n2;
            }
        }
        if (this.fSelectWorkspacesButton != null && !this.fSelectWorkspacesButton.isDisposed()) {
            this.fSelectWorkspacesButton.setEnabled(containsWorkspaces);
        }
        if (this.fSelectStreamsButton != null && !this.fSelectStreamsButton.isDisposed()) {
            this.fSelectStreamsButton.setEnabled(containsStreams);
        }
    }

    private class Page
    extends WizardPage {
        private MultiRepoConnectionQuery query;
        private Label selectedCount;

        public Page() {
            super(Page.class.getName());
            this.setTitle(Messages.AddConnectionDialog_0);
            this.setDescription(Messages.AddConnectionDialog_2);
        }

        public void createControl(Composite parent) {
            Shell shell = this.getShell();
            if (shell != null) {
                shell.setSize(600, 600);
            }
            Composite composite = new Composite(parent, 0);
            WidgetFactoryContext context = WidgetFactoryContext.forWizardPage((IWizardPage)this);
            SashForm sash = new SashForm(composite, 512);
            Composite viewerComposite = new Composite((Composite)sash, 0);
            AddConnectionDialog.this.pagedTable = new PagedTable(viewerComposite, context, 68384, null, null);
            Table table = AddConnectionDialog.this.pagedTable.getViewer().getTable();
            BaseLabelProvider c1provider = new BaseLabelProvider(){

                public void updateLabel(ViewerLabel label, Object element) {
                    if (element instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)element;
                        IWorkspaceConnection connection = (IWorkspaceConnection)entry.getKey();
                        label.setText(connection.getName());
                        if (connection.isStream()) {
                            label.setImage(this.getResources().createImage(ImagePool.STREAM));
                        } else {
                            label.setImage(this.getResources().createImage(ImagePool.WORKSPACE));
                        }
                    }
                }
            };
            BaseLabelProvider c2provider = new BaseLabelProvider(){

                public void updateLabel(ViewerLabel label, Object element) {
                    Map.Entry entry;
                    if (element instanceof Map.Entry && (entry = (Map.Entry)element).getValue() instanceof String) {
                        String owner = (String)entry.getValue();
                        if (owner != null) {
                            label.setText(owner);
                        } else {
                            label.setText("");
                        }
                    }
                }
            };
            LabelColumn c1 = new LabelColumn(AddConnectionDialog.this.pagedTable.getViewer(), Messages.AddConnectionDialog_6, 150);
            c1.setLabelProvider((IViewerLabelProvider)c1provider);
            LabelColumn c2 = new LabelColumn(AddConnectionDialog.this.pagedTable.getViewer(), Messages.AddConnectionDialog_7, 150);
            c2.setLabelProvider((IViewerLabelProvider)c2provider);
            table.setHeaderVisible(true);
            TableOrTreeResizer.addResizeListener(table);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(AddConnectionDialog.this.pagedTable.getControl());
            Composite descriptionComposite = new Composite((Composite)sash, 0);
            sash.setWeights(new int[]{3, 7});
            final Button streamsFirst = context.getToolkit().createButton(descriptionComposite, Messages.AddConnectionDialog_3, 32);
            streamsFirst.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Page.this.query.setQueryStreamsFirst(streamsFirst.getSelection());
                }
            });
            context.getToolkit().createLabel(descriptionComposite, Messages.AddConnectionDialog_1);
            final Text description = context.getToolkit().createText(descriptionComposite, "", 586);
            this.selectedCount = context.getToolkit().createLabel(descriptionComposite, "");
            AddConnectionDialog.this.pagedTable.getViewer().getTable().addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Object data = e.item.getData();
                    if (data instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)data;
                        String descriptionText = ((IWorkspaceConnection)entry.getKey()).getDescription();
                        if (descriptionText != null) {
                            description.setText(descriptionText);
                        } else {
                            description.setText("");
                        }
                    }
                    if (e.detail == 32) {
                        Page.this.updateSelectionCount();
                    }
                }
            });
            AddConnectionDialog.this.pagedTable.getViewer().setProgressService(new IBusyHandler(){

                public void setBusy(boolean isBusy) {
                    AddConnectionDialog.this.updateEnablement();
                }
            });
            this.query = new MultiRepoConnectionQuery(AddConnectionDialog.this.handles, AddConnectionDialog.this.repo, AddConnectionDialog.this.runner);
            this.updateSelectionCount();
            if (AddConnectionDialog.this.streamsFirstDefault) {
                this.query.setQueryStreamsFirst(AddConnectionDialog.this.streamsFirstDefault);
                streamsFirst.setSelection(true);
            }
            this.query.addListener((ISetListener)new ISetListener<Map.Entry<IWorkspaceConnection, String>>(){

                public void changed(SetDiff<Map.Entry<IWorkspaceConnection, String>> diff) {
                    AddConnectionDialog.this.updateEnablement();
                    if (!streamsFirst.isDisposed()) {
                        streamsFirst.setEnabled(Page.this.query.numStreams() < 0);
                        Page.this.updateSelectionCount();
                    }
                }
            });
            AddConnectionDialog.this.pagedTable.setInput((ISetWithListeners)this.query);
            Composite buttonsComposite = new Composite(composite, 0);
            AddConnectionDialog.this.fSelectWorkspacesButton = new Button(buttonsComposite, 8);
            AddConnectionDialog.this.fSelectWorkspacesButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Page.this.setWorkspacesChecked(AddConnectionDialog.this.pagedTable.getViewer().getTable().getItems(), false);
                    Page.this.updateSelectionCount();
                }
            });
            AddConnectionDialog.this.fSelectWorkspacesButton.setText(Messages.AddConnectionDialog_12);
            AddConnectionDialog.this.fSelectStreamsButton = new Button(buttonsComposite, 8);
            AddConnectionDialog.this.fSelectStreamsButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Page.this.setWorkspacesChecked(AddConnectionDialog.this.pagedTable.getViewer().getTable().getItems(), true);
                    Page.this.updateSelectionCount();
                }
            });
            AddConnectionDialog.this.fSelectStreamsButton.setText(Messages.AddConnectionDialog_13);
            Button selectAll = new Button(buttonsComposite, 8);
            selectAll.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Page.this.setChecked(AddConnectionDialog.this.pagedTable.getViewer().getTable().getItems(), true);
                    Page.this.updateSelectionCount();
                }
            });
            selectAll.setText(Messages.AddConnectionDialog_14);
            Button selectNone = new Button(buttonsComposite, 8);
            selectNone.setText(Messages.AddConnectionDialog_15);
            selectNone.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Page.this.setChecked(AddConnectionDialog.this.pagedTable.getViewer().getTable().getItems(), false);
                    Page.this.updateSelectionCount();
                }
            });
            Dialog.applyDialogFont((Control)composite);
            GridDataFactory.defaultsFor((Control)descriptionComposite).grab(true, true).applyTo((Control)descriptionComposite);
            GridDataFactory.defaultsFor((Control)viewerComposite).span(2, 1).grab(true, true).applyTo((Control)sash);
            GridDataFactory.defaultsFor((Control)table).grab(true, true).applyTo((Control)table);
            GridDataFactory.defaultsFor((Control)description).grab(true, true).applyTo((Control)description);
            GridDataFactory.defaultsFor((Control)sash).grab(true, true).applyTo((Control)sash);
            GridLayoutFactory.fillDefaults().generateLayout(descriptionComposite);
            GridLayoutFactory.fillDefaults().generateLayout(viewerComposite);
            GridLayoutFactory.fillDefaults().generateLayout(buttonsComposite);
            GridLayoutFactory.fillDefaults().extendedMargins(LayoutConstants2.getWizardPageMargins()).numColumns(2).generateLayout(composite);
            this.setControl((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpId());
            AddConnectionDialog.this.updateEnablement();
        }

        private void setWorkspacesChecked(TableItem[] items, boolean isStream) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkspaceConnection connection;
                Map.Entry entry;
                Object key;
                TableItem item = tableItemArray[n2];
                Object data = item.getData();
                if (data instanceof Map.Entry && (key = (entry = (Map.Entry)data).getKey()) instanceof IWorkspaceConnection && isStream == (connection = (IWorkspaceConnection)key).isStream()) {
                    item.setChecked(true);
                }
                ++n2;
            }
        }

        private void setChecked(TableItem[] items, boolean checked) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(checked);
                ++n2;
            }
        }

        private void updateSelectionCount() {
            int streamsSelected = 0;
            Set connections = AddConnectionDialog.this.updateSelection().keySet();
            for (IWorkspaceConnection connection : connections) {
                if (!connection.isStream()) continue;
                ++streamsSelected;
            }
            int workspacesSelected = connections.size() - streamsSelected;
            String numStreams = null;
            String numWorkspaces = null;
            int qNumStrings = this.query.numStreams();
            if (qNumStrings < 0) {
                numStreams = Messages.AddConnectionDialog_8;
                numWorkspaces = Messages.AddConnectionDialog_8;
            } else {
                numStreams = Integer.toString(qNumStrings);
                numWorkspaces = Integer.toString(AddConnectionDialog.this.handles.size() - qNumStrings);
            }
            this.selectedCount.setText(NLS.bind((String)Messages.AddConnectionDialog_9, (Object[])new Object[]{workspacesSelected, numWorkspaces, streamsSelected, numStreams}));
        }

        private String getHelpId() {
            return "com.ibm.team.filesystem.ide.ui.wizard_flowbrowser_addrepositoryworkspacesandstreams";
        }

        public void performHelp() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.getHelpId());
        }
    }
}

