/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowTable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.gef.commands.Command;

public abstract class SetFlowTargetCommand
extends Command {
    private FlowNode flowNode;
    private FlowNode target;
    private FlowNode undo;

    public SetFlowTargetCommand(FlowNode flowNode, FlowNode target) {
        this.flowNode = flowNode;
        this.target = target;
    }

    public void setTarget(FlowNode target) {
        this.target = target;
    }

    protected FlowVisDiagram getDiagram() {
        return this.flowNode.getDiagram();
    }

    public void execute() {
        this.undo = this.getUndoValue();
        this.setFlowTarget(this.target, true);
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.setFlowTarget(this.undo, false);
    }

    private void setFlowTarget(final FlowNode newFlow, final boolean redo) {
        this.getDiagram().getUtil().getCommandStack().flush();
        this.getDiagram().getUtil().getOperationRunner().enqueue(this.getTaskName(redo), (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)SetFlowTargetCommand.this.getTaskName(redo), (int)4);
                IWorkspaceConnection connection = SetFlowTargetCommand.this.flowNode.getWorkspaceConnection((IProgressMonitor)sub.newChild(1));
                IWorkspaceConnection target = SetFlowTargetCommand.getWorkspaceConnectionOrNull(newFlow, (IProgressMonitor)sub.newChild(1));
                IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
                if (redo) {
                    SetFlowTargetCommand.this.redoFlowTarget(flowTable, connection, target, (IProgressMonitor)sub.newChild(1));
                } else {
                    SetFlowTargetCommand.this.undoFlowTarget(flowTable, connection, target, (IProgressMonitor)sub.newChild(1));
                }
                connection.setFlowTable(flowTable, (IProgressMonitor)sub.newChild(1));
                SetFlowTargetCommand.this.setPropertyValue(newFlow, redo);
            }
        });
    }

    protected FlowNode getFlowNode() {
        return this.flowNode;
    }

    protected FlowNode getTarget() {
        return this.target;
    }

    protected abstract void redoFlowTarget(IFlowTable var1, IWorkspaceConnection var2, IWorkspaceConnection var3, IProgressMonitor var4) throws TeamRepositoryException;

    protected void undoFlowTarget(IFlowTable flowTable, IWorkspaceConnection source, IWorkspaceConnection target, IProgressMonitor monitor) throws TeamRepositoryException {
        this.redoFlowTarget(flowTable, source, target, monitor);
    }

    protected abstract FlowNode getUndoValue();

    protected abstract String getTaskName(boolean var1);

    protected abstract void setPropertyValue(FlowNode var1, boolean var2);

    protected static IWorkspaceConnection getWorkspaceConnectionOrNull(FlowNode flowNode, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        if (flowNode != null) {
            return flowNode.getWorkspaceConnection(monitor);
        }
        return null;
    }
}

