/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.gef.commands.Command;

public class SetDefaultTargetCommand
extends Command {
    private final FlowNode fFlowNode;
    private final FlowNode fNewDefaultFlowTarget;
    private final FlowNode fOriginalIncomingDefaultTarget;
    private final FlowNode fOriginalOutgoingDefaultTarget;

    public SetDefaultTargetCommand(FlowNode flowNode, FlowNode newDefaultFlowTarget) {
        this.fFlowNode = flowNode;
        this.fNewDefaultFlowTarget = newDefaultFlowTarget;
        this.fOriginalIncomingDefaultTarget = flowNode.getDefaultIncomingFlow();
        this.fOriginalOutgoingDefaultTarget = flowNode.getDefaultOutgoingFlow();
        this.setLabel(Messages.SetDefaultTargetCommand_0);
    }

    public void execute() {
        this.setDefaultFlowTarget();
    }

    public void redo() {
        this.execute();
    }

    private void setDefaultFlowTarget() {
        this.fFlowNode.getDiagram().getUtil().getOperationRunner().enqueue(Messages.SetDefaultTargetCommand_1, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                IWorkspaceConnection connection = SetDefaultTargetCommand.this.fFlowNode.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                IWorkspaceConnection target = SetDefaultTargetCommand.this.getWorkspaceConnectionOrNull(SetDefaultTargetCommand.this.fNewDefaultFlowTarget, (IProgressMonitor)progress.newChild(1));
                IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
                IWorkspace workspace = target == null ? null : target.getResolvedWorkspace();
                FlowTableUtil.setDefaultCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)workspace);
                connection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(1));
                SetDefaultTargetCommand.this.setPropertyValue(SetDefaultTargetCommand.this.fNewDefaultFlowTarget, SetDefaultTargetCommand.this.fNewDefaultFlowTarget);
            }
        });
    }

    public void undo() {
        this.fFlowNode.getDiagram().getUtil().getOperationRunner().enqueue(Messages.SetDefaultTargetCommand_1, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
                IWorkspaceConnection connection = SetDefaultTargetCommand.this.fFlowNode.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
                IWorkspaceConnection incomingConnection = SetDefaultTargetCommand.this.getWorkspaceConnectionOrNull(SetDefaultTargetCommand.this.fOriginalIncomingDefaultTarget, (IProgressMonitor)progress.newChild(1));
                IWorkspace incomingWorkspace = incomingConnection == null ? null : incomingConnection.getResolvedWorkspace();
                FlowTableUtil.setDefaultIncomingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)incomingWorkspace);
                IWorkspaceConnection outgoingConnection = SetDefaultTargetCommand.this.getWorkspaceConnectionOrNull(SetDefaultTargetCommand.this.fOriginalOutgoingDefaultTarget, (IProgressMonitor)progress.newChild(1));
                IWorkspace outgoingWorkspace = outgoingConnection == null ? null : outgoingConnection.getResolvedWorkspace();
                FlowTableUtil.setDefaultOutgoingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)outgoingWorkspace);
                connection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(1));
                SetDefaultTargetCommand.this.setPropertyValue(SetDefaultTargetCommand.this.fOriginalIncomingDefaultTarget, SetDefaultTargetCommand.this.fOriginalOutgoingDefaultTarget);
            }
        });
    }

    private IWorkspaceConnection getWorkspaceConnectionOrNull(FlowNode flowNode, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        if (flowNode != null) {
            return flowNode.getWorkspaceConnection(monitor);
        }
        return null;
    }

    private void setPropertyValue(FlowNode newDefaultIncomingTarget, FlowNode newDefaultOutgoingTarget) {
        boolean defaultIncomingUpdated = true;
        boolean defaultOutgoingUpdated = true;
        IWorkspaceConnection wc = this.fFlowNode.getWorkspaceConnection();
        if (wc != null) {
            IFlowEntry defaultDeliverFlow;
            IFlowTable flowTable = wc.getFlowTable();
            IFlowEntry defaultAcceptFlow = flowTable.getDefaultAcceptFlow();
            if (defaultAcceptFlow == null && newDefaultIncomingTarget == null || defaultAcceptFlow != null && !defaultAcceptFlow.getFlowNode().getItemId().equals((Object)newDefaultIncomingTarget.getUUID())) {
                defaultIncomingUpdated = false;
            }
            if ((defaultDeliverFlow = flowTable.getDefaultDeliverFlow()) == null && newDefaultOutgoingTarget == null || defaultDeliverFlow != null && !defaultDeliverFlow.getFlowNode().getItemId().equals((Object)newDefaultOutgoingTarget.getUUID())) {
                defaultOutgoingUpdated = false;
            }
        }
        if (defaultIncomingUpdated) {
            this.fFlowNode.setPropertyValue((Object)FlowNode.PropertyId.DEFAULT_INCOMING_FLOW, newDefaultIncomingTarget);
            this.fFlowNode.setPropertyValue((Object)FlowNode.PropertyId.DEFAULT_INCOMING_FLOW_DATE, new Date());
        }
        if (defaultOutgoingUpdated) {
            this.fFlowNode.setPropertyValue((Object)FlowNode.PropertyId.DEFAULT_OUTGOING_FLOW, newDefaultOutgoingTarget);
            this.fFlowNode.setPropertyValue((Object)FlowNode.PropertyId.DEFAULT_OUTGOING_FLOW_DATE, new Date());
        }
    }
}

