/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.gef.commands.Command;

public class SetCurrentTargetCommand
extends Command {
    private final FlowNode fFlowNode;
    private final FlowNode fNewCurrentFlowTarget;
    private final FlowNode fOriginalIncomingCurrentTarget;
    private final FlowNode fOriginalOutgoingCurrentTarget;

    public SetCurrentTargetCommand(FlowNode flowNode, FlowNode newCurrentFlowTarget) {
        this.fFlowNode = flowNode;
        this.fNewCurrentFlowTarget = newCurrentFlowTarget;
        this.fOriginalIncomingCurrentTarget = flowNode.getCurrentIncomingFlow();
        this.fOriginalOutgoingCurrentTarget = flowNode.getCurrentOutgoingFlow();
        this.setLabel(Messages.SetCurrentTargetCommand_0);
    }

    public void execute() {
        this.setCurrentFlowTarget();
    }

    public void redo() {
        this.execute();
    }

    private void setCurrentFlowTarget() {
        this.fFlowNode.getDiagram().getUtil().getOperationRunner().enqueue(Messages.SetCurrentTargetCommand_1, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                IWorkspaceConnection connection = SetCurrentTargetCommand.this.fFlowNode.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                IWorkspaceConnection targetConnection = SetCurrentTargetCommand.this.getWorkspaceConnectionOrNull(SetCurrentTargetCommand.this.fNewCurrentFlowTarget, (IProgressMonitor)progress.newChild(1));
                IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
                IWorkspace workspace = targetConnection == null ? null : targetConnection.getResolvedWorkspace();
                FlowTableUtil.setCurrentCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)workspace);
                if (targetConnection != null) {
                    FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), targetConnection, false, (IProgressMonitor)progress.newChild(1));
                }
                progress.setWorkRemaining(1);
                connection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(1));
                SetCurrentTargetCommand.this.setPropertyValue(SetCurrentTargetCommand.this.fNewCurrentFlowTarget, SetCurrentTargetCommand.this.fNewCurrentFlowTarget);
            }
        });
    }

    public void undo() {
        this.fFlowNode.getDiagram().getUtil().getOperationRunner().enqueue(Messages.SetCurrentTargetCommand_1, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
                IWorkspaceConnection connection = SetCurrentTargetCommand.this.fFlowNode.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                IFlowTable flowTable = connection.getFlowTable().getWorkingCopy();
                IWorkspaceConnection incomingConnection = SetCurrentTargetCommand.this.getWorkspaceConnectionOrNull(SetCurrentTargetCommand.this.fOriginalIncomingCurrentTarget, (IProgressMonitor)progress.newChild(1));
                IWorkspace incomingWorkspace = incomingConnection == null ? null : incomingConnection.getResolvedWorkspace();
                FlowTableUtil.setCurrentIncomingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)incomingWorkspace);
                if (incomingConnection != null) {
                    FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceIncomingCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), incomingConnection, false, (IProgressMonitor)progress.newChild(1));
                }
                progress.setWorkRemaining(3);
                IWorkspaceConnection outgoingConnection = SetCurrentTargetCommand.this.getWorkspaceConnectionOrNull(SetCurrentTargetCommand.this.fOriginalOutgoingCurrentTarget, (IProgressMonitor)progress.newChild(1));
                IWorkspace outgoingWorkspace = outgoingConnection == null ? null : outgoingConnection.getResolvedWorkspace();
                FlowTableUtil.setCurrentOutgoingCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)outgoingWorkspace);
                if (outgoingConnection != null) {
                    FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceOutgoingCollaboration((IWorkspaceHandle)connection.getResolvedWorkspace(), outgoingConnection, false, (IProgressMonitor)progress.newChild(1));
                }
                progress.setWorkRemaining(1);
                connection.setFlowTable(flowTable, (IProgressMonitor)progress.newChild(1));
                SetCurrentTargetCommand.this.setPropertyValue(SetCurrentTargetCommand.this.fOriginalIncomingCurrentTarget, SetCurrentTargetCommand.this.fOriginalOutgoingCurrentTarget);
            }
        });
    }

    private IWorkspaceConnection getWorkspaceConnectionOrNull(FlowNode flowNode, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        if (flowNode != null) {
            return flowNode.getWorkspaceConnection(monitor);
        }
        return null;
    }

    private void setPropertyValue(FlowNode newCurrentIncomingTarget, FlowNode newCurrentOutgoingTarget) {
        boolean currentIncomingUpdated = true;
        boolean currentOutgoingUpdated = true;
        IWorkspaceConnection wc = this.fFlowNode.getWorkspaceConnection();
        if (wc != null) {
            IFlowEntry currentDeliverFlow;
            IFlowTable flowTable = wc.getFlowTable();
            IFlowEntry currentAcceptFlow = flowTable.getCurrentAcceptFlow();
            if (currentAcceptFlow == null && newCurrentIncomingTarget == null || currentAcceptFlow != null && !currentAcceptFlow.getFlowNode().getItemId().equals((Object)newCurrentIncomingTarget.getUUID())) {
                currentIncomingUpdated = false;
            }
            if ((currentDeliverFlow = flowTable.getCurrentDeliverFlow()) == null && newCurrentOutgoingTarget == null || currentDeliverFlow != null && !currentDeliverFlow.getFlowNode().getItemId().equals((Object)newCurrentOutgoingTarget.getUUID())) {
                currentOutgoingUpdated = false;
            }
        }
        if (currentIncomingUpdated) {
            this.fFlowNode.setPropertyValue((Object)FlowNode.PropertyId.CURRENT_INCOMING_FLOW, newCurrentIncomingTarget);
            this.fFlowNode.setPropertyValue((Object)FlowNode.PropertyId.CURRENT_INCOMING_FLOW_DATE, new Date());
        }
        if (currentOutgoingUpdated) {
            this.fFlowNode.setPropertyValue((Object)FlowNode.PropertyId.CURRENT_OUTGOING_FLOW, newCurrentOutgoingTarget);
            this.fFlowNode.setPropertyValue((Object)FlowNode.PropertyId.CURRENT_OUTGOING_FLOW_DATE, new Date());
        }
    }
}

