/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowVisCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisConnection;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Note;
import java.util.HashSet;
import java.util.List;

public class RemoveNotesCommand
extends FlowVisCommand {
    private List<Note> notes;
    private List<FlowVisConnection> connections;
    private FlowVisDiagram diagram;

    public RemoveNotesCommand(List<Note> notes, List<FlowVisConnection> connections, FlowVisDiagram diagram) {
        this.notes = notes;
        this.connections = connections;
        this.diagram = diagram;
        this.setLabel(Messages.RemoveNotesCommand_0);
    }

    @Override
    protected void createAndExecute() {
        this.add(new UpdateArg(this.diagram, (Object)FlowVisDiagram.PropertyId.NOTES, RemoveNotesCommand.addRemove(this.notes, null), RemoveNotesCommand.addRemove(null, this.notes)));
        HashSet<FlowVisConnection> alreadyRemoved = new HashSet<FlowVisConnection>();
        for (Note note : this.notes) {
            List<FlowVisConnection> outgoingConnections = note.getOutgoingFlowVisConnections();
            this.add(new UpdateArg(note, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, RemoveNotesCommand.addRemove(outgoingConnections, null), RemoveNotesCommand.addRemove(null, outgoingConnections)));
            for (FlowVisConnection connection : outgoingConnections) {
                this.add(new UpdateArg((FlowVisModel)connection.getTarget(), (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, RemoveNotesCommand.addRemove(connection, null), RemoveNotesCommand.addRemove(null, connection)));
                alreadyRemoved.add(connection);
            }
            List<FlowVisConnection> incomingConnections = note.getIncomingFlowVisConnections();
            this.add(new UpdateArg(note, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, RemoveNotesCommand.addRemove(incomingConnections, null), RemoveNotesCommand.addRemove(null, incomingConnections)));
            for (FlowVisConnection connection : incomingConnections) {
                this.add(new UpdateArg((FlowVisModel)connection.getSource(), (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, RemoveNotesCommand.addRemove(connection, null), RemoveNotesCommand.addRemove(null, connection)));
                alreadyRemoved.add(connection);
            }
        }
        for (FlowVisConnection connection : this.connections) {
            if (alreadyRemoved.contains(connection)) continue;
            this.add(new UpdateArg((FlowVisModel)connection.getTarget(), (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, RemoveNotesCommand.addRemove(connection, null), RemoveNotesCommand.addRemove(null, connection)));
            this.add(new UpdateArg((FlowVisModel)connection.getSource(), (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, RemoveNotesCommand.addRemove(connection, null), RemoveNotesCommand.addRemove(null, connection)));
        }
        this.execute();
    }
}

