/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowVisCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisConnection;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.List;

public class RemoveFlowNodesCommand
extends FlowVisCommand {
    private FlowVisDiagram diagram;
    private Collection<FlowNode> flowNodes;

    @Override
    protected void createAndExecute() {
        this.add(new UpdateArg(this.diagram, (Object)FlowVisDiagram.PropertyId.FLOW_NODES, FlowVisCommand.addRemove(this.flowNodes, null), FlowVisCommand.addRemove(null, this.flowNodes)));
        for (FlowNode flowNode : this.flowNodes) {
            List<FlowVisConnection> outgoing = flowNode.getOutgoingFlowVisConnections();
            Collection[] undo = FlowVisCommand.addRemove(outgoing, null);
            Collection[] redo = FlowVisCommand.addRemove(null, outgoing);
            this.add(new UpdateArg(flowNode, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, undo, redo));
            for (FlowVisConnection connection : outgoing) {
                Object target = connection.getTarget();
                this.add(new UpdateArg((FlowVisModel)target, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, FlowVisCommand.addRemove(connection, null), FlowVisCommand.addRemove(null, connection)));
                if (!(target instanceof FlowNode)) continue;
                FlowNode targetFlowNode = (FlowNode)target;
                try {
                    if (flowNode.getTeamRepository().equals(this.diagram.getUtil().getRepository())) continue;
                    int incomingCount = targetFlowNode.getRemoteIncomingCount();
                    this.add(new UpdateArg(targetFlowNode, (Object)FlowNode.PropertyId.REMOTE_INCOMING_COUNT, incomingCount, incomingCount - 1));
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    // empty catch block
                }
            }
            List<FlowVisConnection> incoming = flowNode.getIncomingFlowVisConnections();
            undo = FlowVisCommand.addRemove(incoming, null);
            redo = FlowVisCommand.addRemove(null, incoming);
            this.add(new UpdateArg(flowNode, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, undo, redo));
            for (FlowVisConnection connection : incoming) {
                this.add(new UpdateArg((FlowVisModel)connection.getSource(), (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, FlowVisCommand.addRemove(connection, null), FlowVisCommand.addRemove(null, connection)));
            }
        }
        this.execute();
    }

    public RemoveFlowNodesCommand(FlowVisDiagram diagram, Collection<FlowNode> toRemove) {
        this.diagram = diagram;
        this.flowNodes = toRemove;
    }
}

