/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.filesystem.rcp.ui.internal.util.StatusDialog;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.ExpandComponentsCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowNodesCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowVisCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class RefreshFlowNodesCommand
extends FlowNodesCommand {
    private List<FlowNode> flowNodes;
    private Map<FlowNode, IStatus> noConnections;

    public RefreshFlowNodesCommand(List<FlowNode> flowNodes) {
        this.flowNodes = flowNodes;
        this.noConnections = new HashMap<FlowNode, IStatus>();
        this.setLabel(Messages.RefreshFlowNodesCommand_0);
    }

    @Override
    protected List<? extends IFlowEntry> getHandles(IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        HashMap<ITeamRepository, ArrayList<IWorkspace>> toFetch = new HashMap<ITeamRepository, ArrayList<IWorkspace>>();
        HashMap<UUID, FlowNode> flowNodesMap = new HashMap<UUID, FlowNode>();
        for (FlowNode flowNode : this.flowNodes) {
            IWorkspaceConnection connection = flowNode.getWorkspaceConnection();
            Object handle = null;
            flowNodesMap.put(flowNode.getUUID(), flowNode);
            handle = connection == null ? (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(flowNode.getUUID(), null) : connection.getResolvedWorkspace();
            ArrayList<IWorkspace> handlesToFetch = (ArrayList<IWorkspace>)toFetch.get(flowNode.getTeamRepository());
            if (handlesToFetch == null) {
                handlesToFetch = new ArrayList<IWorkspace>();
                toFetch.put(flowNode.getTeamRepository(), handlesToFetch);
            }
            handlesToFetch.add((IWorkspace)handle);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)toFetch.size());
        ArrayList<IFlowEntry> entries = new ArrayList<IFlowEntry>();
        if (toFetch.size() > 0) {
            for (ITeamRepository repo : toFetch.keySet()) {
                ArrayList<IWorkspace> workspaces = new ArrayList<IWorkspace>();
                List fetched = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnections((List)toFetch.get(repo), (IProgressMonitor)sub.newChild(toFetch.size()));
                int i = 0;
                while (i < fetched.size()) {
                    IWorkspaceConnection connection = (IWorkspaceConnection)fetched.get(i);
                    if (connection != null) {
                        IWorkspace workspace = connection.getResolvedWorkspace();
                        workspaces.add(workspace);
                        FlowNode flowNode = (FlowNode)flowNodesMap.get(workspace.getItemId());
                        if (flowNode != null) {
                            flowNode.setWorkspaceConnection(connection);
                        }
                    }
                    ++i;
                }
                entries.addAll(this.getFlowEntries(repo, workspaces));
            }
        }
        return entries;
    }

    @Override
    protected String getTaskName() {
        return Messages.RefreshFlowNodesCommand_1;
    }

    @Override
    protected Map<IWorkspaceConnection, String> filterAndGetNames(Collection<? extends IFlowEntry> flowNodes, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(flowNodes.size() + 1));
        ArrayList<IWorkspaceConnection> connections = new ArrayList<IWorkspaceConnection>(flowNodes.size());
        for (IFlowEntry iFlowEntry : flowNodes) {
            FlowNode flowNode = this.getDiagram().getFlowNode(iFlowEntry.getFlowNode().getItemId());
            if (flowNode == null) continue;
            try {
                IWorkspaceConnection connection = flowNode.getWorkspaceConnection((IProgressMonitor)sub.newChild(1));
                connections.add(connection);
            }
            catch (ItemNotFoundException e) {
                this.handleException(flowNode, e);
            }
        }
        return RefreshFlowNodesCommand.getOwnerNames(connections, (IProgressMonitor)sub.newChild(1));
    }

    private void handleException(FlowNode flowNode, ItemNotFoundException e) {
        IStatus status = StatusUtil.newStatus((Object)((Object)this), (int)1, (String)NLS.bind((String)Messages.RefreshFlowNodesCommand_6, (Object)flowNode.getName(), (Object)flowNode.getOwner()), (Throwable)e);
        this.noConnections.put(flowNode, status);
    }

    @Override
    protected FlowNode getFlowNode(IWorkspaceConnection connection) {
        FlowNode flowNode = this.getDiagram().getFlowNode(connection.getResolvedWorkspace().getItemId());
        if (flowNode != null) {
            return flowNode;
        }
        return new FlowNode(this.getDiagram(), connection);
    }

    @Override
    protected void addRemoveFlowNodes(Map<UUID, FlowNode> flowNodes) {
        if (this.noConnections.size() > 0) {
            final int[] ok = new int[1];
            this.getUtil().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 1, RefreshFlowNodesCommand.this.noConnections.values().toArray(new IStatus[RefreshFlowNodesCommand.this.noConnections.size()]), NLS.bind((String)Messages.RefreshFlowNodesCommand_4, (Object)RefreshFlowNodesCommand.this.noConnections.size()), null);
                    StatusDialog dialog = new StatusDialog(RefreshFlowNodesCommand.this.getUtil().getShell(), Messages.RefreshFlowNodesCommand_5, null, null, (IStatus)multiStatus, 7);
                    ok[0] = dialog.open();
                }
            });
            Set<FlowNode> removeFlowNodes = this.noConnections.keySet();
            if (ok[0] == 0) {
                this.add(new UpdateArg(this.getDiagram(), (Object)FlowVisDiagram.PropertyId.FLOW_NODES, FlowVisCommand.addRemove(removeFlowNodes, null), FlowVisCommand.addRemove(null, removeFlowNodes)));
            }
            HashMap<FlowNode, ArrayList<Collaboration>> removing = new HashMap<FlowNode, ArrayList<Collaboration>>();
            for (FlowNode flowNode : removeFlowNodes) {
                List<Collaboration> collaborations = flowNode.getFlowTargetCollaborations();
                for (Collaboration collaboration : collaborations) {
                    FlowNode target = (FlowNode)collaboration.getTarget();
                    ArrayList<Collaboration> toRemove = (ArrayList<Collaboration>)removing.get(target);
                    if (toRemove == null) {
                        toRemove = new ArrayList<Collaboration>();
                        removing.put(target, toRemove);
                    }
                    toRemove.add(collaboration);
                }
                this.add(new UpdateArg(flowNode, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, RefreshFlowNodesCommand.addRemove(collaborations, null), RefreshFlowNodesCommand.addRemove(null, collaborations)));
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.FLOW_TARGETS_COUNT, 0));
                List<Collaboration> remoteIncomingCollaborations = flowNode.getRemoteIncomingCollaborations();
                for (Collaboration collaboration : remoteIncomingCollaborations) {
                    FlowNode source = (FlowNode)collaboration.getSource();
                    this.add(new UpdateArg(source, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, RefreshFlowNodesCommand.addRemove(collaboration, null), RefreshFlowNodesCommand.addRemove(null, collaboration)));
                }
                this.add(new UpdateArg(flowNode, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, RefreshFlowNodesCommand.addRemove(remoteIncomingCollaborations, null), RefreshFlowNodesCommand.addRemove(null, remoteIncomingCollaborations)));
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.REMOTE_INCOMING_COUNT, 0));
            }
            for (Map.Entry entry : removing.entrySet()) {
                FlowNode target = (FlowNode)entry.getKey();
                List toRemove = (List)entry.getValue();
                this.add(new UpdateArg(target, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, RefreshFlowNodesCommand.addRemove(toRemove, null), RefreshFlowNodesCommand.addRemove(null, toRemove)));
                this.add(new UpdateArg(target, (Object)FlowNode.PropertyId.REMOTE_INCOMING_COUNT, target.getRemoteIncomingCount() - toRemove.size()));
            }
        }
    }

    @Override
    protected void createUpdateArgs(FlowNode flowNode, IProgressMonitor monitor) throws TeamRepositoryException {
        if (flowNode.isComponentsExpanded()) {
            try {
                List<UpdateArg> updates = ExpandComponentsCommand.getComponents(flowNode, monitor);
                for (UpdateArg updateArg : updates) {
                    this.add(updateArg);
                }
            }
            catch (ItemNotFoundException e) {
                this.handleException(flowNode, e);
            }
        } else {
            flowNode.setComponentsLoaded(false);
            this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.COMPONENT_COUNT, flowNode.computeComponentCount(monitor)));
        }
    }
}

