/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisLayout;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowVisDiagramEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class LayoutCommand
extends Command {
    private FlowVisDiagramEditPart flowVisDiagramEditPart;
    private Map<FlowNode, Rectangle> constraints;

    public LayoutCommand(FlowVisDiagramEditPart flowVisDiagramEditPart) {
        this.flowVisDiagramEditPart = flowVisDiagramEditPart;
        this.constraints = new HashMap<FlowNode, Rectangle>();
        this.setLabel(Messages.LayoutCommand_0);
    }

    public void execute() {
        this.constraints.clear();
        for (FlowNode flowNode : ((FlowVisDiagram)this.flowVisDiagramEditPart.getModel2()).getFlowNodes()) {
            this.constraints.put(flowNode, flowNode.getConstraint());
        }
        Animation.markBegin();
        FlowVisLayout.layout(this.flowVisDiagramEditPart);
        Animation.run((int)((FlowVisDiagram)this.flowVisDiagramEditPart.getModel2()).getAnimationSpeed());
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        for (Map.Entry<FlowNode, Rectangle> entry : this.constraints.entrySet()) {
            entry.getKey().setPropertyValue((Object)FlowNode.PropertyId.CONSTRAINT, entry.getValue());
        }
    }
}

