/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.commands.Command;

public abstract class FlowVisCommand
extends Command {
    private List<UpdateArg> updateArgs;

    protected abstract void createAndExecute();

    public void execute() {
        if (this.updateArgs == null) {
            this.createAndExecute();
        } else {
            for (UpdateArg updateArg : this.updateArgs) {
                FlowVisCommand.redo(updateArg);
            }
        }
    }

    public void add(UpdateArg updateArg) {
        if (this.updateArgs == null) {
            this.updateArgs = new ArrayList<UpdateArg>();
        }
        this.updateArgs.add(updateArg);
    }

    public void redo() {
        this.execute();
    }

    private static void redo(UpdateArg updateArg) {
        FlowVisModel observable = updateArg.getObservable();
        Object propertyId = updateArg.getPropertyId();
        Object newValue = updateArg.getNewValue();
        observable.setPropertyValue(propertyId, newValue);
    }

    public void undo() {
        if (this.updateArgs != null) {
            int i = this.updateArgs.size() - 1;
            while (i >= 0) {
                FlowVisCommand.undo(this.updateArgs.get(i));
                --i;
            }
        }
    }

    private static void undo(UpdateArg updateArg) {
        FlowVisModel observable = updateArg.getObservable();
        Object propertyId = updateArg.getPropertyId();
        Object oldValue = updateArg.getOldValue();
        observable.setPropertyValue(propertyId, oldValue);
    }

    public static Collection[] addRemove(Object toAdd, Object toRemove) {
        Collection<Object> toAddC = null;
        toAddC = toAdd == null ? Collections.EMPTY_LIST : (toAdd instanceof Collection ? (Collection)toAdd : Collections.singleton(toAdd));
        Collection<Object> toRemoveC = null;
        toRemoveC = toRemove == null ? Collections.EMPTY_LIST : (toRemove instanceof Collection ? (Collection)toRemove : Collections.singleton(toRemove));
        return new Collection[]{toAddC, toRemoveC};
    }
}

