/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowVisCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs.MultiRepoConnectionQuery;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.FlowEntry;
import com.ibm.team.scm.common.internal.RemoteDescriptor;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class FlowNodesCommand
extends FlowVisCommand {
    private FlowVisDiagram diagram;

    protected abstract List<? extends IFlowEntry> getHandles(IProgressMonitor var1) throws TeamRepositoryException, OperationFailedException;

    protected abstract String getTaskName();

    public void setDiagram(FlowVisDiagram diagram) {
        this.diagram = diagram;
    }

    protected FlowVisDiagram getDiagram() {
        return this.diagram;
    }

    @Override
    protected void createAndExecute() {
        IOperationRunner runner = this.getUtil().getOperationRunner();
        final String taskName = this.getTaskName();
        runner.enqueue(taskName, (Operation)new RepositoryOperation(this.getUtil().getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)taskName, (int)2);
                monitor.setTaskName(taskName);
                boolean ok = FlowNodesCommand.this.createUpdateArg(FlowNodesCommand.this.getHandles((IProgressMonitor)sub.newChild(1)), (IProgressMonitor)sub.newChild(1));
                if (ok) {
                    FlowNodesCommand.this.execute();
                }
            }
        });
    }

    protected FlowVisUtil getUtil() {
        return this.diagram.getUtil();
    }

    protected boolean queryStreamsFirst() {
        return false;
    }

    protected List<IFlowEntry> getFlowEntries(ITeamRepository repo, List<IWorkspace> workspaces) {
        ArrayList<IFlowEntry> flowNodes = new ArrayList<IFlowEntry>();
        for (IWorkspace workspace : workspaces) {
            FlowEntry entry = ScmFactory.eINSTANCE.createFlowEntry();
            entry.setTargetWorkspace((IWorkspaceHandle)workspace);
            RemoteDescriptor desc = ScmFactory.eINSTANCE.createRemoteDescriptor();
            desc.setRepoURI(repo.getRepositoryURI());
            desc.setRepoRoot(repo.getId());
            entry.setRemoteDescriptor(desc);
            flowNodes.add((IFlowEntry)entry);
        }
        return flowNodes;
    }

    protected boolean createUpdateArg(Collection<? extends IFlowEntry> flowNodes, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        Map<IWorkspaceConnection, String> connections = this.filterAndGetNames(flowNodes, (IProgressMonitor)sub.newChild(1));
        if (connections == null) {
            return false;
        }
        Map<UUID, FlowNode> added = this.initConnections(connections, (IProgressMonitor)sub.newChild(1));
        this.addRemoveFlowNodes(added);
        return true;
    }

    protected abstract Map<IWorkspaceConnection, String> filterAndGetNames(Collection<? extends IFlowEntry> var1, IProgressMonitor var2) throws TeamRepositoryException;

    private Map<UUID, FlowNode> initConnections(Map<IWorkspaceConnection, String> connections, IProgressMonitor monitor) throws OperationFailedException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(connections.size() * 4));
        HashMap<UUID, FlowNode> added = new HashMap<UUID, FlowNode>();
        if (connections.size() > 0 && !sub.isCanceled()) {
            HashSet<FlowNode> allRemoteIncoming = new HashSet<FlowNode>();
            for (Map.Entry<IWorkspaceConnection, String> entry : connections.entrySet()) {
                IWorkspaceConnection connection = entry.getKey();
                FlowNode flowNode = this.getFlowNode(connection);
                List<IWorkspace> remoteIncomingCollaborations = FlowNodesCommand.getRemoteIncomingCollaborations(this.diagram.getUtil().getRepository(), (IWorkspaceHandle)connection.getResolvedWorkspace(), (IProgressMonitor)sub.newChild(1));
                Set<FlowNode> remoteIncomingFlowNodes = this.getRemoteIncomingFlowNodesFromDiagram(flowNode, remoteIncomingCollaborations, (IProgressMonitor)sub.newChild(1));
                allRemoteIncoming.addAll(remoteIncomingFlowNodes);
                int remoteIncomingCount = this.getRemoteIncomingCount(remoteIncomingCollaborations, remoteIncomingFlowNodes);
                ArrayList<Collaboration> toRemove = new ArrayList<Collaboration>();
                HashSet<FlowNode> oldRemoteIncomingFlowNodes = new HashSet<FlowNode>();
                for (Collaboration collaboration : flowNode.getRemoteIncomingCollaborations()) {
                    FlowNode source = (FlowNode)collaboration.getSource();
                    oldRemoteIncomingFlowNodes.add(source);
                    if (remoteIncomingFlowNodes.contains(source)) continue;
                    toRemove.add(collaboration);
                    this.add(new UpdateArg(source, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, FlowNodesCommand.addRemove(collaboration, null), FlowNodesCommand.addRemove(null, collaboration)));
                }
                HashSet<Collaboration> toAdd = new HashSet<Collaboration>();
                for (FlowNode source : remoteIncomingFlowNodes) {
                    if (oldRemoteIncomingFlowNodes.contains(source)) continue;
                    Collaboration collaboration = new Collaboration(source, flowNode);
                    this.add(new UpdateArg(source, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, FlowNodesCommand.addRemove(null, collaboration), FlowNodesCommand.addRemove(collaboration, null)));
                    toAdd.add(collaboration);
                }
                if (toAdd.size() > 0 || toRemove.size() > 0) {
                    this.add(new UpdateArg(flowNode, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, FlowNodesCommand.addRemove(toRemove, toAdd), FlowNodesCommand.addRemove(toAdd, toRemove)));
                }
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.COMPONENT_COUNT, flowNode.computeComponentCount((IProgressMonitor)sub.newChild(1))));
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.REMOTE_INCOMING_COUNT, remoteIncomingCount));
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.NAME, connection.getName()));
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.OWNER, entry.getValue()));
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.DESCRIPTION, connection.getDescription()));
                Date now = new Date();
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.NAME_DATE, now));
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.OWNER_DATE, now));
                this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.DESCRIPTION_DATE, now));
                added.put(flowNode.getUUID(), flowNode);
            }
            allRemoteIncoming.removeAll(added.values());
            sub.setWorkRemaining(added.size() * 2 + allRemoteIncoming.size());
            for (FlowNode flowNode : added.values()) {
                if (sub.isCanceled()) break;
                this.createUpdateArgs(flowNode, added, (IProgressMonitor)sub.newChild(1));
                if (!added.values().contains(flowNode)) continue;
                this.createUpdateArgs(flowNode, (IProgressMonitor)sub.newChild(1));
            }
            sub.setWorkRemaining(allRemoteIncoming.size());
            for (FlowNode incoming : allRemoteIncoming) {
                this.createFlowUpdateArgs(incoming, added, this.getFlowTable(incoming, (IProgressMonitor)sub.newChild(1)));
            }
        }
        return added;
    }

    private int getRemoteIncomingCount(List<IWorkspace> remoteIncomingCollaborations, Set<FlowNode> remoteIncomingFlowNodes) {
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (IWorkspace workspace : remoteIncomingCollaborations) {
            uuids.add(workspace.getItemId());
        }
        for (FlowNode flowNode : remoteIncomingFlowNodes) {
            uuids.add(flowNode.getUUID());
        }
        return uuids.size();
    }

    private Set<FlowNode> getRemoteIncomingFlowNodesFromDiagram(FlowNode target, List<IWorkspace> remoteIncomingCollaborations, IProgressMonitor monitor) {
        List<FlowNode> flowNodes = this.diagram.getFlowNodes();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)flowNodes.size());
        HashSet<UUID> remoteIncomingUUIDs = new HashSet<UUID>();
        for (IWorkspace workspace : remoteIncomingCollaborations) {
            remoteIncomingUUIDs.add(workspace.getItemId());
        }
        HashSet<FlowNode> remoteIncomingFlowNodes = new HashSet<FlowNode>();
        for (FlowNode flowNode : flowNodes) {
            boolean isSource;
            SubMonitor conditionalProgress;
            block9: {
                conditionalProgress = progress.newChild(1).setWorkRemaining(1);
                isSource = false;
                if (remoteIncomingUUIDs.contains(flowNode.getUUID())) {
                    isSource = true;
                } else {
                    try {
                        IFlowEntry entry;
                        if (flowNode.getTeamRepository().equals(this.getUtil().getRepository())) break block9;
                        IFlowTable flowTable = this.getFlowTable(flowNode, (IProgressMonitor)conditionalProgress.newChild(1));
                        for (Object o : flowTable.acceptSources()) {
                            if (!(o instanceof IFlowEntry) || !(entry = (IFlowEntry)o).getFlowNode().getItemId().equals((Object)target.getUUID())) continue;
                            isSource = true;
                            break;
                        }
                        for (Object o : flowTable.deliverTargets()) {
                            if (!(o instanceof IFlowEntry) || !(entry = (IFlowEntry)o).getFlowNode().getItemId().equals((Object)target.getUUID())) continue;
                            isSource = true;
                            break;
                        }
                    }
                    catch (TeamRepositoryException e) {
                        StatusUtil.log((Object)((Object)this), (Throwable)e);
                    }
                }
            }
            if (isSource) {
                remoteIncomingFlowNodes.add(flowNode);
            }
            conditionalProgress.done();
        }
        return remoteIncomingFlowNodes;
    }

    protected abstract FlowNode getFlowNode(IWorkspaceConnection var1);

    protected abstract void addRemoveFlowNodes(Map<UUID, FlowNode> var1);

    protected abstract void createUpdateArgs(FlowNode var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected static List<IWorkspace> getRemoteIncomingCollaborations(ITeamRepository repo, IWorkspaceHandle targetWorkspaceHandle, IProgressMonitor monitor) throws OperationFailedException, TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        IWorkspaceSearchCriteria acceptCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setFlowFilter(targetWorkspaceHandle, 1).setKind(3);
        List acceptHandles = workspaceManager.findWorkspaces(acceptCriteria, Integer.MAX_VALUE, (IProgressMonitor)sub.newChild(1));
        IFetchResult acceptFetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(acceptHandles, 0, (IProgressMonitor)sub.newChild(1));
        IWorkspaceSearchCriteria deliverCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setFlowFilter(targetWorkspaceHandle, 2).setKind(3);
        List deliverHandles = workspaceManager.findWorkspaces(deliverCriteria, Integer.MAX_VALUE, (IProgressMonitor)sub.newChild(1));
        IFetchResult deliverFetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(deliverHandles, 0, (IProgressMonitor)sub.newChild(1));
        ArrayList<IWorkspace> allRemoteIncomingCollaborations = new ArrayList<IWorkspace>(acceptFetchResult.getRetrievedItems().size() + deliverFetchResult.getRetrievedItems().size());
        for (Object o : acceptFetchResult.getRetrievedItems()) {
            if (!(o instanceof IWorkspace)) continue;
            allRemoteIncomingCollaborations.add((IWorkspace)o);
        }
        for (Object o : deliverFetchResult.getRetrievedItems()) {
            if (!(o instanceof IWorkspace)) continue;
            allRemoteIncomingCollaborations.add((IWorkspace)o);
        }
        return allRemoteIncomingCollaborations;
    }

    public static Map<ITeamRepository, List<IWorkspaceHandle>> groupByRepository(Collection<IFlowEntry> flowEntries, ITeamRepository defaultRepo) {
        HashMap<ITeamRepository, List<IWorkspaceHandle>> groupByRepo = new HashMap<ITeamRepository, List<IWorkspaceHandle>>();
        for (IFlowEntry entry : flowEntries) {
            IFlowNodeHandle flowNodeHandle;
            ITeamRepository repo = FlowNodesCommand.getTeamRepository(entry, defaultRepo);
            ArrayList<IWorkspaceHandle> list = (ArrayList<IWorkspaceHandle>)groupByRepo.get(repo);
            if (list == null) {
                list = new ArrayList<IWorkspaceHandle>();
                groupByRepo.put(repo, list);
            }
            if ((flowNodeHandle = entry.getFlowNode()) instanceof IWorkspaceHandle) {
                IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)flowNodeHandle;
                list.add(workspaceHandle);
                continue;
            }
            StatusUtil.log(MultiRepoConnectionQuery.class, (String)flowNodeHandle.toString());
        }
        return groupByRepo;
    }

    public static ITeamRepository getTeamRepository(IFlowEntry entry, ITeamRepository defaultRepo) {
        Object origin;
        ITeamRepository repo = null;
        if (repo == null) {
            String remoteRepositoryURI = entry.getRemoteRepositoryURI();
            UUID remoteRepositoryUUID = entry.getRemoteRepositoryIdentifier();
            if (remoteRepositoryURI != null) {
                if (remoteRepositoryUUID != null) {
                    try {
                        repo = RepositoryUtils.getTeamRepository((UUID)remoteRepositoryUUID, (String)remoteRepositoryURI, (int)0);
                    }
                    catch (TeamRepositoryException teamRepositoryException) {}
                } else {
                    repo = RepositoryUtils.getTeamRepository((String)remoteRepositoryURI);
                }
            }
        }
        if (repo == null && (origin = entry.getFlowNode().getOrigin()) instanceof ITeamRepository) {
            repo = (ITeamRepository)origin;
        }
        if (repo == null) {
            repo = defaultRepo;
        }
        return repo;
    }

    public static List<IWorkspaceConnection> getWorkspaceConnections(ITeamRepository repo, List<IFlowEntry> flowEntries, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)flowEntries.size());
        ArrayList<IWorkspaceConnection> connections = new ArrayList<IWorkspaceConnection>();
        Map<ITeamRepository, List<IWorkspaceHandle>> entries = FlowNodesCommand.groupByRepository(flowEntries, repo);
        for (ITeamRepository repository : entries.keySet()) {
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repository);
            List<IWorkspaceHandle> workspaces = entries.get(repository);
            try {
                List fetched = workspaceManager.getWorkspaceConnections(workspaces, (IProgressMonitor)sub.newChild(entries.values().size()));
                int i = 0;
                while (i < fetched.size()) {
                    IWorkspaceConnection connection = (IWorkspaceConnection)fetched.get(i);
                    if (connection == null) {
                        ItemNotFoundException e = new ItemNotFoundException((IItemHandle)workspaces.get(i));
                        StatusUtil.log(FlowNodesCommand.class, (Throwable)e);
                    } else {
                        connections.add(connection);
                    }
                    ++i;
                }
            }
            catch (TeamRepositoryException e) {
                StatusUtil.log(FlowNodesCommand.class, (Throwable)e);
            }
        }
        return connections;
    }

    public static Map<IWorkspaceConnection, String> getOwnerNames(Collection<IWorkspaceConnection> workspaces, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<ITeamRepository, ArrayList<IWorkspaceConnection>> wsByRepo = new HashMap<ITeamRepository, ArrayList<IWorkspaceConnection>>();
        for (IWorkspaceConnection ws : workspaces) {
            ArrayList<IWorkspaceConnection> conns = (ArrayList<IWorkspaceConnection>)wsByRepo.get(ws.teamRepository());
            if (conns == null) {
                conns = new ArrayList<IWorkspaceConnection>();
                wsByRepo.put(ws.teamRepository(), conns);
            }
            conns.add(ws);
        }
        HashMap<IWorkspaceConnection, String> result = new HashMap<IWorkspaceConnection, String>();
        for (ITeamRepository r : wsByRepo.keySet()) {
            List conns = (List)wsByRepo.get(r);
            ArrayList<IAuditableHandle> ownerHandles = new ArrayList<IAuditableHandle>();
            for (IWorkspaceConnection workspace : conns) {
                ownerHandles.add(workspace.getOwner());
            }
            List owners = r.itemManager().fetchCompleteItems(ownerHandles, 0, monitor);
            int i = 0;
            for (IWorkspaceConnection workspace : conns) {
                IAuditable owner = (IAuditable)owners.get(i++);
                result.put(workspace, FlowNodesCommand.getName(owner));
            }
        }
        return result;
    }

    public static String getName(IAuditable owner) {
        if (owner instanceof IContributor) {
            IContributor contributor = (IContributor)owner;
            return contributor.getName();
        }
        if (owner instanceof IProcessArea) {
            IProcessArea processArea = (IProcessArea)owner;
            return processArea.getName();
        }
        return Messages.FlowNodesCommand_0;
    }

    private void createUpdateArgs(FlowNode flowNode, Map<UUID, FlowNode> adding, IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        IFlowEntry entry;
        IFlowTable flowTable = this.getFlowTable(flowNode, monitor);
        List acceptSources = flowTable.acceptSources();
        List deliverTargets = flowTable.deliverTargets();
        HashMap<UUID, IFlowEntry> allFlowTargets = new HashMap<UUID, IFlowEntry>();
        for (Object o : acceptSources) {
            if (!(o instanceof IFlowEntry)) continue;
            entry = (IFlowEntry)o;
            allFlowTargets.put(entry.getFlowNode().getItemId(), entry);
        }
        for (Object o : deliverTargets) {
            if (!(o instanceof IFlowEntry)) continue;
            entry = (IFlowEntry)o;
            allFlowTargets.put(entry.getFlowNode().getItemId(), entry);
        }
        this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.FLOW_TARGETS_COUNT, flowNode.getFlowTargetsCount(), allFlowTargets.size()));
        this.createCollaborationUpdateArgs(flowNode, adding, allFlowTargets.keySet());
        this.createFlowUpdateArgs(flowNode, adding, flowTable);
    }

    private IFlowTable getFlowTable(FlowNode flowNode, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection workspaceConnection = flowNode.getWorkspaceConnection(monitor);
        IFlowTable flowTable = workspaceConnection.getFlowTable();
        return flowTable;
    }

    private void createCollaborationUpdateArgs(FlowNode flowNode, Map<UUID, FlowNode> adding, Set<UUID> flowTargetUUIDs) throws OperationFailedException, TeamRepositoryException {
        ArrayList<Collaboration> toRemove = new ArrayList<Collaboration>();
        for (Collaboration collaboration : flowNode.getFlowTargetCollaborations()) {
            FlowNode target = (FlowNode)collaboration.getTarget();
            if (adding.containsKey(target.getUUID()) || flowTargetUUIDs.contains(target.getUUID())) continue;
            Collection[] oldValue = FlowVisCommand.addRemove(collaboration, null);
            Collection[] newValue = FlowVisCommand.addRemove(null, collaboration);
            this.add(new UpdateArg(target, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, oldValue, newValue));
            toRemove.add(collaboration);
        }
        if (toRemove.size() > 0) {
            this.add(new UpdateArg(flowNode, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, FlowNodesCommand.addRemove(toRemove, null), FlowNodesCommand.addRemove(null, toRemove)));
        }
        for (UUID uuid : flowTargetUUIDs) {
            boolean addingTarget = false;
            FlowNode targetFlowNode = this.diagram.getFlowNode(uuid);
            if (targetFlowNode == null) {
                targetFlowNode = adding.get(uuid);
                addingTarget = true;
            }
            if (targetFlowNode == null || flowNode.hasOutgoingFlowVisConnection(targetFlowNode)) continue;
            this.updateAddTargetCollaboration(flowNode, targetFlowNode, addingTarget);
        }
        this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.COLLABORATION_DATE, new Date()));
    }

    private void createFlowUpdateArgs(FlowNode flowNode, Map<UUID, FlowNode> adding, IFlowTable flowTable) {
        Date now = new Date();
        this.addFlowUpdateArg(flowNode, adding, FlowNode.PropertyId.DEFAULT_INCOMING_FLOW, flowTable.getDefaultAcceptFlow());
        this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.DEFAULT_INCOMING_FLOW_DATE, now));
        this.addFlowUpdateArg(flowNode, adding, FlowNode.PropertyId.DEFAULT_OUTGOING_FLOW, flowTable.getDefaultDeliverFlow());
        this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.DEFAULT_OUTGOING_FLOW_DATE, now));
        this.addFlowUpdateArg(flowNode, adding, FlowNode.PropertyId.CURRENT_INCOMING_FLOW, flowTable.getCurrentAcceptFlow());
        this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.CURRENT_INCOMING_FLOW_DATE, now));
        this.addFlowUpdateArg(flowNode, adding, FlowNode.PropertyId.CURRENT_OUTGOING_FLOW, flowTable.getCurrentDeliverFlow());
        this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.CURRENT_OUTGOING_FLOW_DATE, now));
    }

    protected void updateAddTargetCollaboration(FlowNode flowNode, FlowNode targetFlowNode, boolean addingTarget) throws OperationFailedException, TeamRepositoryException {
        Collaboration collaboration = new Collaboration(flowNode, targetFlowNode);
        Collection[] oldValue = FlowVisCommand.addRemove(null, collaboration);
        Collection[] newValue = FlowVisCommand.addRemove(collaboration, null);
        this.add(new UpdateArg(targetFlowNode, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, oldValue, newValue));
        this.add(new UpdateArg(flowNode, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, oldValue, newValue));
        if (!addingTarget && !flowNode.getTeamRepository().equals(this.getUtil().getRepository())) {
            int incomingCount = targetFlowNode.getRemoteIncomingCount();
            this.add(new UpdateArg(targetFlowNode, (Object)FlowNode.PropertyId.REMOTE_INCOMING_COUNT, incomingCount, incomingCount + 1));
        }
    }

    private void addFlowUpdateArg(FlowNode flowNode, Map<UUID, FlowNode> adding, FlowNode.PropertyId id, IFlowEntry newFlowEntry) {
        UUID uuid;
        FlowNode newFlow = null;
        if (newFlowEntry != null && (newFlow = this.diagram.getFlowNode(uuid = newFlowEntry.getFlowNode().getItemId())) == null) {
            newFlow = adding.get(uuid);
        }
        this.add(new UpdateArg(flowNode, (Object)id, newFlow));
    }
}

