/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.FlowVisUtil;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowVisCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.editparts.FlowNodeEditPart;
import com.ibm.team.internal.filesystem.ui.views.flowvis.figures.FlowNodeFigure;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Component;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ExpandComponentsCommand
extends FlowVisCommand {
    private FlowNodeEditPart flowNodeEditPart;

    public ExpandComponentsCommand(FlowNodeEditPart flowNodeEditPart) {
        this.flowNodeEditPart = flowNodeEditPart;
        FlowNode flowNode = (FlowNode)flowNodeEditPart.getModel2();
        boolean componentsExpanded = flowNode.isComponentsExpanded();
        String label = componentsExpanded ? Messages.ExpandComponentsCommand_0 : Messages.ExpandComponentsCommand_1;
        this.setLabel(label);
    }

    private void createArg(IProgressMonitor monitor) throws TeamRepositoryException, OperationFailedException {
        FlowNode flowNode = (FlowNode)this.flowNodeEditPart.getModel2();
        List<UpdateArg> updates = ExpandComponentsCommand.getComponents(flowNode, monitor);
        for (UpdateArg updateArg : updates) {
            this.add(updateArg);
        }
        this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.COMPONENTS_EXPANDED, false, true));
    }

    public static List<UpdateArg> getComponents(FlowNode flowNode, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        HashMap<UUID, IComponent> refreshedComponents = new HashMap<UUID, IComponent>();
        IWorkspaceConnection workspaceConnection = flowNode.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
        IItemManager itemManager = flowNode.getTeamRepository().itemManager();
        IFetchResult result = itemManager.fetchCompleteItemsPermissionAware(workspaceConnection.getComponents(), 0, (IProgressMonitor)progress.newChild(1));
        for (Object o : result.getRetrievedItems()) {
            if (!(o instanceof IComponent)) continue;
            IComponent iComponent = (IComponent)o;
            refreshedComponents.put(iComponent.getItemId(), iComponent);
        }
        HashMap<Object, Component> validComponentsInModel = new HashMap<Object, Component>();
        ArrayList<Component> toRemove = new ArrayList<Component>();
        for (Component component : flowNode.getComponents()) {
            UUID uuid = component.getUUID();
            if (!refreshedComponents.containsKey(uuid)) {
                toRemove.add(component);
                continue;
            }
            validComponentsInModel.put(uuid, component);
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (IComponent component : refreshedComponents.values()) {
            UUID uuid = component.getItemId();
            if (validComponentsInModel.containsKey(uuid)) continue;
            Component newComponent = new Component(flowNode, component);
            arrayList.add(newComponent);
            validComponentsInModel.put(uuid, newComponent);
        }
        ArrayList<UpdateArg> updates = new ArrayList<UpdateArg>();
        Date now = new Date();
        for (IComponent component : refreshedComponents.values()) {
            Component componentModel = (Component)validComponentsInModel.get(component.getItemId());
            updates.add(new UpdateArg(componentModel, (Object)Component.PropertyId.NAME, component.getName()));
            updates.add(new UpdateArg(componentModel, (Object)Component.PropertyId.NAME_DATE, now));
        }
        updates.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.COMPONENTS, ExpandComponentsCommand.addRemove(toRemove, arrayList), ExpandComponentsCommand.addRemove(arrayList, toRemove)));
        updates.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.COMPONENT_COUNT, refreshedComponents.size()));
        updates.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.COMPONENTS_DATE, now));
        return updates;
    }

    @Override
    protected void createAndExecute() {
        final FlowNode flowNode = (FlowNode)this.flowNodeEditPart.getModel2();
        final FlowNodeFigure flowNodeFigure = (FlowNodeFigure)this.flowNodeEditPart.getFigure2();
        FlowVisUtil util = flowNode.getDiagram().getUtil();
        IOperationRunner runner = util.getOperationRunner();
        final Display display = util.getDisplay();
        boolean componentsExpanded = flowNode.isComponentsExpanded();
        if (!componentsExpanded && !flowNode.isComponentsLoaded()) {
            flowNodeFigure.setBusy(true);
            Rectangle constraint = flowNode.getConstraint();
            constraint.setSize(flowNodeFigure.getPreferredSize());
            flowNode.setPropertyValue((Object)FlowNode.PropertyId.CONSTRAINT, constraint);
            ITeamRepository flowNodeRepo = null;
            try {
                flowNodeRepo = flowNode.getTeamRepository();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            runner.enqueue(Messages.ExpandComponentsCommand_2, (Operation)new RepositoryOperation(flowNodeRepo){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    monitor.setTaskName(Messages.ExpandComponentsCommand_2);
                    try {
                        ExpandComponentsCommand.this.createArg(monitor);
                    }
                    catch (Throwable throwable) {
                        SWTUtil.greedyExec((Display)display, (Runnable)new Runnable(flowNodeFigure, flowNode){
                            private final /* synthetic */ FlowNodeFigure val$flowNodeFigure;
                            private final /* synthetic */ FlowNode val$flowNode;
                            {
                                this.val$flowNodeFigure = flowNodeFigure;
                                this.val$flowNode = flowNode;
                            }

                            @Override
                            public void run() {
                                this.val$flowNodeFigure.setBusy(false);
                                this.val$flowNode.setComponentsLoaded(true);
                                ExpandComponentsCommand.this.execute();
                            }
                        });
                        throw throwable;
                    }
                    SWTUtil.greedyExec((Display)display, (Runnable)new /* invalid duplicate definition of identical inner class */);
                }
            });
        } else {
            flowNode.setPropertyValue((Object)FlowNode.PropertyId.COMPONENTS_EXPANDED, !componentsExpanded);
        }
    }
}

