/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.AddConnectionsCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs.NewStreamDialog;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;

public class CreateWorkspaceCommand
extends AddConnectionsCommand {
    private boolean isStream;
    private FlowNode template;

    public CreateWorkspaceCommand(boolean isStream, FlowNode template) {
        this(isStream, template.getConstraint().getLocation());
        this.template = template;
    }

    public CreateWorkspaceCommand(boolean isStream, Point location) {
        this.setLocation(location);
        this.isStream = isStream;
    }

    @Override
    protected List<? extends IFlowEntry> getHandles(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection templateConnection;
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ITeamRepository repo = this.getDiagram().getUtil().getRepository();
        IWorkspaceConnection connection = null;
        IWorkspaceConnection iWorkspaceConnection = templateConnection = this.template == null ? null : this.template.getWorkspaceConnection((IProgressMonitor)sub.newChild(1));
        if (this.isStream) {
            final String initialValue = templateConnection == null ? Messages.CreateWorkspaceCommand_0 : templateConnection.getName();
            final String[] nameArray = new String[1];
            final IProcessArea[] areaArray = new IProcessArea[1];
            this.getDiagram().getUtil().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    NewStreamDialog dialog = new NewStreamDialog(CreateWorkspaceCommand.this.getDiagram().getUtil().getShell(), initialValue);
                    dialog.setInput(repo);
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        nameArray[0] = dialog.getName();
                        areaArray[0] = dialog.getSelectedProcessArea();
                    }
                }
            });
            String name = nameArray[0];
            IProcessArea area = areaArray[0];
            if (name != null) {
                connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createStream((IProcessAreaHandle)area, name, "", (IProgressMonitor)sub.newChild(1));
                if (templateConnection != null) {
                    IFlowNodeConnection.IComponentOpFactory factory = connection.componentOpFactory();
                    ArrayList<IFlowNodeConnection.IComponentAdditionOp> compAdds = new ArrayList<IFlowNodeConnection.IComponentAdditionOp>();
                    for (Object o : templateConnection.getComponents()) {
                        if (!(o instanceof IComponentHandle)) continue;
                        IComponentHandle handle = (IComponentHandle)o;
                        compAdds.add(factory.addComponent(handle, (IConnection)templateConnection, false));
                    }
                    connection.applyComponentOperations(compAdds, (IProgressMonitor)sub.newChild(1));
                    if (templateConnection.isStream()) {
                        CreateWorkspaceCommand.addTemplateFlows(connection, templateConnection, (IProgressMonitor)sub.newChild(1));
                    } else {
                        FlowUtils.addFlowTarget((IWorkspaceConnection)templateConnection, (IWorkspaceConnection)connection, (templateConnection.getFlowTable().getCurrentAcceptFlow() == null ? 1 : 0) != 0, (IProgressMonitor)sub.newChild(1));
                    }
                }
            }
        } else {
            IContributor owner = repo.loggedInContributor();
            String initialValue = templateConnection == null ? NLS.bind((String)Messages.CreateWorkspaceCommand_2, (Object)owner.getName()) : templateConnection.getName();
            final InputDialog dialog = new InputDialog(this.getDiagram().getUtil().getShell(), Messages.CreateWorkspaceCommand_3, Messages.CreateWorkspaceCommand_4, initialValue, new IInputValidator(){

                public String isValid(String newText) {
                    if (newText == null || newText.length() == 0) {
                        return Messages.CreateWorkspaceCommand_5;
                    }
                    return null;
                }
            });
            dialog.setBlockOnOpen(true);
            this.getDiagram().getUtil().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
            if (dialog.getReturnCode() == 0) {
                String name = dialog.getValue();
                if (templateConnection != null) {
                    connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createWorkspace((IContributorHandle)owner, name, "", (IWorkspaceConnection)(templateConnection.isStream() ? templateConnection : null), templateConnection, (IProgressMonitor)sub.newChild(1));
                    CreateWorkspaceCommand.addTemplateFlows(connection, templateConnection, (IProgressMonitor)sub.newChild(1));
                } else {
                    connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).createWorkspace((IContributorHandle)owner, name, "", (IProgressMonitor)sub.newChild(1));
                }
            }
        }
        if (connection != null) {
            this.addWorkspace((IWorkspaceHandle)connection.getResolvedWorkspace());
        }
        sub.setWorkRemaining(99);
        return super.getHandles((IProgressMonitor)sub.newChild(99));
    }

    @Override
    protected void updateAddTargetCollaboration(FlowNode flowNode, FlowNode targetFlowNode, boolean addingTarget) throws OperationFailedException, TeamRepositoryException {
        super.updateAddTargetCollaboration(flowNode, targetFlowNode, addingTarget);
        int count = targetFlowNode.getRemoteIncomingCount() + 1;
        this.add(new UpdateArg(targetFlowNode, (Object)FlowNode.PropertyId.REMOTE_INCOMING_COUNT, count));
    }

    private static void addTemplateFlows(IWorkspaceConnection target, IWorkspaceConnection templateSource, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowNodeHandle flowNode;
        IFlowEntry entry;
        IFlowTable flowTable = target.getFlowTable().getWorkingCopy();
        IFlowTable streamFlowTable = templateSource.getFlowTable();
        for (Object o : streamFlowTable.deliverTargets()) {
            if (!(o instanceof IFlowEntry)) continue;
            entry = (IFlowEntry)o;
            flowNode = entry.getFlowNode();
            flowTable.addDeliverFlow(flowNode, entry.getRemoteRepositoryIdentifier(), entry.getRemoteRepositoryURI(), (Collection)Collections.EMPTY_LIST, null);
            flowTable.setComponentScopes(flowNode, streamFlowTable.getComponentScopes(flowNode));
        }
        for (Object o : streamFlowTable.acceptSources()) {
            if (!(o instanceof IFlowEntry)) continue;
            entry = (IFlowEntry)o;
            flowNode = entry.getFlowNode();
            flowTable.addAcceptFlow(flowNode, entry.getRemoteRepositoryIdentifier(), entry.getRemoteRepositoryURI(), (Collection)Collections.EMPTY_LIST, null);
            flowTable.setComponentScopes(flowNode, streamFlowTable.getComponentScopes(flowNode));
        }
        if (flowTable.acceptSources().size() == 1) {
            IFlowEntry entry2 = (IFlowEntry)flowTable.acceptSources().iterator().next();
            IFlowEntry acceptFlow = flowTable.getAcceptFlow(entry2.getFlowNode());
            flowTable.setCurrent(acceptFlow);
            flowTable.setDefault(acceptFlow);
        } else if (!target.isStream() && templateSource.isStream()) {
            flowTable.setCurrent(flowTable.getAcceptFlow((IFlowNodeHandle)templateSource.getResolvedWorkspace()));
            flowTable.setDefault(flowTable.getAcceptFlow((IFlowNodeHandle)templateSource.getResolvedWorkspace()));
        } else {
            IFlowEntry currentDefaultFlow;
            IFlowEntry currentAcceptFlow = streamFlowTable.getCurrentAcceptFlow();
            if (currentAcceptFlow != null) {
                flowTable.setCurrent(flowTable.getAcceptFlow(currentAcceptFlow.getFlowNode()));
            }
            if ((currentDefaultFlow = streamFlowTable.getDefaultAcceptFlow()) != null) {
                flowTable.setDefault(flowTable.getAcceptFlow(currentDefaultFlow.getFlowNode()));
            }
        }
        target.setFlowTable(flowTable, monitor);
    }
}

