/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowVisCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisConnection;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import java.util.Collection;

public class ConnectionCommand
extends FlowVisCommand {
    private FlowVisNode oldSource;
    private FlowVisNode newSource;
    private FlowVisNode oldTarget;
    private FlowVisNode newTarget;
    private FlowVisConnection connection;

    public ConnectionCommand(FlowVisConnection connection, String label) {
        this.connection = connection;
        this.oldSource = connection.getSource();
        this.oldTarget = connection.getTarget();
        this.setLabel(label);
    }

    public static boolean canExecute(FlowVisNode source, FlowVisNode target) {
        if (source != null) {
            if (source.equals(target)) {
                return false;
            }
            for (FlowVisConnection c : source.getOutgoingFlowVisConnections()) {
                if (!c.getTarget().equals(target)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canExecute() {
        return ConnectionCommand.canExecute(this.oldSource, this.newTarget);
    }

    @Override
    protected void createAndExecute() {
        this.add(new UpdateArg(this.connection, (Object)FlowVisConnection.PropertyId.SOURCE, this.oldSource, this.newSource));
        this.add(new UpdateArg(this.connection, (Object)FlowVisConnection.PropertyId.TARGET, this.oldTarget, this.newTarget));
        Collection[] add = ConnectionCommand.addRemove(this.connection, null);
        Collection[] remove = ConnectionCommand.addRemove(null, this.connection);
        if (this.oldTarget != null) {
            this.add(new UpdateArg(this.oldTarget, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, add, remove));
        }
        if (this.newSource != null) {
            this.add(new UpdateArg(this.newSource, (Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, remove, add));
        }
        if (this.newTarget != null) {
            this.add(new UpdateArg(this.newTarget, (Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, remove, add));
        }
        this.execute();
    }

    public void setNewSource(FlowVisNode newSource) {
        this.newSource = newSource;
    }

    public void setNewTarget(FlowVisNode newTarget) {
        this.newTarget = newTarget;
    }

    public FlowVisNode getNewSource() {
        return this.newSource;
    }

    public FlowVisNode getOldSource() {
        return this.oldSource;
    }

    public FlowVisNode getOldTarget() {
        return this.oldTarget;
    }
}

