/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.filesystem.client.internal.utils.FlowTableUtil;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowVisCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.SetFlowTargetCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.Collaboration;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisConnection;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AddRemoveCollaborationCommand
extends SetFlowTargetCommand {
    private Collaboration collaboration;
    private boolean add;
    private boolean setCurrent;
    private IWorkspaceConnection oldCurrent;

    public AddRemoveCollaborationCommand(Collaboration collaboration, boolean add, boolean setCurrent) {
        super((FlowNode)collaboration.getSource(), (FlowNode)collaboration.getTarget());
        this.collaboration = collaboration;
        this.add = add;
        this.setCurrent = setCurrent;
        if (add) {
            this.setLabel(Messages.AddRemoveCollaborationCommand_0);
        } else {
            this.setLabel(Messages.AddRemoveCollaborationCommand_1);
        }
    }

    public AddRemoveCollaborationCommand(Collaboration collaboration, boolean add) {
        this(collaboration, add, false);
    }

    public FlowNode getSource() {
        return (FlowNode)this.collaboration.getSource();
    }

    @Override
    public void setTarget(FlowNode target) {
        super.setTarget(target);
        this.collaboration.setPropertyValue((Object)FlowVisConnection.PropertyId.TARGET, target);
    }

    @Override
    protected void setPropertyValue(FlowNode flowNode, boolean redo) {
        Collection[] addRemove = null;
        int flowTargetsCount = this.getFlowNode().getFlowTargetsCount();
        int remoteIncomingCount = this.getTarget().getRemoteIncomingCount();
        if (this.add == redo) {
            addRemove = FlowVisCommand.addRemove(this.collaboration, null);
            ++flowTargetsCount;
            ++remoteIncomingCount;
        } else {
            addRemove = FlowVisCommand.addRemove(null, this.collaboration);
            --flowTargetsCount;
            --remoteIncomingCount;
        }
        Date now = new Date();
        this.getFlowNode().setPropertyValue((Object)FlowVisNode.PropertyId.OUTGOING_CONNECTION, addRemove);
        this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.FLOW_TARGETS_COUNT, flowTargetsCount);
        this.getTarget().setPropertyValue((Object)FlowVisNode.PropertyId.INCOMING_CONNECTION, addRemove);
        this.getTarget().setPropertyValue((Object)FlowNode.PropertyId.REMOTE_INCOMING_COUNT, remoteIncomingCount);
        this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.COLLABORATION_DATE, now);
        this.getTarget().setPropertyValue((Object)FlowNode.PropertyId.COLLABORATION_DATE, now);
        IWorkspaceConnection connection = this.getFlowNode().getWorkspaceConnection();
        if (connection != null) {
            IFlowTable flowTable = connection.getFlowTable();
            IFlowEntry currentAcceptFlow = flowTable.getCurrentAcceptFlow();
            FlowNode currentIncomingFlowNode = currentAcceptFlow == null ? null : this.getDiagram().getFlowNode(currentAcceptFlow.getFlowNode().getItemId());
            this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.CURRENT_INCOMING_FLOW, currentIncomingFlowNode);
            this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.CURRENT_INCOMING_FLOW_DATE, now);
            IFlowEntry currentDeliverFlow = flowTable.getCurrentDeliverFlow();
            FlowNode currentOutgoingFlowNode = currentDeliverFlow == null ? null : this.getDiagram().getFlowNode(currentDeliverFlow.getFlowNode().getItemId());
            this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.CURRENT_OUTGOING_FLOW, currentOutgoingFlowNode);
            this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.CURRENT_OUTGOING_FLOW_DATE, now);
            IFlowEntry defaultIncomingFlow = flowTable.getDefaultAcceptFlow();
            FlowNode defaultIncomingFlowNode = defaultIncomingFlow == null ? null : this.getDiagram().getFlowNode(defaultIncomingFlow.getFlowNode().getItemId());
            this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.DEFAULT_INCOMING_FLOW, defaultIncomingFlowNode);
            this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.DEFAULT_INCOMING_FLOW_DATE, now);
            IFlowEntry defaultOutgoingFlow = flowTable.getDefaultDeliverFlow();
            FlowNode defaultOutgoingFlowNode = defaultOutgoingFlow == null ? null : this.getDiagram().getFlowNode(defaultOutgoingFlow.getFlowNode().getItemId());
            this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.DEFAULT_OUTGOING_FLOW, defaultOutgoingFlowNode);
            this.getFlowNode().setPropertyValue((Object)FlowNode.PropertyId.DEFAULT_OUTGOING_FLOW_DATE, now);
        }
    }

    @Override
    protected String getTaskName(boolean redo) {
        if (this.add == redo) {
            return Messages.AddRemoveCollaborationCommand_2;
        }
        return Messages.AddRemoveCollaborationCommand_3;
    }

    @Override
    protected FlowNode getUndoValue() {
        return this.getTarget();
    }

    @Override
    protected void redoFlowTarget(IFlowTable flowTable, IWorkspaceConnection source, IWorkspaceConnection target, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.add) {
            this.add(flowTable, source, target, monitor);
        } else {
            this.remove(flowTable, source, target, monitor);
        }
    }

    private void add(IFlowTable flowTable, IWorkspaceConnection source, IWorkspaceConnection target, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.setCurrent = this.setCurrent || flowTable.getCurrentAcceptFlow() == null;
        FlowTableUtil.addCollaboration((IFlowTable)flowTable, (IWorkspaceConnection)source, (IWorkspaceConnection)target);
        if (this.setCurrent) {
            IFlowEntry currentFlowEntry = flowTable.getCurrentAcceptFlow();
            if (currentFlowEntry != null) {
                String repositoryURI = currentFlowEntry.getRemoteRepositoryURI();
                ITeamRepository repo = null;
                repo = repositoryURI != null ? TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI) : source.teamRepository();
                IFlowNodeHandle flowEntryHandle = currentFlowEntry.getFlowNode();
                if (flowEntryHandle instanceof IWorkspaceHandle) {
                    this.oldCurrent = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)flowEntryHandle, (IProgressMonitor)progress.newChild(50));
                }
            }
            progress.setWorkRemaining(50);
            IWorkspace workspace = target == null ? null : target.getResolvedWorkspace();
            FlowTableUtil.setCurrentCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)workspace);
            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceCollaboration((IWorkspaceHandle)source.getResolvedWorkspace(), target, false, (IProgressMonitor)progress.newChild(50));
        }
    }

    @Override
    protected void undoFlowTarget(IFlowTable flowTable, IWorkspaceConnection source, IWorkspaceConnection target, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.add) {
            this.remove(flowTable, source, target, monitor);
        } else {
            this.add(flowTable, source, target, monitor);
        }
    }

    private void remove(IFlowTable flowTable, IWorkspaceConnection source, IWorkspaceConnection target, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspace workspace = target == null ? null : target.getResolvedWorkspace();
        FlowTableUtil.removeCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)workspace);
        if (this.setCurrent && this.oldCurrent != null) {
            FlowTableUtil.setCurrentCollaboration((IFlowTable)flowTable, (IWorkspaceHandle)this.oldCurrent.getResolvedWorkspace());
            FileSystemResourcesPlugin.getActiveWorkspaceManager().setWorkspaceCollaboration((IWorkspaceHandle)source.getResolvedWorkspace(), this.oldCurrent, false, monitor);
        }
    }
}

