/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowNodesCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.FlowVisCommand;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.UpdateArg;
import com.ibm.team.internal.filesystem.ui.views.flowvis.dialogs.AddConnectionDialog;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowNode;
import com.ibm.team.internal.filesystem.ui.views.flowvis.model.FlowVisDiagram;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IFlowEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public abstract class AddFlowNodesCommand
extends FlowNodesCommand {
    @Override
    protected Map<IWorkspaceConnection, String> filterAndGetNames(Collection<? extends IFlowEntry> workspaces, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        FlowVisDiagram diagram = this.getDiagram();
        List<FlowNode> flowNodes = diagram.getFlowNodes();
        HashMap<UUID, IFlowEntry> toShow = new HashMap<UUID, IFlowEntry>();
        for (IFlowEntry iFlowEntry : workspaces) {
            toShow.put(iFlowEntry.getFlowNode().getItemId(), iFlowEntry);
        }
        for (FlowNode flowNode : flowNodes) {
            toShow.remove(flowNode.getUUID());
        }
        int n = diagram.getWarnAddingFlowNodes();
        Map<IWorkspaceConnection, String> connections = null;
        if (n >= 0 && toShow.size() > n) {
            AddConnectionDialog wizard = new AddConnectionDialog(toShow.values(), this.getUtil().getRepository(), (IOperationRunner)new JobRunner(true), this.queryStreamsFirst());
            final WizardDialog dialog = new WizardDialog(diagram.getUtil().getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            diagram.getUtil().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    dialog.open();
                }
            });
            if (dialog.getReturnCode() != 0) {
                return null;
            }
            connections = wizard.getSelection();
        } else {
            List<IWorkspaceConnection> workspaceConnections = AddFlowNodesCommand.getWorkspaceConnections(this.getUtil().getRepository(), new ArrayList<IFlowEntry>(toShow.values()), (IProgressMonitor)sub.newChild(1));
            connections = AddFlowNodesCommand.getOwnerNames(workspaceConnections, (IProgressMonitor)sub.newChild(1));
        }
        return connections;
    }

    @Override
    protected FlowNode getFlowNode(IWorkspaceConnection connection) {
        return new FlowNode(this.getDiagram(), connection);
    }

    @Override
    protected void addRemoveFlowNodes(Map<UUID, FlowNode> flowNodes) {
        Collection[] c = new Collection[]{flowNodes.values(), Collections.EMPTY_LIST, Collections.singleton(this.getLocation())};
        this.add(new UpdateArg(this.getDiagram(), (Object)FlowVisDiagram.PropertyId.FLOW_NODES, FlowVisCommand.addRemove(null, flowNodes.values()), c));
    }

    @Override
    protected void createUpdateArgs(FlowNode flowNode, IProgressMonitor monitor) {
        Point location = this.getLocation();
        this.add(new UpdateArg(flowNode, (Object)FlowNode.PropertyId.CONSTRAINT, new Rectangle(location.x, location.y, -1, -1)));
    }

    protected Point getLocation() {
        return new Point(16, 16);
    }
}

