/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.views.flowvis.commands;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.flowvis.commands.AddFlowNodesCommand;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.FlowEntry;
import com.ibm.team.scm.common.internal.RemoteDescriptor;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.draw2d.geometry.Point;

public class AddConnectionsCommand
extends AddFlowNodesCommand {
    private Point location;
    private Map<UUID, IProcessAreaHandle> processAreasMap = new HashMap<UUID, IProcessAreaHandle>();
    private Map<UUID, IWorkspaceHandle> workspacesMap = new HashMap<UUID, IWorkspaceHandle>();

    public void addProcessArea(IProcessAreaHandle processArea) {
        this.processAreasMap.put(processArea.getItemId(), processArea);
    }

    public void addWorkspace(IWorkspaceHandle workspace) {
        this.workspacesMap.put(workspace.getItemId(), workspace);
    }

    public int workspacesSize() {
        return this.workspacesMap.size();
    }

    @Override
    protected List<? extends IFlowEntry> getHandles(IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkspace> workspaces = new ArrayList<IWorkspace>(AddConnectionsCommand.getStreamsOwnedByProcessAreas(this.getUtil().getRepository(), this.processAreasMap.values(), monitor));
        workspaces.addAll(this.workspacesMap.values());
        ArrayList<FlowEntry> flowNodes = new ArrayList<FlowEntry>();
        for (Object e : workspaces) {
            FlowEntry entry = ScmFactory.eINSTANCE.createFlowEntry();
            entry.setTargetWorkspace((IWorkspaceHandle)e);
            RemoteDescriptor desc = ScmFactory.eINSTANCE.createRemoteDescriptor();
            desc.setRepoURI(this.getUtil().getRepository().getRepositoryURI());
            desc.setRepoRoot(this.getUtil().getRepository().getId());
            entry.setRemoteDescriptor(desc);
            flowNodes.add(entry);
        }
        return flowNodes;
    }

    @Override
    protected String getTaskName() {
        return Messages.ShowFlowVisAction_ShowingFlowsJobName;
    }

    private static List<IWorkspace> getStreamsOwnedByProcessAreas(ITeamRepository repo, Collection<IProcessAreaHandle> processAreas, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processAreas.isEmpty()) {
            return Collections.emptyList();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceSearchCriteria criteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setKind(1);
        criteria.getFilterByOwnerOptional().addAll(processAreas);
        IWorkspaceManager mgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        List handles = mgr.findWorkspaces(criteria, Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(50));
        IFetchResult result = repo.itemManager().fetchCompleteItemsPermissionAware(handles, 0, (IProgressMonitor)progress.newChild(50));
        ArrayList<IWorkspace> streams = new ArrayList<IWorkspace>(result.getRetrievedItems().size());
        for (Object o : result.getRetrievedItems()) {
            if (!(o instanceof IWorkspace)) continue;
            streams.add((IWorkspace)o);
        }
        return streams;
    }

    public void setLocation(Point location) {
        this.location = location;
    }

    @Override
    protected Point getLocation() {
        if (this.location != null) {
            return this.location;
        }
        return super.getLocation();
    }
}

